---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by Zero.
--- DateTime: 2019-05-25 16:53
---

local function proxy_kvo_key(trackKey)
    return ("_kvo_" .. trackKey)
end

local function proxy_addObserverCallbackForKey(proxy, key, callback)
    if not key then
        return
    end

    local kvokey = proxy_kvo_key(key)
    --local callbackFuncs = proxy[kvokey]
    local callbackFuncs = proxy.observers[kvokey]
    if not callbackFuncs then
        callbackFuncs = {}
        --proxy[kvokey] = callbackFuncs
        proxy.observers[kvokey] = callbackFuncs
    end
    table.insert(callbackFuncs, callback)
end

--以`.`来分割keyPath字符串
local function splitKeyPathWithDot(keypath)
    assert(type(keypath) == "string")
    local words = {}
    for s in string.gmatch(keypath, "[^.]+") do
        table.insert(words, s)
    end
    return words
end

--valueChangeFunc(key, oldValue, newValue)
--http://lua-users.org/wiki/GeneralizedPairsAndIpairs
--- @public 创建观察者
--- @param tbl table表
--- @param trackKey 想要监听的key
--- @param valueChangeFunc 属性被赋值后的回调
--- @return table 代理table
function kvo_observeForKey(tbl, trackKey, valueChangeFunc)
    if not tbl or type(tbl) ~= "table" then
        assert(false, "只支持监听table")
        return tbl
    end

    if type(trackKey) == "number" then
        trackKey = tostring(trackKey)
    end

    local keys = splitKeyPathWithDot(trackKey)
    --移除并获取最后的key
    trackKey = table.remove(keys)

    local lastSecondTbl = tbl
    local lastKey = nil
    for i, v in ipairs(keys) do
        --print(string.rep("*", 5), i, v, type(tbl))
        local index = i
        if i > 1 then
            index = i - 1
        end
        assert(type(tbl) == "table", string.format("keypath 中的 %s 不是table", keys[index]))

        tbl = tbl[v]

        if i == #keys - 1 then
            lastSecondTbl = tbl
        elseif i == #keys then
            lastKey = v
        end
    end

    --说明当前的tbl就是proxy, 添加完观察者后直接返回
    if tbl.is_kvo_proxy then
        proxy_addObserverCallbackForKey(tbl, trackKey, valueChangeFunc)
        return tbl
    end

    --建一个空表
    local proxy = {
        is_kvo_proxy = true,
        observers = {}
    }

    --更新上一级的表的关系
    if lastSecondTbl and lastKey then
        lastSecondTbl[lastKey] = proxy
    end

    proxy_addObserverCallbackForKey(proxy, trackKey, valueChangeFunc)

    local proxy_metable = {
        __index = function(_, k)
            return tbl[k]
        end,

        __newindex = function(_, k, v)
            if not k then
                print("lua_kvo => key为nil : ", k)
            end

            local oldValue = tbl[k]
            tbl[k] = v
            local kvokey = proxy_kvo_key(k)
            if proxy.observers[kvokey] then
                for i, callback in ipairs(proxy.observers[kvokey]) do
                    callback(k, oldValue, v)
                    --print("lua_kvo => set, key = ", k, "oldValue = ", oldValue, "newValue = ", v)
                end
            end

            kvokey = proxy_kvo_key("KVO_ALL")
            if proxy.observers[kvokey] then
                for _, callback in ipairs(proxy.observers[kvokey]) do
                    callback(k, oldValue, v)
                end
            end
        end,

        __pairs = function()
            return function(_, k)
                local nextkey, nextvalue = next(tbl, k)
                --print("lua_kvo => pairs: ", nextkey, nextvalue)
                return nextkey, nextvalue
            end
        end,

        __ipairs = function()
            local function iter(t, i)
                i = i + 1
                local v = t[i]
                --v = nil时循环结束
                if v then
                    return i, v
                end
            end
            return iter, tbl, 0
        end,

        __len = function()
            return #tbl
        end
    }

    local rawnext = next
    function next(t,k)
        local m = getmetatable(t)
        local n = m and m.__next or rawnext
        return n(t,k)
    end

    function pairs(t)
        return next, t, nil
    end

    proxy_metable.__next = function(t, k)
        return next(tbl, k)
    end

    local function _ipairs(t, var)
        var = var + 1
        local value = t[var]
        if value == nil then return end
        return var, value
    end

    function ipairs(t)
        return _ipairs, t, 0
    end

    setmetatable(proxy, proxy_metable)

    return proxy
end

--- @public 移除观察者
--- @param proxy 初始table的代理(添加观察者后生成的那个proxy)
--- @param key 想要移除监听的key
function kvo_removeObserveForKey(proxy, key)
    if not key or not proxy then
        return
    end

    if type(key) == "number" then
        key = tostring(key)
    end

    local keys = splitKeyPathWithDot(key)
    --移除并获取最后的key
    key = table.remove(keys)

    for i, v in ipairs(keys) do
        local index = i
        if i > 1 then
            index = i - 1
        end
        assert(type(proxy) == "table", string.format("keypath 中的 %s 不是table", keys[index]))
        proxy = proxy[v]
    end

    local kvokey = proxy_kvo_key(key)
    local callbackFuncs = proxy.observers[kvokey]
    if callbackFuncs then
        local count = #callbackFuncs
        for i = 1, count do
            table.remove(callbackFuncs)
        end
    end
    proxy.observers[kvokey] = nil;
end

