---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by deepak.
--- DateTime: 2020-03-11 10:06
---
require("KVO")

local DataBind = {}

function DataBind:new(o)
    o = o or {}
    setmetatable(o, self)
    self.__index = self
    o.callbacks = {}
    o.bindLists = {}
    return o
end



function DataBind:bind(k, f)
    local keys,path = mysplit(k, ".")
    local bindKey = keys[1]
    local bindValue = self[bindKey]
    kvo_observeForKey(bindValue, path, function(k, old, new)
        f(new, old)
    end)
end

function DataBind:mock(k, t)
    if not t then
        t = {}
    end

    local table = kvo_observeForKey(t, "KVO_ALL", function(k, old, new)
        --print("unused observer ",k,old,new)
    end)

    if k then
        self[k] = table
    end
    return table
end

function mysplit (inputstr, sep)
    if sep == nil then
        sep = "%s"
    end
    local t={}
    for str in string.gmatch(inputstr, "([^"..sep.."]+)") do
        table.insert(t, str)
    end

    local path = ""
    for i = 2, #t do
        path = path..t[i]
    end
    return t,path
end

function DataBind:get(k)
    local paths = mysplit(k, '.')
    return self:_getFor(paths, self)
end

function DataBind:_getFor(t, object)
    local old = object
    for i, v in ipairs(t) do
        local table = old
        if i == #t then
            return table[v]
        end
        old = old[v]
    end
end

function DataBind:update(k, new)
    local t = mysplit(k, '.')
    local old = self
    for i, v in ipairs(t) do
        local table = old
        old = old[v]
        if i == #t then
            table[v] = new
        end
    end
end


-- List

-- 绑定列表
--DataBinding:bindListView("source", tableView)
---- 获取section数
--DataBinding:getSectionCount("source")
---- 获取row数
--DataBinding:getRowCount("source", section)
---- 获取复用Id
--DataBinding:getReuseId("source", section, row)
---- 获取height
--DataBinding:getHeight("source", section, row)
---- 获取model
--DataBindding:getModel("source", section, row, "isOpen")
--DataBindding:getModel("source", section, row)

function DataBind:changeToObservable(table, action)
    if table == nil then
        return false
    end
    for k, v in pairs(table) do
        if type(v) == "table" then
            table[k] = self:changeToObservable(v, action)
        end
    end
    return kvo_observeForKey(table, "KVO_ALL", action)
end

function DataBind:is2D(array)
    if array[1] ~= nil and array[1][1] ~= nil then
        return true
    end
    return false
end

function DataBind:mockArray(key, array, info)

    local function action(k, new, old)
        local list = self.bindLists[key]
        print("change ", list, k, new, old)
    end

    local table = self:changeToObservable(array, action)
    self.callbacks[key] = info
    self[key] = table
    return table
end

function DataBind:bindListView(key,list)
    self.bindLists[key] = list
end

function DataBind:getSectionCount(key)
    local bindValue = self[key]

    if self:is2D(bindValue) then
        return getmetatable(bindValue).__len()
    end
    return 1
end

function DataBind:getRowCount(key, section)
    local bindValue = self[key]
    if self:is2D(bindValue) then
        return getmetatable(bindValue[section].__len())
    end
    return getmetatable(bindValue).__len()
end

function DataBind:getReuseId(key, section, row)
    local f = self.callbacks[key].reuseId
    f(section, row)
end

function DataBind:getHeight(key, section, row)
    local f = self.callbacks[key].height
    f(section, row)
end

function DataBind:getModel(key, seciton, row, path)
    local bindValue = self[key]
    local item
    if self:is2D(bindValue) then
        item = bindValue[seciton][row]
    else
        item = bindValue[row]
    end

    local paths = mysplit(path, ".")
    local r = self:_getFor(paths, item)
    return r
end

return DataBind