
#include <jni.h>
#include <stdio.h>

extern int *blur_ARGB_8888(int *pix, int w, int h, int radius);

JNIEXPORT jintArray JNICALL Java_com_immomo_mlservics_weight_utils_NativeBlur_blur
  (JNIEnv *env, jclass cls, jintArray pixels, jint w, jint h, jint radius) {
    jint *nps = (*env)->GetIntArrayElements(env, pixels, 0);
    jsize len = (*env)->GetArrayLength(env, pixels);

    blur_ARGB_8888(nps, w, h, radius);

    jintArray ret = (*env)->NewIntArray(env, len);
    (*env)->SetIntArrayRegion(env, ret, 0, len, nps);
    (*env)->ReleaseIntArrayElements(env, pixels, nps, 0);
    return ret;
}