---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by guolei.
--- DateTime: 2019/10/28 17:08
---

ATTR_TYPE = {
    NUMBER = -1,
    BOOLEAN = -2,
    ENUM = -3,
    STRING = -4,
    USERDATA = -5,
    COLOR = -6,
    -- 混合模式，如background
    MIX = -7,
    -- 组合模式
    COMB = {
        padding = 0,
        margin = 1,
        imageBtn = 2,
        scrollView = 3,
        content_inset = 4,
        tab_segment = 5,
        gradient_color = 6,
        shadow = 7,
        corner_radius = 8,
        corner_mask = 9,
    },
}

MLNWidgets = {
    View = View,
    LinearLayout = LinearLayout,
    Label = Label,
    ImageView = ImageView,
    EditTextView = EditTextView,
    ImageButton = ImageButton,
    ScrollView = ScrollView,
    TableView = TableView,
    CollectionView = CollectionView,
    TabSegmentView = TabSegmentView,
    WheelPickerView = WheelPickerView,
    Switch = Switch,
    ExpandableTableView = ExpandableTableView,
    Waterfall = Waterfall
}

function newAttr(type, sdkMethodName, enum)
    local attr = {}

    attr.type = (type and type or ATTR_TYPE.USERDATA)
    attr.func = sdkMethodName
    attr.enum = enum

    return attr
end

--- UIGenerator解析用到的关键字属性
--- @mln_ui_attrs
BasicAttrs = {
    id = "id",
    classType = "classType",
    view = "view",
    subs = "subs",
    attr_priority = "attr_priority",
    style = "style",
}

--- MLN-SDK组件属性
--- @mln_ui_attrs
MLNAttrs = {
    -- View
    margin = newAttr(ATTR_TYPE.COMB.margin),
    margin_top = newAttr(ATTR_TYPE.COMB.margin),
    margin_right = newAttr(ATTR_TYPE.COMB.margin),
    margin_bottom = newAttr(ATTR_TYPE.COMB.margin),
    margin_left = newAttr(ATTR_TYPE.COMB.margin),
    padding = newAttr(ATTR_TYPE.COMB.padding),
    padding_top = newAttr(ATTR_TYPE.COMB.padding),
    padding_right = newAttr(ATTR_TYPE.COMB.padding),
    padding_bottom = newAttr(ATTR_TYPE.COMB.padding),
    padding_left = newAttr(ATTR_TYPE.COMB.padding),
    alpha = newAttr(ATTR_TYPE.NUMBER, "alpha"),
    ripple = newAttr(ATTR_TYPE.BOOLEAN, "openRipple"),
    max_width = newAttr(ATTR_TYPE.NUMBER, "setMaxWidth"),
    max_height = newAttr(ATTR_TYPE.NUMBER, "setMaxHeight"),
    min_width = newAttr(ATTR_TYPE.NUMBER, "setMinWidth"),
    min_height = newAttr(ATTR_TYPE.NUMBER, "setMinHeight"),
    end_editing = newAttr(ATTR_TYPE.BOOLEAN, "canEndEditing"),
    background = newAttr(ATTR_TYPE.MIX),
    priority = newAttr(ATTR_TYPE.NUMBER, "priority"),
    weight = newAttr(ATTR_TYPE.NUMBER, "weight"),
    height = newAttr(ATTR_TYPE.MIX, "height"),
    corner_radius = newAttr(ATTR_TYPE.COMB.corner_radius, "setCornerRadiusWithDirection"),
    corner_radius_top_left = newAttr(ATTR_TYPE.COMB.corner_radius, "setCornerRadiusWithDirection"),
    corner_radius_top_right = newAttr(ATTR_TYPE.COMB.corner_radius, "setCornerRadiusWithDirection"),
    corner_radius_bottom_left = newAttr(ATTR_TYPE.COMB.corner_radius, "setCornerRadiusWithDirection"),
    corner_radius_bottom_right = newAttr(ATTR_TYPE.COMB.corner_radius, "setCornerRadiusWithDirection"),
    gradient_color_start = newAttr(ATTR_TYPE.COMB.gradient_color),
    gradient_color_end = newAttr(ATTR_TYPE.COMB.gradient_color),
    gradient_color_direction = newAttr(ATTR_TYPE.COMB.gradient_color),
    hidden = newAttr(ATTR_TYPE.BOOLEAN, "hidden"),
    gone = newAttr(ATTR_TYPE.BOOLEAN, "gone"),
    width = newAttr(ATTR_TYPE.MIX, "width", {
        match_parent = MeasurementType.MATCH_PARENT,
        wrap_content = MeasurementType.WRAP_CONTENT,
    }),
    gravity = newAttr(ATTR_TYPE.ENUM, "setGravity", {
        left = Gravity.LEFT,
        top = Gravity.TOP,
        right = Gravity.RIGHT,
        bottom = Gravity.BOTTOM,
        center_horizontal = Gravity.CENTER_HORIZONTAL,
        center_vertical = Gravity.CENTER_VERTICAL,
        center = Gravity.CENTER,
    }),
    shadow_x = newAttr(ATTR_TYPE.COMB.shadow),
    shadow_y = newAttr(ATTR_TYPE.COMB.shadow),
    shadow_radius = newAttr(ATTR_TYPE.COMB.shadow),
    shadow_alpha = newAttr(ATTR_TYPE.COMB.shadow),
    border_width = newAttr(ATTR_TYPE.NUMBER, "borderWidth"),
    border_color = newAttr(ATTR_TYPE.COLOR, "borderColor"),
    corner_mask = newAttr(ATTR_TYPE.COMB.corner_mask, "addCornerMask"),
    corner_mask_top_left = newAttr(ATTR_TYPE.COMB.corner_mask, "addCornerMask"),
    corner_mask_top_right = newAttr(ATTR_TYPE.COMB.corner_mask, "addCornerMask"),
    corner_mask_bottom_left = newAttr(ATTR_TYPE.COMB.corner_mask, "addCornerMask"),
    corner_mask_bottom_right = newAttr(ATTR_TYPE.COMB.corner_mask, "addCornerMask"),
    corner_mask_color = newAttr(ATTR_TYPE.COMB.corner_mask, "addCornerMask"),

    -- LinearLayout
    orientation = newAttr(ATTR_TYPE.COMB, "orientation", {
        vertical = LinearType.VERTICAL,
        horizontal = LinearType.HORIZONTAL
    }),

    -- Label
    text = newAttr(ATTR_TYPE.STRING, "text"),
    font_size = newAttr(ATTR_TYPE.NUMBER, "fontSize"),
    text_color = newAttr(ATTR_TYPE.COLOR, "textColor"),
    lines = newAttr(ATTR_TYPE.NUMBER, "lines"),
    line_spacing = newAttr(ATTR_TYPE.NUMBER, "setLineSpacing"),
    font_style = newAttr(ATTR_TYPE.ENUM, "setTextFontStyle", {
        normal = FontStyle.NORMAL,
        bold = FontStyle.BOLD,
        italic = FontStyle.ITALIC,
        bold_italic = FontStyle.BOLD_ITALIC,
    }),
    break_mode = newAttr(ATTR_TYPE.ENUM, "breakMode", {
        clipping = BreakMode.CLIPPING,
        head = BreakMode.HEAD,
        tail = BreakMode.TAIL,
        middle = BreakMode.MIDDLE,
    }),
    text_align = newAttr(ATTR_TYPE.ENUM, "textAlign", {
        left = TextAlign.LEFT,
        center = TextAlign.CENTER,
        right = TextAlign.RIGHT,
    }),

    -- ImageView
    src = newAttr(ATTR_TYPE.STRING, "image"),
    lazy = newAttr(ATTR_TYPE.BOOLEAN, "lazyLoad"),
    content_mode = newAttr(ATTR_TYPE.ENUM, "contentMode", {
        scale_to_fill = ContentMode.SCALE_TO_FILL,
        scale_aspect_fit = ContentMode.SCALE_ASPECT_FIT,
        scale_aspect_fill = ContentMode.SCALE_ASPECT_FILL,
        center = ContentMode.CENTER,
    }),
    blur = newAttr(ATTR_TYPE.NUMBER, 'blurImage'),

    -- EditTextView
    placeholder = newAttr(ATTR_TYPE.STRING, "placeholder"),
    placeholder_color = newAttr(ATTR_TYPE.COLOR, "placeholderColor"),
    password_mode = newAttr(ATTR_TYPE.BOOLEAN, "passwordMode"),
    max_bytes = newAttr(ATTR_TYPE.NUMBER, "maxBytes"),
    max_length = newAttr(ATTR_TYPE.NUMBER, "maxLength"),
    singleline = newAttr(ATTR_TYPE.BOOLEAN, "singleLine"),
    return_mode = newAttr(ATTR_TYPE.ENUM, "returnMode", {
        default = ReturnType.Default,
        go = ReturnType.Go,
        search = ReturnType.Search,
        send = ReturnType.Send,
        next = ReturnType.Next,
        done = ReturnType.Done,
        continue = ReturnType.Continue,
    }),
    input_mode = newAttr(ATTR_TYPE.ENUM, "inputMode", {
        normal = EditTextViewInputMode.Normal,
        number = EditTextViewInputMode.Number
    }),
    cursor_color = newAttr(ATTR_TYPE.COLOR, "setCursorColor"),
    can_edit = newAttr(ATTR_TYPE.BOOLEAN, "setCanEdit"),
    font_size = newAttr(ATTR_TYPE.NUMBER,"fontSize"),
    text_color = newAttr(ATTR_TYPE.COLOR,"textColor"),
    text = newAttr(ATTR_TYPE.STRING,"text"),

    -- ImageButton
    src_normal = newAttr(ATTR_TYPE.COMB.imageBtn),
    src_pressed = newAttr(ATTR_TYPE.COMB.imageBtn),

    -- ScrollView
    linear_container = newAttr(ATTR_TYPE.COMB),
    offset = newAttr(ATTR_TYPE.USERDATA, "contentOffset"),
    indicator_sv = newAttr(ATTR_TYPE.COMB.scrollView),
    i_bounces = newAttr(ATTR_TYPE.BOOLEAN, "i_bounces"),
    content_inset = newAttr(ATTR_TYPE.COMB.content_inset),
    content_inset_top = newAttr(ATTR_TYPE.COMB.content_inset),
    content_inset_right = newAttr(ATTR_TYPE.COMB.content_inset),
    content_inset_bottom = newAttr(ATTR_TYPE.COMB.content_inset),
    content_inset_left = newAttr(ATTR_TYPE.COMB.content_inset),
    scroll_enable = newAttr(ATTR_TYPE.BOOLEAN, "setScrollEnable"),

    -- TableView
    refresh_enable = newAttr(ATTR_TYPE.BOOLEAN, "refreshEnable"),
    load_enable = newAttr(ATTR_TYPE.BOOLEAN, "loadEnable"),
    load_threshold = newAttr(ATTR_TYPE.NUMBER, "loadThreshold"),
    reuse_cell = newAttr(ATTR_TYPE.BOOLEAN, "openReuseCell"),
    content_offset = newAttr(ATTR_TYPE.USERDATA, "contentOffset"),
    indicator = newAttr(ATTR_TYPE.BOOLEAN, "showScrollIndicator"),

    -- CollectionView
    scroll_direction = newAttr(ATTR_TYPE.ENUM, "scrollDirection", {
        vertical = ScrollDirection.VERTICAL,
        horizontal = ScrollDirection.HORIZONTAL
    }),

    -- TabSegmentView
    tab_segment_frame = newAttr(ATTR_TYPE.COMB.tab_segment),
    tab_segment_titles = newAttr(ATTR_TYPE.COMB.tab_segment),
    tab_segment_margin = newAttr(ATTR_TYPE.COMB.tab_segment),
    tab_segment_padding = newAttr(ATTR_TYPE.COMB.tab_segment),
    scale = newAttr(ATTR_TYPE.NUMBER, "selectScale"),
    current_index = newAttr(ATTR_TYPE.NUMBER, "currentIndex"),
    normal_font_size = newAttr(ATTR_TYPE.NUMBER, "normalFontSize"),
    tint_color = newAttr(ATTR_TYPE.COLOR, "tintColor"),
    tab_selected_color = newAttr(ATTR_TYPE.COLOR, "selectedColor"),
    indicator_color = newAttr(ATTR_TYPE.COLOR, "indicatorColor"),
    alignment = newAttr(ATTR_TYPE.ENUM, "setAlignment", {
        left = TabSegmentAlignment.LEFT,
        center = TabSegmentAlignment.CENTER,
        right = TabSegmentAlignment.RIGHT,
    }),

    -- WheelPickerView
    selected_row = newAttr(ATTR_TYPE.NUMBER, "selectedItemRow"),
    item_text_size = newAttr(ATTR_TYPE.NUMBER, "setItemTextSize"),
    item_spacing = newAttr(ATTR_TYPE.NUMBER, "setItemSpace"),
    cyclic = newAttr(ATTR_TYPE.BOOLEAN, "setCyclic"),
    text_bold = newAttr(ATTR_TYPE.BOOLEAN, "setItemTextStyleBold"),

    -- Switch
    on = newAttr(ATTR_TYPE.BOOLEAN, "on"),
    normal_color = newAttr(ATTR_TYPE.COLOR, "setNormalColor"),
    thumb_color = newAttr(ATTR_TYPE.COLOR, "setThumbColor"),
    switch_selected_color = newAttr(ATTR_TYPE.COLOR, "setSelectedColor")
}