---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by guolei.
--- DateTime: 2019/10/28 10:49
---

require("generator.WidgetConfig")
local SpacingAttrEntity = require("generator.SpacingAttrEntity")

--- ================== COMMON FUNC =====================

ROOT_VIEW_DEFAULT_ID = "_rootView"
ID_START = 100001

local function isSDKObj(obj)
    return type(obj) == "userdata"
end

local function isColorVal(colorVal)
    return type(colorVal) == "string" and string.find(colorVal,"#") == 1 and (#colorVal == 7 or #colorVal == 9)
end

local function getColorVal(input)
    local color = nil
    if isSDKObj(input) then
        color = input
    elseif isColorVal(input) then
        color = Color():setColor(input)
    end
    return color
end

local function invokeViewMethod(view, method, input)
    if view and method and view[method] then
        view[method](view,input)
    end
end

--- ================== _class ==========================

local _class = {
    NODE_HOLDERS = {},
    currNodeHolder = nil,
    idCounter = ID_START
}

--- 根据view声明生成view，只取单根
function _class:getViewHolder(rootView)
    if not rootView then
        return nil
    end

    self:getNewNodeHolder()
    rootView.id = rootView.id or ROOT_VIEW_DEFAULT_ID
    self:generateViewNode(rootView)
    return self.currNodeHolder
end

function _class:generateViewNode(declaration)
    -- 声明非法 - 非table
    if not declaration or type(declaration) ~= "table" then
        error("declare "..tostring(declaration).." invalid")
        return
    end

    -- 如果有style声明，先展开
    if declaration[BasicAttrs.style] and type(declaration[BasicAttrs.style]) == "table" then
        for attrName, val in pairs(declaration[BasicAttrs.style]) do
            if not declaration[attrName] then
                declaration[attrName] = val
            end
        end
    end

    -- id合规化
    declaration.id = declaration.id or self:getRandomId()
    local id = declaration.id

    -- 创建view
    if not isSDKObj(declaration.view) and declaration.classType ~= nil then
        -- 使用classType字段创建View
        if isSDKObj(declaration.classType) then               -- 直接创建了UDView，不建议用classType，但兼容
            self.currNodeHolder[id] = declaration.classType
        elseif type(declaration.classType) == "function" then -- 类型声明
            self.currNodeHolder[id] = declaration.classType(self:getConstructParam(declaration))
        elseif type(declaration.classType) == "string"
                and MLNWidgets[declaration.classType] then    -- 字符串声明
            self.currNodeHolder[id] = MLNWidgets[declaration.classType](self:getConstructParam(declaration))
        end
    elseif isSDKObj(declaration.view) then
        self.currNodeHolder[id] = declaration.view
    end

    -- 判断是否创建View成功，没有成功默认创建为View
    if not isSDKObj(self.currNodeHolder[id]) then
        --log("invalid declaration of view:\n"..table2String(declaration).."\ncreate default View()")
        self.currNodeHolder[id] = View()
    end

    -- 设置属性
    self:setAttr(self.currNodeHolder[id],self:getAttrDeclaration(declaration))
    -- 子布局
    if declaration.subs then
        for _, v in ipairs(declaration.subs) do
            v.id = v.id or self:getRandomId()
            self.currNodeHolder[v.id] = self:generateViewNode(v)
            self.currNodeHolder[id]:addView(self.currNodeHolder[v.id])
        end

    end

    return self.currNodeHolder[id]
end

--- 设置枚举类型
local function setEnumAttr(view,attrName, attr, input)
    local enumVal = nil
    if isSDKObj(input) or type(input) == "number" then  -- 直接声明类型
        enumVal = input
    elseif attr == MLNAttrs.gravity
            and type(input) == "string" then            -- Gravity
        local vals = {}
        string.gsub(input, '[^|]+', function(w) table.insert(vals, w) end)
        if #vals > 0 then
            if #vals == 1 then
                enumVal = MLNAttrs.gravity.enum[vals[1]]
            else
                enumVal = MBit:bor(MLNAttrs.gravity.enum[vals[1]],MLNAttrs.gravity.enum[vals[2]])
            end
        end
    elseif attr.enum then                               -- 普通string代表的枚举，直接获取
        enumVal = attr.enum[input]
    end

    if enumVal then
        invokeViewMethod(view,attr.func,enumVal)
    else
        error("invalid enum val:"..tostring(attrName))
    end
end

--- 解析设置混合类型
local function setMixAttr(view, attr, input)
    local mixVal = nil

    if attr == MLNAttrs.width
            or attr == MLNAttrs.height then        -- Width | Height
        mixVal = MLNAttrs.width.enum[input]
        mixVal = mixVal or (tonumber(input) or 0)
        invokeViewMethod(view,attr.func,mixVal)
    elseif attr == MLNAttrs.background then        -- background
        if isSDKObj(input) then
            invokeViewMethod(view,"bgColor",input)
        elseif isColorVal(input) then
            invokeViewMethod(view,"bgColor",Color():setColor(input))
        else
            invokeViewMethod(view,"bgImage",tostring(input))
        end
    elseif isSDKObj(input) then
        invokeViewMethod(view,attr.func,input)
    end
end

--- 组装"边距"组合属性
local function combSpacingAttr(spacingEntity,attrName,input)
    if not spacingEntity then
        spacingEntity = SpacingAttrEntity:new()
    end

    local pos = string.find(string.reverse(attrName),"_")
    local key = pos and string.sub(attrName,#attrName-pos+2,#attrName) or nil
    if spacingEntity[key] then     -- 拆解属性，如margin_left
        spacingEntity[key] = tonumber(input) or 0
    else
        spacingEntity:setAll(input)
    end
    return spacingEntity
end

local function setDefaultAttr(obj, attrName, input)
    if not obj then
        obj = {}
    end
    obj[attrName] = input
    return obj
end

--- 解析方向：LinearLayout，ScrollView
local function parseOrientation(input,default)
    if not input then
        return
    end

    local orientation
    if isSDKObj(input) or type(input) == "number" then  -- 直接声明类型
        orientation = input
    else                                                -- 普通string代表的枚举，直接获取
        orientation = MLNAttrs.orientation.enum[input]
    end

    return orientation or default
end

---------------------------------------------------------------------------------------------------------
---------------------每种类型对应的实现，参数为：view, attrName, attr, input, out----------------------------
---------------------------------------------------------------------------------------------------------
_class.typeFunction = {}
_class.typeFunction[ATTR_TYPE.USERDATA] = function(view, _, attr, input)
    if type(input) == "userdata" and view and attr.func and view[attr.func] then
        view[attr.func](view,input)
    end
end
_class.typeFunction[ATTR_TYPE.STRING] = function(view, _, attr, input)
    if view and attr.func and view[attr.func] then
        view[attr.func](view,tostring(input))
    end
end
_class.typeFunction[ATTR_TYPE.NUMBER] = function(view, _, attr, input)
    if view and attr.func and view[attr.func] then
        view[attr.func](view,tonumber(input) or 0)
    end
end
_class.typeFunction[ATTR_TYPE.BOOLEAN] = function(view, _, attr, inputValue)
    if view and attr.func and view[attr.func] then
        view[attr.func](view,(inputValue == true or inputValue == "true"))
    end
end
_class.typeFunction[ATTR_TYPE.ENUM] = setEnumAttr
_class.typeFunction[ATTR_TYPE.COLOR] = function(view, _, attr, input)
    invokeViewMethod(view,attr.func,getColorVal(input))
end
_class.typeFunction[ATTR_TYPE.MIX] = function(view, _, attr, inputValue)
    setMixAttr(view,attr, inputValue)
end
_class.typeFunction[ATTR_TYPE.COMB.padding] = function(_, attrName, _, inputValue, out)
    out.padding = combSpacingAttr(out.padding, attrName, inputValue)
end
_class.typeFunction[ATTR_TYPE.COMB.margin] = function(_, attrName, _, inputValue, out)
    out.margin = combSpacingAttr(out.margin, attrName, inputValue)
end
_class.typeFunction[ATTR_TYPE.COMB.imageBtn] = function(_, attrName, _, input, out)
    out.imageBtn = setDefaultAttr(out.imageBtn, attrName, input)
end
_class.typeFunction[ATTR_TYPE.COMB.scrollView] = function(_, attrName, _, input, out)
    out.scrollView = setDefaultAttr(out.scrollView, attrName, (input == "true" or input == true))
end
_class.typeFunction[ATTR_TYPE.COMB.content_inset] = function(_, attrName, _, inputValue, out)
    out.content_inset = combSpacingAttr(out.content_inset, attrName, inputValue)
end
_class.typeFunction[ATTR_TYPE.COMB.tab_segment] = function(_, attrName, _, input, out)
    local tabSegmentAttr = out.tab_segment
    if not tabSegmentAttr then
        tabSegmentAttr = {}
    end

    if attrName == "tab_segment_margin" then
        tabSegmentAttr.margin = tonumber(input)
    elseif attrName == "tab_segment_padding" then
        tabSegmentAttr.padding = tonumber(input)
    end

    out.tab_segment = tabSegmentAttr
end
_class.typeFunction[ATTR_TYPE.COMB.gradient_color] = function(_, attrName, _, input, out)
    local gradientColorAttr = out.gradient_color
    if not gradientColorAttr then
        gradientColorAttr = {}
    end

    if attrName == "gradient_color_start" then
        gradientColorAttr.start = getColorVal(input)
    elseif attrName == "gradient_color_end" then
        gradientColorAttr.endC = getColorVal(input)
    elseif attrName == "gradient_color_direction" then
        local direction = parseOrientation(input,GradientType.LEFT_TO_RIGHT)
        gradientColorAttr.direction = direction
    end

    out.gradient_color = gradientColorAttr
end
_class.typeFunction[ATTR_TYPE.COMB.shadow] = function(_, attrName, _, input, out)
    out.shadow = setDefaultAttr(out.shadow, attrName, input)
end

_class.typeFunction[ATTR_TYPE.COMB.corner_radius] = function(_, attrName, _, input, out)
    out.corner_radius = setDefaultAttr(out.corner_radius, attrName, input)
end

_class.typeFunction[ATTR_TYPE.COMB.corner_mask] = function(_, attrName, _, input, out)
    local corner_mask = out.corner_mask
    if not corner_mask then
        corner_mask = {}
        out.corner_mask = corner_mask
    end
    if attrName == 'corner_mask_color' then
        corner_mask.color = getColorVal(input)
    else
        setDefaultAttr(corner_mask, attrName, input)
    end
end
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------

--- 设置View基础属性
function _class:setAttr(view, declaredAttrs)
    if not (view and declaredAttrs and #declaredAttrs > 0) then
        return
    end

    -- 组合属性，遍历中只做统计和缓存，统计结束后统一设置
    local attrs = {};
    -- 循环设置声明中的所有属性
    for _, declAttr in ipairs(declaredAttrs) do
        local attrName = declAttr.attrName
        local inputValue = declAttr.input
        local attr = MLNAttrs[attrName]
        if attr and tostring(inputValue) ~= ""
                and self.typeFunction[attr.type] then
            self.typeFunction[attr.type](view, attrName, attr, inputValue, attrs)
        end
    end

    if attrs.padding then                     -- 设置padding
        local paddingAttr = attrs.padding;
        view:padding(paddingAttr:getTop(),paddingAttr:getRight(),paddingAttr:getBottom(),paddingAttr:getLeft())
    end
    if attrs.margin then                      -- 设置margin
        local marginAttr = attrs.margin
        view:marginTop(marginAttr:getTop())
        view:marginRight(marginAttr:getRight())
        view:marginBottom(marginAttr:getBottom())
        view:marginLeft(marginAttr:getLeft())
    end
    if attrs.imageBtn and view.setImage then    -- 设置ImageButton
        view:setImage(attrs.imageBtn.src_normal,attrs.imageBtn.src_pressed)
    end
    if attrs.scrollView and attrs.scrollView.indicator ~= nil then                  -- 设置ScrollView
        local orientation = parseOrientation(declaredAttrs.orientation,LinearType.VERTICAL)
        if view.showsHorizontalScrollIndicator and orientation == LinearType.HORIZONTAL then
            view:showsHorizontalScrollIndicator(attrs.scrollView.indicator)
        elseif view.showsVerticalScrollIndicator and orientation == LinearType.VERTICAL then
            view:showsVerticalScrollIndicator(attrs.scrollView.indicator)
        end
    end
    if attrs.content_inset and view.setContentInset then
        view:setContentInset(attrs.content_inset:getTop(),attrs.content_inset:getRight(),
                attrs.content_inset:getBottom(),attrs.content_inset:getLeft())
    end
    if attrs.tab_segment
            and view.setTabSpacing then      -- 设置TabSegment
        view:setTabSpacing(attrs.tab_segment.margin or 0,attrs.tab_segment.padding or 0)
    end

    if attrs.gradient_color
            and attrs.gradient_color.start
            and attrs.gradient_color.endC then  -- 设置渐变色
        view:setGradientColorWithDirection(attrs.gradient_color.start, attrs.gradient_color.endC, (attrs.gradient_color.direction or 0))
    end

    if attrs.shadow then
        local x = attrs.shadow.shadow_x or 0
        local y = attrs.shadow.shadow_y or 0
        local r = attrs.shadow.shadow_radius or 0
        local a = attrs.shadow.shadow_alpha or 0
        view:setShadow(x, y, r, a)
    end

    if attrs.corner_radius then
        local def = tonumber(attrs.corner_radius.corner_radius) or 0
        local tl = tonumber(attrs.corner_radius.corner_radius_top_left) or def
        local tr = tonumber(attrs.corner_radius.corner_radius_top_right) or def
        local bl = tonumber(attrs.corner_radius.corner_radius_bottom_left) or def
        local br = tonumber(attrs.corner_radius.corner_radius_bottom_right) or def
        view:setCornerRadiusWithDirection(tl,RectCorner.TOP_LEFT)
        view:setCornerRadiusWithDirection(tr,RectCorner.TOP_RIGHT)
        view:setCornerRadiusWithDirection(bl,RectCorner.BOTTOM_LEFT)
        view:setCornerRadiusWithDirection(br,RectCorner.BOTTOM_RIGHT)
    end

    if attrs.corner_mask then
        local corner_mask = attrs.corner_mask
        local color = corner_mask.color
        if color then
            local def =tonumber(corner_mask.corner_mask) or 0
            local tl = tonumber(corner_mask.corner_mask_top_left) or def
            local tr = tonumber(corner_mask.corner_mask_top_right) or def
            local bl = tonumber(corner_mask.corner_mask_bottom_left) or def
            local br = tonumber(corner_mask.corner_mask_bottom_right) or def
            local method = view.addCornerMask
            method(view, tl, color, RectCorner.TOP_LEFT)
            method(view, tr, color, RectCorner.TOP_RIGHT)
            method(view, bl, color, RectCorner.BOTTOM_LEFT)
            method(view, br, color, RectCorner.BOTTOM_RIGHT)
        end
    end
end

--- 获取构造参数，如LinearLayout等View的部分属性需要在构造中传入
function _class:getConstructParam(declaration)
    if not declaration and declaration.classType then
        return
    end

    local classType = declaration.classType
    if classType == LinearLayout or classType == "LinearLayout" then
        return parseOrientation(declaration.orientation,LinearType.HORIZONTAL)
    elseif classType == ScrollView or classType == "ScrollView" then
        local isHori = parseOrientation(declaration.orientation,LinearType.VERTICAL) == LinearType.HORIZONTAL
        local isLinear = declaration.linear_container == true or declaration.linear_container == "true"
        return isHori,isLinear
    elseif classType == TabSegmentView or classType == "TabSegmentView" then
        if isSDKObj(declaration.tab_segment_frame) then
            if isSDKObj(declaration.tab_segment_titles) then
                return declaration.tab_segment_frame,declaration.tab_segment_titles
            else
                return declaration.tab_segment_frame
            end
        end
    end

end

--- 整理并排序声明的属性，有序
function _class:getAttrDeclaration(declaration)
    if type(declaration) ~= "table" then
        return
    end

    local attrs = {}
    -- 属性权重
    local attrPriority = declaration[BasicAttrs.attr_priority]
    -- 如果属性权重声明不为空，先将声明的属性插入
    if type(attrPriority) == "table" and #attrPriority > 0  then
        for i, v in ipairs(attrPriority) do
            if declaration[v] ~= nil then
                table.insert(attrs,{
                    attrName = v,
                    input = declaration[v]
                })
                -- 插入后置空，防止重复插入
                declaration[v] = nil
            end
        end
    end


    -- 将attrPriority整理正kv形式，提升遍历效率
    for attrName, v in pairs(declaration) do
        -- 非关键字属性
        if BasicAttrs[attrName] == nil and declaration[attrName] ~= nil then
            table.insert(attrs,{
                attrName = attrName,
                input = v
            })
        end
    end

    return attrs
end

function _class:getNewNodeHolder()
    table.insert(self.NODE_HOLDERS,{})
    self.currNodeHolder = self.NODE_HOLDERS[#self.NODE_HOLDERS]
end

function _class:getRandomId()
    --math.randomseed(os:clock())
    --local id = string.format("UDID-%s",math.random(10000,99999))
    --return id
    self.idCounter = self.idCounter + 1
    return string.format("UDID-%s",self.idCounter)
end

return _class;