---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by guo.lei
--- DateTime: 2019-11-01
---
SPACING_PRIMARY_DEFAULT = -9999

_class = {
    top = SPACING_PRIMARY_DEFAULT,
    left = SPACING_PRIMARY_DEFAULT,
    right = SPACING_PRIMARY_DEFAULT,
    bottom = SPACING_PRIMARY_DEFAULT
}

function _class:new(o)
    o = o or {}
    setmetatable(o, self)
    self.__index = self
    return o
end

--- 设置全部，如果原值已经被指定，改方法中不覆盖
function _class:setAll(spacing)
    spacing = tonumber(spacing) or 0
    self:setTop(self:getValWithoutCoverDefault(self.top,spacing))
    self:setRight(self:getValWithoutCoverDefault(self.right,spacing))
    self:setBottom(self:getValWithoutCoverDefault(self.bottom,spacing))
    self:setLeft(self:getValWithoutCoverDefault(self.left,spacing))
end

function _class:setTop(spacing)
    self.top = tonumber(spacing) or 0
end

function _class:getTop()
    return self:getRealVal(self.top)
end

function _class:setRight(spacing)
    self.right = tonumber(spacing) or 0
end

function _class:getRight()
    return self:getRealVal(self.right)
end

function _class:setBottom(spacing)
    self.bottom = tonumber(spacing) or 0
end

function _class:getBottom()
    return self:getRealVal(self.bottom)
end


function _class:setLeft(spacing)
    self.left = tonumber(spacing) or 0
end

function _class:getLeft()
    return self:getRealVal(self.left)
end

--- 如果原有值已经被指定，不再次修改
function _class:getValWithoutCoverDefault(old,new)
    return old == SPACING_PRIMARY_DEFAULT and new or old
end

--- 返回真实值，默认值被处理为0
function _class:getRealVal(val)
    return val == SPACING_PRIMARY_DEFAULT and 0 or val
end

return _class