#!/usr/bin/python
# coding=utf-8

from PIL import Image
from PIL import ImageChops
import math, operator
import os, sys, shutil

# 对比图片
def compare(pic1, pic2, containBattery):
    '''
    :param pic1: 图片1路径
    :param pic2: 图片2路径
    :param containBattery: 图片是否包含电池栏
    :return: 返回对比结果 如果是0.0，则两张图片完全相同，返回值越大，两张图片不同点越多
    '''
    image1 = Image.open(pic1)
    image2 = Image.open(pic2)

    print "裁剪前两张图片大小分别为：",
    print image1.size,
    print image2.size

    # 将两张图片格式转换为RGBA 可以通过image.getpixel((0,0))查看是几色通道
    pic1_RGBA = image1.convert("RGBA")
    pic2_RGBA = image2.convert("RGBA")

    if containBattery == "true":
        pic1_RGBANew = crop(pic1_RGBA)
        pic2_RGBANew = crop(pic2_RGBA)
        print "裁剪掉电池栏后两张图片大小分别为：",
        print pic1_RGBANew.size,
        print pic2_RGBANew.size
    else:
         pic1_RGBANew = pic1_RGBA
         pic2_RGBANew = pic2_RGBA

    if ((pic1_RGBANew.size[0] == pic2_RGBANew.size[0]) & (pic1_RGBANew.size[1] == pic2_RGBANew.size[1])):
       None
    else:
        pic2_RGBANew = crop_image(pic1_RGBANew, pic2_RGBANew)

    print "按比例裁剪后两张图片大小分别为：",
    print pic1_RGBANew.size,
    print pic2_RGBANew.size

    pic1_RGBANew_hist = pic1_RGBANew.resize((256, 256), Image.ANTIALIAS)
    pic2_RGBANew_hist = pic2_RGBANew.resize((256, 256), Image.ANTIALIAS)

    histogram1 = pic1_RGBANew_hist.histogram()
    histogram2 = pic2_RGBANew_hist.histogram()

    if len(histogram1) != len(histogram2):
        print("error:histogram1 != histogram2")

    differ = math.sqrt(
        reduce(operator.add, list(map(lambda a, b: (a - b) ** 2, histogram1, histogram2))) / len(histogram1))

    if differ > 0:
        # 对比结果存放路径
        f, ext = os.path.splitext(pic2)
        resultPath = f + "_result" + ".png"

        compare_result(pic1_RGBANew, pic2_RGBANew, resultPath, pic2)

        print("两张图片不完全相同，differ = "),
    else:
        print("两张图片完全相同，differ = "),

    print differ,
    print("(differ=0,表示两张图片完全相同，differ越小，图片越相似，differ越大，图片差异越大)"),
    return differ

# 裁剪掉电池栏
def crop(image):
    # 电池栏高度
    statusBarHeight = 72
    box = (0, statusBarHeight, image.size[0],
               image.size[1]) # 需要裁剪得到的图片在原图中的左、上、右、下坐标(left, top, right, bottom)
    image_crop = image.crop(box)
    return image_crop

# 对比图片，输出不同点，将结果保存为xx_result.png
def compare_result(img1, img2, resultPath, pic2):
    img1 = img1.convert("RGB")
    img2 = img2.convert("RGB")
    diff = ImageChops.difference(img1, img2)

    if diff.getbbox():
        diff.save(resultPath)
        print("差异结果存储路径为：<a href=\"" + pic2 + "●" + resultPath + "\">"),
        print resultPath + "</a>"
    else:
        None

# 将选择图片的宽高比与截屏图片宽高比一致,先等比缩放再裁剪
def crop_image(img1, img2):
    ration1 = float(img1.size[0]) / img1.size[1]
    ration2 = float(img2.size[0]) / img2.size[1]
    if ration1 > ration2:
        # 需要裁剪img2的height
        print "大于"
        img2 = img2.resize((img1.size[0], int(math.ceil(img1.size[0] / ration2))), Image.ANTIALIAS)
        print "缩放后大小：",
        print img2.size
        img2_height = img1.size[1]
        box_heght = (0, 0, img2.size[0], img2_height)
        img2_crop = img2.crop(box_heght)
        print "裁剪后大小",
        print img2_crop.size
    else:
        # 需要裁剪img2的width
        print "小于"
        img2 = img2.resize((int(math.ceil(img1.size[1] * ration2)), img1.size[1]), Image.ANTIALIAS)
        print "缩放后大小：",
        print img2.size
        img2_width = img1.size[0]
        box_width = (0, 0, img2_width, img2.size[1])
        img2_crop = img2.crop(box_width)
        print "裁剪后大小",
        print img2_crop.size
    return img2_crop

if __name__ == '__main__':
    pic1 = sys.argv[1]
    pic2 = sys.argv[2]
    containBattery = sys.argv[3]
    compare(pic1, pic2, containBattery)
