/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.utils;

import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class SizeOfUtils {
    private static final int PTR_HEAD = 8;
    private static final int PTR_SIZE = 4;
    private static final int LENGTH_SIZE = 4;
    private static final Map<Class, Long> classMemCache = new HashMap<Class, Long>(20);

    private SizeOfUtils() {
    }

    public static long sizeof(Class clz) {
        long size = 8L + SizeOfUtils._sizeof(clz);
        for (Class parent = clz.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            size += SizeOfUtils._sizeof(parent);
        }
        return size;
    }

    public static long sizeof(Object obj) {
        Class<?> clz = obj.getClass();
        long size = 8L + SizeOfUtils._sizeof(clz, obj);
        for (Class<?> parent = clz.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            size += SizeOfUtils._sizeof(parent, obj);
        }
        return size;
    }

    private static long _sizeof(Class clz, Object obj) {
        Field[] fields;
        if (clz == Object.class) {
            return SizeOfUtils._sizeof(clz);
        }
        long size = 0L;
        for (Field f : fields = clz.getDeclaredFields()) {
            f.setAccessible(true);
            Class<?> type2 = f.getType();
            if (type2 == clz.getEnclosingClass() || (type2.getModifiers() & 8) == 8) continue;
            if (type2.isPrimitive()) {
                size += (long)SizeOfUtils._primitiveSize(type2);
                continue;
            }
            if (type2.isArray()) {
                size += 16L;
                Object arr = null;
                try {
                    arr = f.get(obj);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (arr == null) continue;
                size += SizeOfUtils._sizeofArr(arr, type2.getComponentType());
                continue;
            }
            size += 12L;
            if (Reference.class.isAssignableFrom(type2)) continue;
            Object ref = null;
            try {
                ref = f.get(obj);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (ref == null) continue;
            size += SizeOfUtils.sizeof(ref);
        }
        return size;
    }

    private static long _sizeofArr(Object arr, Class componentClass) {
        int len2 = Array.getLength(arr);
        if (len2 == 0) {
            return 0L;
        }
        if (componentClass.isPrimitive()) {
            return SizeOfUtils._primitiveSize(componentClass) * len2;
        }
        long size = 0L;
        if (componentClass.isArray()) {
            for (int i = 0; i < len2; ++i) {
                size += SizeOfUtils._sizeofArr(Array.get(arr, i), componentClass.getComponentType());
            }
        } else {
            for (int i = 0; i < len2; ++i) {
                size += SizeOfUtils.sizeof(Array.get(arr, i));
            }
        }
        return size;
    }

    private static long _sizeof(Class clz) {
        Field[] fields;
        Long cache = classMemCache.get(clz);
        if (cache != null) {
            return cache;
        }
        long size = 0L;
        for (Field f : fields = clz.getDeclaredFields()) {
            Class<?> type2 = f.getType();
            if ((type2.getModifiers() & 8) == 8) continue;
            if (type2.isPrimitive()) {
                size += (long)SizeOfUtils._primitiveSize(type2);
                continue;
            }
            if (type2.isArray()) {
                size += 16L;
                continue;
            }
            size += 12L;
        }
        classMemCache.put(clz, size);
        return size;
    }

    private static int _primitiveSize(Class type2) {
        if (type2 == Boolean.TYPE) {
            return 1;
        }
        if (type2 == Byte.TYPE) {
            return 1;
        }
        if (type2 == Character.TYPE) {
            return 2;
        }
        if (type2 == Short.TYPE) {
            return 2;
        }
        if (type2 == Integer.TYPE) {
            return 4;
        }
        if (type2 == Float.TYPE) {
            return 4;
        }
        return 8;
    }
}

