/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.luaj.vm2.LuaValue;

public class SignatureUtils {
    public static final String VALID_METHOD_SIG = "([Lcom/xfy/luajava/LuaValue;)[Lcom/xfy/luajava/LuaValue;";
    private static final HashMap<Class, String> primitive = new HashMap(9);
    private static final Class[] Primitive;

    public static String getClassName(Class clz) {
        return clz.getName().replaceAll("\\.", "/");
    }

    public static String getClassSignature(Class clz) {
        if (clz.isArray()) {
            String name = clz.getName();
            if (clz.getComponentType().isPrimitive()) {
                return name;
            }
            return name.replaceAll("\\.", "/");
        }
        if (clz.isPrimitive()) {
            return primitive.get(clz);
        }
        String name = clz.getName().replaceAll("\\.", "/");
        return "L" + name + ";";
    }

    public static String getMethodSignature(Method m) {
        Class<?>[] params = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        if (params == null || params.length == 0) {
            return "()" + SignatureUtils.getClassSignature(returnType);
        }
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> c : params) {
            sb.append(SignatureUtils.getClassSignature(c));
        }
        return sb.append(")").append(SignatureUtils.getClassSignature(returnType)).toString();
    }

    public static boolean isValidClassType(Class clz, boolean arrayIsValid) {
        Class<?> cc = clz.getComponentType();
        if (cc != null) {
            return arrayIsValid && SignatureUtils.isValidClassType(cc, false);
        }
        return clz.isPrimitive() || SignatureUtils.isPrimitive(clz) || LuaValue.class.isAssignableFrom(clz);
    }

    private static boolean isPrimitive(Class clz) {
        for (Class c : Primitive) {
            if (c != clz) continue;
            return true;
        }
        return false;
    }

    static {
        primitive.put(Boolean.TYPE, "Z");
        primitive.put(Byte.TYPE, "B");
        primitive.put(Character.TYPE, "C");
        primitive.put(Short.TYPE, "S");
        primitive.put(Integer.TYPE, "I");
        primitive.put(Long.TYPE, "J");
        primitive.put(Float.TYPE, "F");
        primitive.put(Double.TYPE, "D");
        primitive.put(Void.TYPE, "V");
        Primitive = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    }
}

