/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.utils;

public class LuaBinaryUtils {
    private static final byte[] LUA_BIN_SIGNATURE = new byte[]{27, 76, 117, 97};
    private static final char[] LUAC_DATA = new char[]{'\u0019', '\u0093', '\r', '\n', '\u001a', '\n'};
    private static final int signatureLength = LUA_BIN_SIGNATURE.length;
    private static final int dataLength = LUAC_DATA.length;

    public static boolean isBinaryData(byte[] data) {
        int len2 = data.length;
        if (len2 <= signatureLength) {
            return false;
        }
        for (int i = 0; i < signatureLength; ++i) {
            if (data[i] == LUA_BIN_SIGNATURE[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean checkBinaryData(byte[] data) {
        if (!LuaBinaryUtils.isBinaryData(data)) {
            return false;
        }
        int i = signatureLength;
        if (data[i++] != 83) {
            return false;
        }
        if (data[i++] != 0) {
            return false;
        }
        for (int j = 0; j < dataLength; ++j) {
            if (data[j + i] == LUAC_DATA[j]) continue;
            return false;
        }
        return true;
    }
}

