/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import com.immomo.mlncore.MLNCore;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.luaj.vm2.LuaUserdata;

class UserdataCache {
    private volatile long cacheLong = 1L;
    private final HashMap<Long, LuaUserdata> cache = new HashMap(100);
    private HashMap<Long, SoftReference<LuaUserdata>> removedCache;
    private boolean destroyed = false;

    UserdataCache() {
    }

    void put(LuaUserdata ud) {
        if (this.destroyed) {
            return;
        }
        if (ud.id != 0L) {
            return;
        }
        ud.id = this.cacheLong++;
        this.cache.put(ud.id, ud);
    }

    LuaUserdata get(long id) {
        LuaUserdata ret2 = this.cache.get(id);
        if (ret2 != null) {
            return ret2;
        }
        if (MLNCore.UserdataCacheType == 2) {
            SoftReference<LuaUserdata> ref = this.removedCache != null ? this.removedCache.get(id) : null;
            LuaUserdata luaUserdata = ret2 = ref != null ? ref.get() : null;
            if (ret2 != null && MLNCore.DEBUG) {
                return MLNCore.onNullGet(id, ret2);
            }
            return ret2;
        }
        return null;
    }

    void onUserdataGc(LuaUserdata ud, boolean finalized) {
        if (finalized) {
            this.cache.remove(ud.id);
            return;
        }
        switch (MLNCore.UserdataCacheType) {
            case 1: {
                this.cache.remove(ud.id);
                break;
            }
            case 2: {
                this.cache.remove(ud.id);
                if (this.removedCache == null) {
                    this.removedCache = new HashMap(50);
                }
                this.removedCache.put(ud.id, new SoftReference<LuaUserdata>(ud));
                break;
            }
        }
    }

    void onDestroy() {
        this.destroyed = true;
        for (LuaUserdata ud : this.cache.values()) {
            ud.__onLuaGc();
        }
        this.cache.clear();
        if (this.removedCache != null) {
            this.removedCache.clear();
        }
    }
}

