/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaCApi;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.utils.LuaApiUsed;

@LuaApiUsed
abstract class NLuaValue
extends LuaValue {
    protected Globals globals;
    volatile boolean calledDestroy = false;

    NLuaValue(Globals globals, long nativeGlobalKey) {
        this.globals = globals;
        this.nativeGlobalKey = nativeGlobalKey;
    }

    NLuaValue(long nativeGlobalKey) {
        this.nativeGlobalKey = nativeGlobalKey;
    }

    @LuaApiUsed
    NLuaValue(long L_state, long nativeGlobalKey) {
        this(nativeGlobalKey);
        this.globals = Globals.getGlobalsByLState(L_state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        NLuaValue nLuaValue = this;
        synchronized (nLuaValue) {
            if (this.calledDestroy) {
                return;
            }
            this.calledDestroy = true;
        }
        if (this.notInGlobalTable() || this.destroyed || this.globals.isDestroyed()) {
            return;
        }
        this.destroyed = this.globals.removeStack(this);
    }

    boolean checkStateByNative() {
        this.destroyed = !LuaCApi._hasNativeValue(this.globals.L_State, this.nativeGlobalKey, this.type());
        return !this.destroyed;
    }

    public final Globals getGlobals() {
        return this.globals;
    }

    @LuaApiUsed
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NLuaValue luaValue = (NLuaValue)o;
        if (!this.notInGlobalTable()) {
            return this.nativeGlobalKey == luaValue.nativeGlobalKey;
        }
        return super.equals(o);
    }

    public int hashCode() {
        if (!this.notInGlobalTable()) {
            return (int)(this.nativeGlobalKey ^ this.nativeGlobalKey >>> 32);
        }
        return super.hashCode();
    }

    @Override
    @LuaApiUsed
    public String toString() {
        return LUA_TYPE_NAME[this.type()] + "#(" + Long.toHexString(this.nativeGlobalKey) + ")";
    }

    protected void finalize() throws Throwable {
        if (this instanceof Globals) {
            super.finalize();
            return;
        }
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }
}

