/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaNil;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.exception.InvokeError;
import org.luaj.vm2.exception.LuaTypeError;
import org.luaj.vm2.utils.LuaApiUsed;

@LuaApiUsed
public abstract class LuaValue {
    public static final int LUA_TNONE = -1;
    public static final int LUA_TNIL = 0;
    public static final int LUA_TBOOLEAN = 1;
    public static final int LUA_TLIGHTUSERDATA = 2;
    public static final int LUA_TNUMBER = 3;
    public static final int LUA_TSTRING = 4;
    public static final int LUA_TTABLE = 5;
    public static final int LUA_TFUNCTION = 6;
    public static final int LUA_TUSERDATA = 7;
    public static final int LUA_TTHREAD = 8;
    static final String[] LUA_TYPE_NAME = new String[]{"nil", "boolean", "light_userdata", "number", "string", "table", "function", "userdata", "thread"};
    protected volatile boolean destroyed;
    @LuaApiUsed
    long nativeGlobalKey;
    private static LuaValue[] _NIL;
    private static LuaValue[] _TRUE;
    private static LuaValue[] _FALSE;
    private static LuaValue[] _EMPTY;

    public static LuaValue Nil() {
        return LuaNil.NIL();
    }

    public static LuaValue True() {
        return LuaBoolean.TRUE();
    }

    public static LuaValue False() {
        return LuaBoolean.FALSE();
    }

    public static LuaValue[] varargsOf(LuaValue ... values) {
        return values;
    }

    public static LuaValue[] empty() {
        if (_EMPTY == null) {
            _EMPTY = new LuaValue[0];
        }
        return _EMPTY;
    }

    public static LuaValue[] rNil() {
        if (_NIL == null) {
            _NIL = new LuaValue[]{LuaNil.NIL()};
        }
        return _NIL;
    }

    public static LuaValue[] rTrue() {
        if (_TRUE == null) {
            _TRUE = new LuaValue[]{LuaBoolean.TRUE()};
        }
        return _TRUE;
    }

    public static LuaValue[] rFalse() {
        if (_FALSE == null) {
            _FALSE = new LuaValue[]{LuaBoolean.FALSE()};
        }
        return _FALSE;
    }

    public static LuaValue[] rBoolean(boolean bool) {
        return bool ? LuaValue.rTrue() : LuaValue.rFalse();
    }

    public static LuaValue[] rNumber(double n) {
        return LuaValue.varargsOf(LuaNumber.valueOf(n));
    }

    public static LuaValue[] rString(String s) {
        return LuaValue.varargsOf(LuaString.valueOf(s));
    }

    public static void destroyAllParams(LuaValue[] params) {
        for (LuaValue v : params) {
            v.destroy();
        }
    }

    public static LuaValue[] sub(LuaValue[] v, int from) {
        int len2 = v.length - from;
        if (len2 <= 0) {
            return null;
        }
        LuaValue[] ret2 = new LuaValue[len2];
        System.arraycopy(v, from, ret2, 0, len2);
        return ret2;
    }

    public boolean isNil() {
        return this.type() == 0;
    }

    public boolean isBoolean() {
        return this.type() == 1;
    }

    public boolean isNumber() {
        return this.type() == 3;
    }

    public boolean isString() {
        return this.type() == 4;
    }

    public boolean isFunction() {
        return this.type() == 6;
    }

    public boolean isTable() {
        return this.type() == 5;
    }

    public boolean isUserdata() {
        return this.type() == 7 || this.type() == 2;
    }

    public boolean isThread() {
        return this.type() == 8;
    }

    public boolean toBoolean() {
        this.typeError(LUA_TYPE_NAME[1]);
        return false;
    }

    public int toInt() {
        this.typeError(LUA_TYPE_NAME[3]);
        return 0;
    }

    public double toDouble() {
        this.typeError(LUA_TYPE_NAME[3]);
        return 0.0;
    }

    public float toFloat() {
        return (float)this.toDouble();
    }

    public String toJavaString() {
        return this.toString();
    }

    public LuaFunction toLuaFunction() {
        this.typeError(LUA_TYPE_NAME[6]);
        return null;
    }

    public LuaTable toLuaTable() {
        this.typeError(LUA_TYPE_NAME[5]);
        return null;
    }

    public LuaUserdata toUserdata() {
        this.typeError(LUA_TYPE_NAME[7]);
        return null;
    }

    public LuaThread toLuaThread() {
        this.typeError(LUA_TYPE_NAME[8]);
        return null;
    }

    public void set(int index, LuaValue value) {
        this.toLuaTable().set(index, value);
    }

    public void set(int index, double num) {
        this.toLuaTable().set(index, num);
    }

    public void set(int index, boolean b) {
        this.toLuaTable().set(index, b);
    }

    public void set(int index, String s) {
        this.toLuaTable().set(index, s);
    }

    public void set(String name, LuaValue value) {
        this.toLuaTable().set(name, value);
    }

    public void set(String name, double num) {
        this.toLuaTable().set(name, num);
    }

    public void set(String name, boolean b) {
        this.toLuaTable().set(name, b);
    }

    public void set(String name, String s) {
        this.toLuaTable().set(name, s);
    }

    public LuaValue get(int index) {
        return this.toLuaTable().get(index);
    }

    public LuaValue get(String name) {
        return this.toLuaTable().get(name);
    }

    public LuaValue[] invoke(LuaValue[] params, int returnCount) throws InvokeError {
        return this.toLuaFunction().invoke(params, returnCount);
    }

    public LuaValue[] invoke(LuaValue[] params) throws InvokeError {
        return this.toLuaFunction().invoke(params);
    }

    @LuaApiUsed
    public abstract int type();

    @LuaApiUsed
    long nativeGlobalKey() {
        return this.nativeGlobalKey;
    }

    boolean notInGlobalTable() {
        return this.nativeGlobalKey == 0L || this.nativeGlobalKey == -1L;
    }

    public void destroy() {
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    void typeError(String wantType) {
        throw new LuaTypeError("This value type is " + LUA_TYPE_NAME[this.type()] + ", cannot be cast to " + wantType);
    }

    public String toString() {
        return LUA_TYPE_NAME[this.type()] + "@" + this.hashCode();
    }
}

