/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.NLuaValue;
import org.luaj.vm2.utils.LuaApiUsed;
import org.luaj.vm2.utils.SizeOfUtils;

@LuaApiUsed
public class LuaUserdata<T>
extends NLuaValue {
    @LuaApiUsed
    private String luaclassName;
    @LuaApiUsed
    long id;
    protected T javaUserdata;
    private long refCount;
    private long javaRefCount;
    protected long memoryCastCache = 0L;

    public LuaUserdata(Globals g, T jud) {
        super(g, g.globalsIndex());
        this.luaclassName = this.initLuaClassName(g);
        this.javaUserdata = jud;
        g.userdataCache.put(this);
        this.refCount = 0L;
    }

    @LuaApiUsed
    protected LuaUserdata(long L, LuaValue[] v) {
        super(L, 0L);
        this.globals.userdataCache.put(this);
        this.refCount = 1L;
    }

    @LuaApiUsed
    private void addRef() {
        ++this.refCount;
    }

    public void onJavaRef() {
        ++this.javaRefCount;
    }

    public void onJavaRecycle() {
        --this.javaRefCount;
        if (this.refCount > 0L || this.globals.isDestroyed()) {
            return;
        }
        if (this.javaRefCount <= 0L) {
            this.globals.userdataCache.onUserdataGc(this, false);
        }
    }

    protected String initLuaClassName(Globals g) {
        return g.getLuaClassName(this.getClass());
    }

    @LuaApiUsed
    protected void __onLuaGc() {
        --this.refCount;
        if (this.javaRefCount > 0L || this.globals.isDestroyed()) {
            return;
        }
        if (this.refCount <= 0L) {
            this.globals.userdataCache.onUserdataGc(this, false);
        }
    }

    @LuaApiUsed
    protected boolean __onLuaEq(Object other) {
        return this.equals(other);
    }

    @LuaApiUsed
    private LuaUserdata(long L_state, long stackIndex) {
        super(L_state, stackIndex);
    }

    @LuaApiUsed
    protected long memoryCast() {
        if (this.memoryCastCache == 0L) {
            if (this.javaUserdata != null) {
                this.memoryCastCache = SizeOfUtils.sizeof(this.javaUserdata.getClass());
            }
            if (this.memoryCastCache == 0L) {
                this.memoryCastCache = 8L;
            }
        }
        return this.memoryCastCache;
    }

    @Override
    public final int type() {
        return 7;
    }

    @Override
    public final LuaUserdata toUserdata() {
        return this;
    }

    public T getJavaUserdata() {
        return this.javaUserdata;
    }

    @Override
    public int hashCode() {
        if (this.javaUserdata != null) {
            return this.javaUserdata.hashCode();
        }
        return super.hashCode();
    }

    @Override
    protected void finalize() throws Throwable {
        this.javaRefCount = 0L;
        this.refCount = 0L;
        if (this.globals != null) {
            this.globals.userdataCache.onUserdataGc(this, true);
        }
        super.finalize();
    }
}

