/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import com.immomo.mlncore.MLNCore;
import java.util.Arrays;
import java.util.Iterator;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaCApi;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.NLuaValue;
import org.luaj.vm2.utils.DisposableIterator;
import org.luaj.vm2.utils.LuaApiUsed;

@LuaApiUsed
public class LuaTable
extends NLuaValue
implements Iterable {
    private static final Entrys EMPTY_ENTRYS = new Entrys(LuaTable.empty(), LuaTable.empty());

    LuaTable(long stackIndex) {
        super(stackIndex);
        this.globals = (Globals)this;
    }

    private LuaTable(Globals globals, long stackIndex) {
        super(globals, stackIndex);
    }

    @LuaApiUsed
    private LuaTable(long L_state, long stackIndex) {
        super(L_state, stackIndex);
    }

    public static LuaTable create(Globals globals) {
        globals.checkMainThread();
        return new LuaTable(globals, LuaCApi._createTable(globals.L_State));
    }

    @Override
    public void set(int index, LuaValue value) {
        if (!this.checkValid()) {
            return;
        }
        int t = value.type();
        switch (t) {
            case 3: {
                LuaCApi._setTableNumber(this.globals.L_State, this.nativeGlobalKey, index, value.toDouble());
                break;
            }
            case 0: {
                LuaCApi._setTableNil(this.globals.L_State, this.nativeGlobalKey, index);
                break;
            }
            case 1: {
                LuaCApi._setTableBoolean(this.globals.L_State, this.nativeGlobalKey, index, value.toBoolean());
                break;
            }
            case 4: {
                LuaCApi._setTableString(this.globals.L_State, this.nativeGlobalKey, index, value.toJavaString());
                break;
            }
            default: {
                if (value.notInGlobalTable()) {
                    LuaCApi._setTableChild(this.globals.L_State, this.nativeGlobalKey, index, (Object)value);
                    break;
                }
                LuaCApi._setTableChild(this.globals.L_State, this.nativeGlobalKey, index, value.nativeGlobalKey(), t);
            }
        }
    }

    @Override
    public void set(int index, double num) {
        if (!this.checkValid()) {
            return;
        }
        LuaCApi._setTableNumber(this.globals.L_State, this.nativeGlobalKey, index, num);
    }

    @Override
    public void set(int index, boolean b) {
        if (!this.checkValid()) {
            return;
        }
        LuaCApi._setTableBoolean(this.globals.L_State, this.nativeGlobalKey, index, b);
    }

    @Override
    public void set(int index, String s) {
        if (!this.checkValid()) {
            return;
        }
        LuaCApi._setTableString(this.globals.L_State, this.nativeGlobalKey, index, s);
    }

    @Override
    public void set(String name, LuaValue value) {
        if (!this.checkValid()) {
            return;
        }
        int t = value.type();
        switch (t) {
            case 3: {
                LuaCApi._setTableNumber(this.globals.L_State, this.nativeGlobalKey, name, value.toDouble());
                break;
            }
            case 0: {
                LuaCApi._setTableNil(this.globals.L_State, this.nativeGlobalKey, name);
                break;
            }
            case 1: {
                LuaCApi._setTableBoolean(this.globals.L_State, this.nativeGlobalKey, name, value.toBoolean());
                break;
            }
            case 4: {
                LuaCApi._setTableString(this.globals.L_State, this.nativeGlobalKey, name, value.toJavaString());
                break;
            }
            default: {
                if (value.notInGlobalTable()) {
                    LuaCApi._setTableChild(this.globals.L_State, this.nativeGlobalKey, name, (Object)value);
                } else {
                    LuaCApi._setTableChild(this.globals.L_State, this.nativeGlobalKey, name, value.nativeGlobalKey(), t);
                }
                if (this != this.globals) break;
                value.destroy();
            }
        }
    }

    @Override
    public void set(String name, double num) {
        if (!this.checkValid()) {
            return;
        }
        LuaCApi._setTableNumber(this.globals.L_State, this.nativeGlobalKey, name, num);
    }

    @Override
    public void set(String name, boolean b) {
        if (!this.checkValid()) {
            return;
        }
        LuaCApi._setTableBoolean(this.globals.L_State, this.nativeGlobalKey, name, b);
    }

    @Override
    public void set(String name, String s) {
        if (!this.checkValid()) {
            return;
        }
        LuaCApi._setTableString(this.globals.L_State, this.nativeGlobalKey, name, s);
    }

    @Override
    public LuaValue get(int index) {
        if (!this.checkValid()) {
            return LuaTable.Nil();
        }
        return (LuaValue)LuaCApi._getTableValue(this.globals.L_State, this.nativeGlobalKey, index);
    }

    @Override
    public LuaValue get(String name) {
        if (!this.checkValid()) {
            return LuaTable.Nil();
        }
        return (LuaValue)LuaCApi._getTableValue(this.globals.L_State, this.nativeGlobalKey, name);
    }

    public final void clearArray(int from, int to) {
        if (!this.checkValid()) {
            return;
        }
        LuaCApi._clearTableArray(this.globals.L_State, this.nativeGlobalKey, from, to);
    }

    @Deprecated
    public final int size() {
        return this.newEntry().length;
    }

    public final int getn() {
        return LuaCApi._getTableSize(this.globals.L_State, this.nativeGlobalKey);
    }

    public final Entrys newEntry() {
        if (!this.checkValid()) {
            return EMPTY_ENTRYS;
        }
        return (Entrys)LuaCApi._getTableEntry(this.globals.L_State, this.nativeGlobalKey);
    }

    public final boolean startTraverseTable() {
        if (!this.checkValid()) {
            return false;
        }
        return LuaCApi._startTraverseTable(this.globals.L_State, this.nativeGlobalKey);
    }

    public final LuaValue[] next() {
        return LuaCApi._nextEntry(this.globals.L_State, this == this.globals);
    }

    public final void endTraverseTable() {
        LuaCApi._endTraverseTable(this.globals.L_State);
    }

    public final DisposableIterator<KV> iterator() {
        if (!this.startTraverseTable()) {
            return null;
        }
        return new DisposableIterator<KV>(){
            KV kv;

            @Override
            public void dispose() {
                LuaTable.this.endTraverseTable();
            }

            @Override
            public boolean hasNext() {
                LuaValue[] next2 = LuaTable.this.next();
                if (next2 == null) {
                    return false;
                }
                this.kv = new KV(next2[0], next2[1]);
                return true;
            }

            @Override
            public KV next() {
                return this.kv;
            }
        };
    }

    private boolean checkValid() {
        this.globals.checkMainThread();
        if (!this.isDestroyed() && !this.notInGlobalTable()) {
            return true;
        }
        if (MLNCore.DEBUG) {
            this.throwNotValid();
        }
        return false;
    }

    private void throwNotValid() {
        throw new IllegalStateException("table (" + this.nativeGlobalKey + ") is " + (this.destroyed ? "" : "not ") + "destroyed. global is " + (this.globals.isDestroyed() ? "destroyed" : "not destroyed"));
    }

    @Override
    public final int type() {
        return 5;
    }

    @Override
    public final LuaTable toLuaTable() {
        return this;
    }

    @Override
    public String toJavaString() {
        if (this.isDestroyed()) {
            return "table(" + this.nativeGlobalKey + ") is destroyed!";
        }
        return this.newEntry().toString();
    }

    @Override
    public boolean isDestroyed() {
        return this.globals.isDestroyed() || !this.checkStateByNative();
    }

    public static final class KV {
        public final LuaValue key;
        public final LuaValue value;

        private KV(LuaValue key, LuaValue value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + " : " + this.value;
        }
    }

    @LuaApiUsed
    public static final class Entrys
    implements Iterable<KV> {
        @LuaApiUsed
        private final LuaValue[] keys;
        @LuaApiUsed
        private final LuaValue[] values;
        private final int length;

        @LuaApiUsed
        private Entrys(LuaValue[] keys, LuaValue[] values) {
            this.keys = keys;
            this.values = values;
            this.length = this.keys.length;
        }

        public LuaValue[] keys() {
            return this.keys;
        }

        public LuaValue[] values() {
            return this.values;
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return "keys:" + Arrays.toString(this.keys) + "\nvalues:" + Arrays.toString(this.values);
        }

        @Override
        public Iterator<KV> iterator() {
            return new I(this.keys, this.values);
        }

        private static final class I
        implements Iterator<KV> {
            private final LuaValue[] keys;
            private final LuaValue[] values;
            private final int len;
            private int index;

            private I(LuaValue[] keys, LuaValue[] values) {
                this.keys = keys;
                this.values = values;
                this.len = keys.length;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.len;
            }

            @Override
            public KV next() {
                return new KV(this.keys[this.index], this.values[this.index++]);
            }
        }
    }
}

