/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaValue;
import org.luaj.vm2.utils.LuaApiUsed;

@LuaApiUsed
public final class LuaNumber
extends LuaValue {
    private static final int MAX_CACHE = 256;
    private static final int low = -128;
    private static final int high = 128;
    private static final LuaNumber[] cache = new LuaNumber[256];
    @LuaApiUsed
    private final double value;

    private LuaNumber(int value) {
        this.value = value;
    }

    @LuaApiUsed
    private LuaNumber(double value) {
        this.value = value;
    }

    @LuaApiUsed
    public static LuaNumber valueOf(int value) {
        if (value >= -128 && value < 128) {
            return cache[value - -128];
        }
        return new LuaNumber(value);
    }

    public static LuaNumber valueOf(double value) {
        if (value == (double)((int)value)) {
            return LuaNumber.valueOf((int)value);
        }
        return new LuaNumber(value);
    }

    @Override
    public int type() {
        return 3;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public String toJavaString() {
        if (this.value == (double)((int)this.value)) {
            return Integer.toString((int)this.value);
        }
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuaNumber luaNumber = (LuaNumber)o;
        return Double.compare(luaNumber.value, this.value) == 0;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return 31 + (int)(bits ^ bits >>> 32);
    }

    @Override
    public String toString() {
        return LUA_TYPE_NAME[this.type()] + "@" + this.value;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            LuaNumber.cache[i] = new LuaNumber(i - 128);
        }
    }
}

