/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import com.immomo.mlncore.MLNCore;
import org.luaj.vm2.LuaCApi;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.NLuaValue;
import org.luaj.vm2.exception.InvokeError;
import org.luaj.vm2.utils.LuaApiUsed;

@LuaApiUsed
public class LuaFunction
extends NLuaValue {
    private static final int LUA_MULTRET = -1;
    private InvokeError invokeError;

    @LuaApiUsed
    private LuaFunction(long L_state, long stackIndex) {
        super(L_state, stackIndex);
    }

    @Override
    public final int type() {
        return 6;
    }

    @Override
    public final LuaFunction toLuaFunction() {
        return this;
    }

    @Override
    public final LuaValue[] invoke(LuaValue[] params, int returnCount) throws InvokeError {
        try {
            if (!this.checkStatus()) {
                return LuaFunction.empty();
            }
            this.invokeError = null;
            ++this.globals.calledFunction;
            LuaValue[] ret2 = LuaCApi._invoke(this.globals.L_State, this.nativeGlobalKey, params, returnCount);
            --this.globals.calledFunction;
            return ret2;
        }
        catch (InvokeError e) {
            this.invokeError = e;
            --this.globals.calledFunction;
            if (this.globals.getState() != 100 && MLNCore.hookLuaError(e, this.globals)) {
                return LuaFunction.empty();
            }
            throw e;
        }
    }

    @Override
    public final LuaValue[] invoke(LuaValue[] params) throws InvokeError {
        return this.invoke(params, -1);
    }

    private boolean checkStatus() {
        if (this.globals.isDestroyed()) {
            this.invokeError = new InvokeError("globals is destroyed.", 2);
            if (MLNCore.DEBUG || this.globals.getState() == 100) {
                throw this.invokeError;
            }
            return false;
        }
        if (!this.checkStateByNative()) {
            this.invokeError = new InvokeError("function is destroyed.", 1);
            if (MLNCore.DEBUG || this.globals.getState() == 100) {
                throw this.invokeError;
            }
            return false;
        }
        this.globals.checkMainThread();
        return true;
    }

    @Override
    public final boolean isDestroyed() {
        return this.globals.isDestroyed() || !this.checkStateByNative();
    }

    public final InvokeError getInvokeError() {
        return this.invokeError;
    }
}

