/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import com.immomo.mlncore.MLNCore;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.luaj.vm2.JavaUserdata;
import org.luaj.vm2.LuaCApi;
import org.luaj.vm2.LuaConfigs;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.UserdataCache;
import org.luaj.vm2.exception.InvokeError;
import org.luaj.vm2.exception.UndumpError;
import org.luaj.vm2.utils.IGlobalsUserdata;
import org.luaj.vm2.utils.LuaApiUsed;
import org.luaj.vm2.utils.NativeLog;
import org.luaj.vm2.utils.ResourceFinder;
import org.luaj.vm2.utils.SignatureUtils;

@LuaApiUsed
public final class Globals
extends LuaTable {
    public static final int LUAC_VERSION = 83;
    public static final String LUAC_VERSION_STR = "5.2.4";
    public static final int LUA_OK = 0;
    public static final int LUA_YIELD = 1;
    public static final int LUA_ERRRUN = 2;
    public static final int LUA_ERRSYNTAX = 3;
    public static final int LUA_ERRMEM = 4;
    public static final int LUA_ERRGCMM = 5;
    public static final int LUA_ERRERR = 6;
    public static final int LUA_ERRINJAVA = -1;
    public static final int LUA_CALLING = 100;
    private static boolean init;
    private static boolean is32bit;
    private static final int JUST_INIT = Integer.MIN_VALUE;
    private static long LUA_GC_OFFSET;
    private static int LUA_GC_NUM_VALUES;
    static final long GLOBALS_INDEX = -1L;
    long L_State;
    final long parent_L_State;
    long calledFunction = 0L;
    private int state = Integer.MIN_VALUE;
    private String errorMsg = null;
    private Throwable error = null;
    private ResourceFinder resourceFinder;
    private Set<ResourceFinder> resourceFinders;
    private final HashMap<Class, String> luaClassNameMap;
    private IGlobalsUserdata javaUserdata;
    private List<OnDestroyListener> onDestroyListeners;
    private boolean debuggable;
    private Thread mainThread;
    final UserdataCache userdataCache = new UserdataCache();
    private String basePath;
    private String soPath;
    private boolean isGlobal;
    private long lastGcTime = 0L;
    private boolean inGC = false;
    private int destroyedValues = 0;
    private boolean running = false;
    private final String TAG;
    private static final HashMap<Long, Globals> cache;
    private static final HashMap<Long, Globals> g_cahce;
    private static final int DESTROYED = -2;
    private static final int NONE_LOOP = -3;
    private static final int SUCCESS = 0;

    private Globals(long L_State, long parent_L_State) {
        super(-1L);
        this.mainThread = Thread.currentThread();
        this.L_State = L_State;
        this.luaClassNameMap = new HashMap();
        this.parent_L_State = parent_L_State;
        this.TAG = "tag_" + this.hashCode();
    }

    public static boolean isInit() {
        if (!init) {
            try {
                is32bit = LuaCApi.is32bit();
                init = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return init;
    }

    public static boolean isIs32bit() {
        return is32bit;
    }

    public static void tryFullGc(int num) {
        if (num == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        for (final Globals g : cache.values()) {
            if (!g.canGc(now)) continue;
            g.post(new Runnable(){

                @Override
                public void run() {
                    g.gc();
                }
            });
            if (--num != 0) continue;
            return;
        }
    }

    public static boolean isENFile(String p) {
        return LuaCApi._isSAESFile(p);
    }

    public static void openSAES(boolean open) {
        LuaCApi._openSAES(open);
    }

    public static Globals createLState(boolean debuggable) {
        long vmPointer = LuaCApi._createLState(debuggable);
        Globals g = new Globals(vmPointer, 0L);
        g.setSoPath(LuaConfigs.soPath);
        g.debuggable = debuggable;
        Globals.saveGlobals(g);
        return g;
    }

    public static void preRegisterUserdata(String clz, String ... methods) {
        LuaCApi._preRegisterUD(clz, methods);
    }

    public static void preRegisterStatic(Class clz, String ... methods) {
        LuaCApi._preRegisterStatic(SignatureUtils.getClassName(clz), methods);
    }

    private static void saveGlobals(Globals g) {
        if (g.isGlobal) {
            g_cahce.put(g.L_State, g);
        } else {
            cache.put(g.L_State, g);
        }
    }

    @LuaApiUsed
    static void __onNativeCreateGlobals(long p_vm, long vm, boolean debuggable) {
        Globals g = new Globals(vm, p_vm);
        g.debuggable = debuggable;
        if (p_vm == 0L) {
            g.isGlobal = true;
            g.setBasePath(LuaConfigs.soPath, false);
            Globals.addAllPathRFFromGlobals(g);
        } else {
            Globals parent = Globals.getGlobalsByLState(p_vm);
            g.setJavaUserdata(parent.javaUserdata);
            g.setBasePath(parent.basePath, false);
            g.setSoPath(parent.soPath);
            g.setResourceFinder(parent.resourceFinder);
            if (parent.resourceFinders != null) {
                g.resourceFinders = new HashSet<ResourceFinder>(parent.resourceFinders);
            }
        }
        Globals.saveGlobals(g);
        MLNCore.onNativeCreateGlobals(g, p_vm == 0L);
    }

    @LuaApiUsed
    static void __onGlobalsDestroyInNative(long vm) {
        Globals globals = null;
        globals = cache.remove(vm);
        if (globals == null) {
            globals = g_cahce.remove(vm);
        }
        if (globals != null) {
            globals.destroy();
        }
    }

    public static Globals getGlobalsByLState(long state2) {
        Globals g = cache.get(state2);
        if (g == null) {
            g = g_cahce.get(state2);
        }
        return g;
    }

    public static int getLuaVmSize() {
        return cache.size() + g_cahce.size();
    }

    public static long getAllLVMMemUse() {
        return LuaCApi._allLvmMemUse();
    }

    public static long globalObjectSize() {
        return LuaCApi._globalObjectSize();
    }

    public static void logMemoryLeakInfo() {
        LuaCApi._logMemoryInfo();
    }

    public static void setGcOffset(int offset) {
        LuaCApi._setGcOffset(offset);
    }

    public static void setLuaGcOffset(long ms) {
        LUA_GC_OFFSET = ms;
    }

    public static void setNeedDestroyNumber(int n) {
        LUA_GC_NUM_VALUES = n;
    }

    public static void setDatabasePath(String path) {
        if (!new File(path).exists()) {
            throw new IllegalStateException(path + " is not exists!");
        }
        LuaCApi._setDatabasePath(path);
    }

    public final boolean isIsolate() {
        return this.parent_L_State != 0L;
    }

    public final void setBasePath(String basePath, boolean autoSave) {
        this.checkDestroy();
        this.basePath = basePath == null ? "" : basePath;
        LuaCApi._setBasePath(this.L_State, this.basePath, autoSave);
    }

    public final void setSoPath(String path) {
        if (path == null) {
            return;
        }
        this.checkDestroy();
        this.soPath = path;
        LuaCApi._setSoPath(this.L_State, path);
    }

    public final boolean savePreloadData(String chunkname, String savePath) throws RuntimeException {
        this.checkDestroy();
        return LuaCApi._savePreloadData(this.L_State, savePath, chunkname) == 0;
    }

    public final boolean startDebug(byte[] debug2, String ip, int port) {
        this.checkDestroy();
        if (!this.debuggable) {
            throw new IllegalStateException("cannot start debug in a lvm without debug state.");
        }
        try {
            this.state = LuaCApi._startDebug(this.L_State, debug2, ip, port);
        }
        catch (Throwable t) {
            this.error = t;
            this.errorMsg = t.getMessage();
            this.state = -1;
        }
        return this.state == 0;
    }

    public final boolean loadString(String chunkName, String lua) {
        return this.loadData(chunkName, lua.getBytes());
    }

    public final boolean compileAndSave(String file, String chunkName, byte[] data) {
        this.checkDestroy();
        try {
            this.state = LuaCApi._compileAndSave(this.L_State, file, chunkName, data);
        }
        catch (Throwable t) {
            this.error = t;
            this.errorMsg = t.getMessage();
            this.state = -1;
        }
        return this.state == 0;
    }

    public final boolean compileAndSave(String file, String path, String chunkName) {
        this.checkDestroy();
        try {
            this.state = LuaCApi._compilePathAndSave(this.L_State, file, path, chunkName);
        }
        catch (Throwable t) {
            this.error = t;
            this.errorMsg = t.getMessage();
            this.state = -1;
        }
        return this.state == 0;
    }

    public final boolean loadData(String chunkName, byte[] data) {
        this.checkDestroy();
        try {
            this.state = LuaCApi._loadData(this.L_State, chunkName, data);
        }
        catch (Throwable e) {
            this.error = e;
            this.errorMsg = e.getMessage();
            this.state = -1;
        }
        return this.state == 0;
    }

    public final boolean loadFile(String path, String chunkName) {
        this.checkDestroy();
        try {
            this.state = LuaCApi._loadFile(this.L_State, path, chunkName);
        }
        catch (Throwable e) {
            this.error = e;
            this.errorMsg = e.getMessage();
            this.state = -1;
        }
        return this.state == 0;
    }

    public final boolean loadAssetsFile(String path, String chunkName) {
        this.checkDestroy();
        try {
            this.state = LuaCApi._loadAssetsFile(this.L_State, path, chunkName);
        }
        catch (Throwable e) {
            this.error = e;
            this.errorMsg = e.getMessage();
            this.state = -1;
        }
        return this.state == 0;
    }

    public final void preloadData(String chunkName, byte[] data) throws UndumpError {
        this.checkDestroy();
        LuaCApi._preloadData(this.L_State, chunkName, data);
    }

    public final void preloadFile(String chunkName, String path) throws UndumpError {
        this.checkDestroy();
        LuaCApi._preloadFile(this.L_State, chunkName, path);
    }

    public final boolean setMainEntryFromPreload(String chunkname) {
        this.checkDestroy();
        if (LuaCApi._setMainEntryFromPreload(this.L_State, chunkname)) {
            this.state = 0;
            return true;
        }
        this.state = -404;
        this.errorMsg = "Did not find " + chunkname + " module from _preload table";
        this.error = new Exception(this.errorMsg);
        return false;
    }

    public final boolean callLoadedData() {
        this.checkDestroy();
        if (this.state != 0) {
            if (this.state == Integer.MIN_VALUE) {
                throw new IllegalStateException("Lua script is not loaded!");
            }
            throw new IllegalStateException("state of loading lua script is not ok, code: " + this.state);
        }
        try {
            this.state = 100;
            this.state = LuaCApi._doLoadedData(this.L_State);
        }
        catch (Throwable t) {
            this.error = t;
            this.state = -1;
            MLNCore.hookLuaError(t, this);
            this.errorMsg = t.getMessage();
        }
        return this.state == 0;
    }

    public final LuaValue[] callLoadedDataAndGetResult() throws IllegalStateException, InvokeError {
        this.checkDestroy();
        if (this.state != 0) {
            if (this.state == Integer.MIN_VALUE) {
                throw new IllegalStateException("Lua script is not loaded!");
            }
            throw new IllegalStateException("state of loading lua script is not ok, code: " + this.state);
        }
        this.state = 100;
        LuaValue[] ret2 = LuaCApi._doLoadedDataAndGetResult(this.L_State);
        this.state = 0;
        return ret2;
    }

    public final int getState() {
        return this.state;
    }

    public final String getErrorMsg() {
        return this.errorMsg;
    }

    public final Throwable getError() {
        return this.error;
    }

    public final void registerStaticBridgeSimple(String luaClassName, Class clz) {
        this.checkDestroy();
        LuaCApi._registerStaticClassSimple(this.L_State, SignatureUtils.getClassName(clz), luaClassName, Globals.findLuaParentClass(clz, this.luaClassNameMap));
        this.luaClassNameMap.put(clz, luaClassName);
    }

    public final void registerJavaMetatable(Class clz, String name) {
        LuaCApi._registerJavaMetatable(this.L_State, SignatureUtils.getClassName(clz), name);
    }

    public final void registerUserdataSimple(String luaClassName, Class<? extends LuaUserdata> clz) throws RuntimeException {
        this.checkDestroy();
        LuaCApi._registerUserdata(this.L_State, luaClassName, Globals.findLuaParentClass(clz, this.luaClassNameMap), SignatureUtils.getClassName(clz));
        this.luaClassNameMap.put(clz, luaClassName);
    }

    public final void registerAllUserdata(String[] lcns, String[] lpcns, String[] jcns, boolean[] lazy) throws RuntimeException {
        this.checkDestroy();
        int len2 = lcns.length;
        if (len2 != lpcns.length || len2 != jcns.length) {
            throw new IllegalArgumentException("lcns lpcns jcns must have same length");
        }
        LuaCApi._registerAllUserdata(this.L_State, lcns, lpcns, jcns, lazy);
    }

    public final void registerLazyUserdataSimple(String luaClassName, Class<? extends LuaUserdata> clz) throws RuntimeException {
        this.checkDestroy();
        LuaCApi._registerUserdataLazy(this.L_State, luaClassName, Globals.findLuaParentClass(clz, this.luaClassNameMap), SignatureUtils.getClassName(clz));
        this.luaClassNameMap.put(clz, luaClassName);
    }

    public final void registerNumberEnum(String lcn, String[] keys, double[] values) {
        this.checkDestroy();
        if (keys == null || values == null) {
            return;
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys and values must have same length!");
        }
        LuaCApi._registerNumberEnum(this.L_State, lcn, keys, values);
    }

    public final void registerStringEnum(String lcn, String[] keys, String[] values) {
        this.checkDestroy();
        if (keys == null || values == null) {
            return;
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys and values must have same length!");
        }
        LuaCApi._registerStringEnum(this.L_State, lcn, keys, values);
    }

    private static void addAllPathRFFromGlobals(Globals gg) {
        for (Globals g : cache.values()) {
            Set<ResourceFinder> grfs = g.resourceFinders;
            if (grfs == null) continue;
            gg.resourceFinders.addAll(grfs);
            if (g.resourceFinder == null) continue;
            gg.resourceFinders.add(g.resourceFinder);
        }
    }

    private static void addRFToGlobals(ResourceFinder rf) {
        for (Globals g : g_cahce.values()) {
            g.resourceFinders.add(rf);
        }
    }

    public void setResourceFinder(ResourceFinder rf) {
        this.resourceFinder = rf;
        if (!this.isGlobal) {
            Globals.addRFToGlobals(rf);
        }
    }

    public void setResourceFinders(Collection<ResourceFinder> rfs) {
        this.resourceFinders = new HashSet<ResourceFinder>(rfs);
    }

    public void addResourceFinder(ResourceFinder rf) {
        if (this.resourceFinders == null) {
            this.resourceFinders = new HashSet<ResourceFinder>();
        }
        this.resourceFinders.add(rf);
        if (!this.isGlobal) {
            Globals.addRFToGlobals(rf);
        }
    }

    public void clearResourceFinder() {
        if (this.resourceFinders != null) {
            this.resourceFinders.clear();
        }
    }

    public final void setRunning(boolean running2) {
        this.running = running2;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final long getLVMMemUse() {
        return LuaCApi._lvmMemUse(this.L_State);
    }

    public final LuaValue[] dump() {
        this.checkDestroy();
        return LuaCApi._dumpStack(this.L_State);
    }

    public final boolean post(Runnable r) {
        return false;
    }

    public final boolean postDelayed(Runnable r, long ms) {
        return false;
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed || this.L_State == 0L;
    }

    @Override
    public final void destroy() {
        this.checkMainThread();
        if (!this.isDestroyed() && MLNCore.DEBUG && (this.state == 100 || this.calledFunction > 0L)) {
            throw new IllegalStateException("throw in debug mode, cannot destroy lua vm when lua function is calling!");
        }
        if (this.isDestroyed()) {
            return;
        }
        if (this.onDestroyListeners != null) {
            for (OnDestroyListener l : this.onDestroyListeners) {
                l.onDestroy(this);
            }
            this.onDestroyListeners.clear();
        }
        this.destroyed = true;
        long pointer = this.L_State;
        this.L_State = 0L;
        if (!this.isIsolate()) {
            LuaCApi._close(pointer);
        }
        if (this.javaUserdata != null) {
            this.javaUserdata.onGlobalsDestroy(this);
        }
        this.javaUserdata = null;
        NativeLog.release(pointer);
        cache.remove(pointer);
        g_cahce.remove(pointer);
        this.luaClassNameMap.clear();
        this.resourceFinder = null;
        if (this.resourceFinders != null) {
            this.resourceFinders.clear();
        }
        this.userdataCache.onDestroy();
    }

    public final Object createUserdataAndSet(String key, String luaClassName, LuaValue ... params) throws RuntimeException {
        this.checkDestroy();
        return LuaCApi._createUserdataAndSet(this.L_State, key, luaClassName, params);
    }

    public final long getL_State() {
        return this.L_State;
    }

    public final void setJavaUserdata(IGlobalsUserdata userdata) {
        this.javaUserdata = userdata;
        NativeLog.register(this.L_State, userdata);
    }

    public final IGlobalsUserdata getJavaUserdata() {
        return this.javaUserdata;
    }

    public final String getLuaClassName(Class c) {
        return this.luaClassNameMap.get(c);
    }

    public final void putLuaClassName(Map<Class, String> other) {
        this.luaClassNameMap.putAll(other);
    }

    public synchronized void addOnDestroyListener(OnDestroyListener l) {
        if (l == null) {
            return;
        }
        if (this.onDestroyListeners == null) {
            this.onDestroyListeners = new ArrayList<OnDestroyListener>();
        }
        this.onDestroyListeners.add(l);
    }

    public synchronized void removeOnDestroyListener(OnDestroyListener l) {
        if (this.onDestroyListeners != null) {
            this.onDestroyListeners.remove(l);
        }
    }

    public static String findLuaParentClass(Class c, Map<Class, String> luaClassNameMap) {
        for (Class p = c; p != Object.class && p != JavaUserdata.class && p != LuaUserdata.class; p = p.getSuperclass()) {
            String s = luaClassNameMap.get(p);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    boolean hasLooper() {
        return false;
    }

    boolean isMainThread() {
        return this.mainThread == Thread.currentThread();
    }

    void checkMainThread() {
        if (!this.isMainThread()) {
            throw new IllegalStateException("must called in main thread: " + this.globals.mainThread);
        }
    }

    long globalsIndex() {
        return -1L;
    }

    boolean removeStack(LuaValue value) {
        if (value instanceof Globals) {
            return false;
        }
        this.checkDestroy();
        long key = value.nativeGlobalKey();
        if (key == 0L || key == -1L) {
            return true;
        }
        if (this.isMainThread() && this.canDestroySync()) {
            boolean destroy;
            boolean bl = destroy = LuaCApi._removeNativeValue(this.L_State, key, value.type()) <= 0;
            if (destroy) {
                ++this.destroyedValues;
                this.gc();
            }
            return destroy;
        }
        return false;
    }

    private boolean canDestroySync() {
        return !this.inGC || System.currentTimeMillis() - this.lastGcTime < 10L;
    }

    private boolean canGc(long time) {
        if (this.inGC || this.state == Integer.MIN_VALUE || this.isDestroyed()) {
            return false;
        }
        return time - this.lastGcTime > LUA_GC_OFFSET;
    }

    private boolean gc() {
        long now = System.currentTimeMillis();
        if (this.canGc(now) && this.destroyedValues > LUA_GC_NUM_VALUES) {
            this.destroyedValues = 0;
            this.lastGcTime = now;
            this.inGC = true;
            LuaCApi._lgc(this.L_State);
            this.lastGcTime = System.currentTimeMillis();
            MLNCore.luaGcCast(this, this.lastGcTime - now);
            this.inGC = false;
            return true;
        }
        return false;
    }

    void pop(int num) {
        this.checkDestroy();
        LuaCApi._pop(this.L_State, num);
    }

    void pop() {
        this.checkDestroy();
        LuaCApi._pop(this.L_State, 1);
    }

    @Override
    public final void set(int index, LuaValue value) {
        this.unsupported();
    }

    @Override
    public final void set(int index, double num) {
        this.unsupported();
    }

    @Override
    public final void set(int index, boolean b) {
        this.unsupported();
    }

    @Override
    public final void set(int index, String s) {
        this.unsupported();
    }

    @Override
    public final LuaValue get(int index) {
        this.unsupported();
        return null;
    }

    private void unsupported() {
        throw new UnsupportedOperationException("global is not support set/get a number key!");
    }

    @LuaApiUsed
    private static Object __onLuaRequire(long L, String name) {
        return Globals.getGlobalsByLState(L).onRequire(name);
    }

    @LuaApiUsed
    private static void __onLuaGC(long L) {
    }

    @LuaApiUsed
    private static int __postCallback(long L, long method, long args) {
        Globals g = Globals.getGlobalsByLState(L);
        if (g == null || g.isDestroyed()) {
            return -2;
        }
        if (!g.hasLooper()) {
            return -3;
        }
        return 0;
    }

    private Object onRequire(String name) {
        Object ret2 = Globals.findResource(this.resourceFinder, name);
        if (ret2 != null) {
            return ret2;
        }
        if (this.resourceFinders != null) {
            for (ResourceFinder rf : this.resourceFinders) {
                ret2 = Globals.findResource(rf, name);
                if (ret2 == null) continue;
                return ret2;
            }
        }
        return null;
    }

    @LuaApiUsed
    static Object __getUserdata(long L, long id) {
        Globals g = Globals.getGlobalsByLState(L);
        if (g == null) {
            return null;
        }
        return g.userdataCache.get(id);
    }

    private void checkDestroy() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("this lua vm is destroyed!");
        }
    }

    private static Object findResource(ResourceFinder rf, String name) {
        if (rf != null) {
            String path = rf.findPath(name = rf.preCompress(name));
            if (path != null) {
                return path;
            }
            byte[] data = rf.getContent(name);
            if (data != null) {
                rf.afterContentUse(name);
                return data;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "Globals#" + this.hashCode();
    }

    @Override
    public int hashCode() {
        return (int)(this.L_State ^ this.L_State >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    static {
        LUA_GC_OFFSET = 10000L;
        LUA_GC_NUM_VALUES = 100;
        cache = new HashMap();
        g_cahce = new HashMap();
    }

    public static interface OnDestroyListener {
        public void onDestroy(Globals var1);
    }
}

