/*
 * Decompiled with CFR 0.152.
 */
package com.mogaleaf.usbmuxd.protocol;

import com.mogaleaf.usbmuxd.api.IUsbMuxd;
import com.mogaleaf.usbmuxd.api.exception.UsbMuxdConnectException;
import com.mogaleaf.usbmuxd.api.exception.UsbMuxdException;
import com.mogaleaf.usbmuxd.api.model.Device;
import com.mogaleaf.usbmuxd.api.model.DeviceConnectionMessage;
import com.mogaleaf.usbmuxd.api.model.UsbMuxdConnection;
import com.mogaleaf.usbmuxd.protocol.ConnectedMessage;
import com.mogaleaf.usbmuxd.protocol.DeviceConnecter;
import com.mogaleaf.usbmuxd.protocol.DeviceListener;
import com.mogaleaf.usbmuxd.protocol.PlistMessageService;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class UsbMuxdImpl
implements IUsbMuxd {
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    protected DeviceListener deviceListener = new DeviceListener();
    protected DeviceConnecter deviceConnecter = new DeviceConnecter();
    private Map<Integer, Device> connectedDevices = Collections.synchronizedMap(new LinkedHashMap());
    protected boolean isStarted = false;
    private Socket connectionListeningSocket;
    private String registerUid;

    protected abstract SocketAddress getAddress() throws IOException;

    protected abstract Socket getSocketImpl() throws IOException;

    @Override
    public Collection<Device> connectedDevices() {
        ArrayList<Device> copy = new ArrayList<Device>();
        copy.addAll(this.connectedDevices.values());
        return copy;
    }

    @Override
    public UsbMuxdConnection connectToFirstDevice(int port, long time, TimeUnit timeUnit) throws UsbMuxdException {
        try {
            if (this.isStarted && !this.connectedDevices.isEmpty()) {
                return this.connectToDevice(port, this.connectedDevices.values().iterator().next());
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Device[] singletonDevice = new Device[1];
            String register = this.deviceListener.register(m -> {
                singletonDevice[0] = m.device;
                countDownLatch.countDown();
            });
            if (!this.isStarted) {
                this.startListening();
            }
            if (time > 0L) {
                countDownLatch.await(time, timeUnit);
            } else {
                countDownLatch.await();
            }
            this.deviceListener.unregister(register);
            return this.connectToDevice(port, singletonDevice[0]);
        }
        catch (UsbMuxdConnectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UsbMuxdException(e);
        }
    }

    @Override
    public UsbMuxdConnection connectToFirstDevice(int port) throws UsbMuxdException {
        return this.connectToFirstDevice(port, -1L, null);
    }

    @Override
    public UsbMuxdConnection connectToDevice(int port, Device device) throws UsbMuxdException {
        return this.connectToDevice(port, device, -1L, null);
    }

    @Override
    public UsbMuxdConnection connectToDevice(int port, Device device, long time, TimeUnit timeUnit) throws UsbMuxdException {
        try {
            Socket connectionSocket = this.getSocketImpl();
            connectionSocket.connect(this.getAddress());
            byte[] connectByteMessage = PlistMessageService.buildConnectMsg(device.deviceId, port);
            InputStream inputStream = connectionSocket.getInputStream();
            Future<ConnectedMessage> submit = this.executorService.submit(() -> this.deviceConnecter.getConnectionResult(inputStream));
            connectionSocket.getOutputStream().write(connectByteMessage);
            ConnectedMessage connectedMessage = time > 0L ? submit.get(time, timeUnit) : submit.get();
            if (connectedMessage.result != 0) {
                connectedMessage.throwException();
            }
            UsbMuxdConnection usbMuxdConnection = new UsbMuxdConnection();
            usbMuxdConnection.inputStream = inputStream;
            usbMuxdConnection.outputStream = connectionSocket.getOutputStream();
            usbMuxdConnection.device = device;
            return usbMuxdConnection;
        }
        catch (UsbMuxdConnectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UsbMuxdException(e);
        }
    }

    @Override
    public void startListening() throws UsbMuxdException {
        try {
            this.connectionListeningSocket = this.getSocketImpl();
            this.connectionListeningSocket.connect(this.getAddress());
            byte[] connectByteMessage = PlistMessageService.buildListenConnectionMsg();
            InputStream inputStream = this.connectionListeningSocket.getInputStream();
            this.deviceListener.start(inputStream);
            this.isStarted = true;
            this.registerUid = this.deviceListener.register(m -> {
                switch (m.type) {
                    case Add: {
                        this.connectedDevices.put(m.device.deviceId, m.device);
                        break;
                    }
                    case Remove: {
                        this.connectedDevices.remove(m.device.deviceId);
                    }
                }
            });
            this.connectionListeningSocket.getOutputStream().write(connectByteMessage);
            this.executorService.execute(this.deviceListener);
        }
        catch (Exception e) {
            throw new UsbMuxdException(e);
        }
    }

    @Override
    public void stopListening() throws UsbMuxdException {
        if (this.isStarted) {
            this.deviceListener.stop();
            this.deviceListener.unregister(this.registerUid);
            try {
                this.connectionListeningSocket.close();
            }
            catch (IOException e) {
                this.connectionListeningSocket = null;
            }
        }
        this.isStarted = false;
    }

    @Override
    public String registerDeviceConnectionListener(Consumer<DeviceConnectionMessage> consumer) {
        return this.deviceListener.register(consumer);
    }

    @Override
    public void unRegisterDeviceConnectionListener(String uid) {
        this.deviceListener.unregister(uid);
    }
}

