/*
 * Decompiled with CFR 0.152.
 */
package com.mogaleaf.usbmuxd.protocol;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PlistMessageService {
    public static byte[] buildListenConnectionMsg() {
        byte[] bytes = PlistMessageService.buildPlistConnectionMsg();
        return PlistMessageService.buildByteMsg(bytes).array();
    }

    public static byte[] buildConnectMsg(int deviceId, int port) {
        byte[] bytes = PlistMessageService.buildDeviceConnectMsg(deviceId, port);
        return PlistMessageService.buildByteMsg(bytes).array();
    }

    protected static byte[] buildDeviceConnectMsg(int deviceId, int port) {
        NSDictionary root = new NSDictionary();
        root.put("MessageType", (Object)"Connect");
        root.put("ClientVersionString", (Object)"mogaleaf-usbmux-driver");
        root.put("ProgName", (Object)"mogaleaf-usbmux-driver");
        root.put("DeviceID", (NSObject)new NSNumber(deviceId));
        root.put("PortNumber", (NSObject)new NSNumber(PlistMessageService.swapPortNumber(port)));
        String s = root.toXMLPropertyList();
        return s.getBytes(Charset.forName("UTF-8"));
    }

    protected static int swapPortNumber(int port) {
        return port << 8 & 0xFF00 | port >> 8;
    }

    protected static byte[] buildPlistConnectionMsg() {
        NSDictionary root = new NSDictionary();
        root.put("MessageType", (Object)"Listen");
        root.put("ClientVersionString", (Object)"mogaleaf-usbmux-driver");
        root.put("ProgName", (Object)"mogaleaf-usbmux-driver");
        String s = root.toXMLPropertyList();
        return s.getBytes(Charset.forName("UTF-8"));
    }

    protected static ByteBuffer buildByteMsg(byte[] bytes) {
        int len2 = 16 + bytes.length;
        int version = 1;
        int request = 8;
        int tag = 1;
        ByteBuffer buffer = ByteBuffer.allocate(len2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(0, len2);
        buffer.putInt(4, version);
        buffer.putInt(8, request);
        buffer.putInt(12, tag);
        int i = 16;
        for (byte aByte : bytes) {
            buffer.put(i++, aByte);
        }
        return buffer;
    }

    public static NSDictionary getNsDictionary(InputStream input, int size) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        byte[] body = new byte[size];
        input.read(body);
        NSObject parse = PropertyListParser.parse((byte[])body);
        return (NSDictionary)parse;
    }

    public static int getSize(InputStream input) throws IOException {
        byte[] header = new byte[16];
        input.read(header);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(header);
        return buffer.getInt(0) - 16;
    }

    public static ResultType retrieveMsgType(NSDictionary dico) {
        NSString messageType = (NSString)dico.get((Object)"MessageType");
        return ResultType.valueOf(messageType.getContent());
    }

    public static byte[] tryLockDown() {
        NSDictionary root = new NSDictionary();
        root.put("Label", (Object)"iTunesHelper");
        root.put("Request", (Object)"QueryType");
        String s = root.toXMLPropertyList();
        System.out.println(s);
        return s.getBytes(Charset.forName("UTF-8"));
    }

    public static enum ResultType {
        Attached,
        Detached,
        Paired,
        Result,
        Error;

    }
}

