/*
 * Decompiled with CFR 0.152.
 */
package com.mogaleaf.usbmuxd.protocol;

import com.dd.plist.NSDictionary;
import com.mogaleaf.usbmuxd.api.model.Device;
import com.mogaleaf.usbmuxd.api.model.DeviceConnectionMessage;
import com.mogaleaf.usbmuxd.protocol.PlistMessageService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;

public class DeviceListener
implements Runnable {
    private InputStream inputStream;
    private boolean running = false;
    private final Map<String, Consumer<DeviceConnectionMessage>> consumers = Collections.synchronizedMap(new HashMap());

    public String register(Consumer<DeviceConnectionMessage> deviceConnectionListener) {
        String uid = UUID.randomUUID().toString();
        this.consumers.put(uid, deviceConnectionListener);
        return uid;
    }

    public void unregister(String uid) {
        this.consumers.remove(uid);
    }

    public void start(InputStream inputStream) {
        this.inputStream = inputStream;
        this.running = true;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                int size = PlistMessageService.getSize(this.inputStream);
                if (size <= 0) continue;
                NSDictionary dico = PlistMessageService.getNsDictionary(this.inputStream, size);
                PlistMessageService.ResultType messageTypeEnum = PlistMessageService.retrieveMsgType(dico);
                DeviceConnectionMessage deviceConnectionMessage = new DeviceConnectionMessage();
                switch (messageTypeEnum) {
                    case Attached: {
                        Device deviceAttachMessage;
                        System.out.println("+++ ios" + dico);
                        deviceConnectionMessage.device = deviceAttachMessage = this.buildDevice(dico);
                        deviceConnectionMessage.type = DeviceConnectionMessage.Type.Add;
                        this.notify(deviceConnectionMessage);
                        break;
                    }
                    case Detached: {
                        Device deviceDetachMessage = new Device();
                        deviceDetachMessage.deviceId = Integer.valueOf(dico.get((Object)"DeviceID").toString());
                        deviceConnectionMessage.device = deviceDetachMessage;
                        deviceConnectionMessage.type = DeviceConnectionMessage.Type.Remove;
                        this.notify(deviceConnectionMessage);
                    }
                }
            }
            catch (Exception e) {
                this.stop();
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(DeviceConnectionMessage deviceMsg) {
        Map<String, Consumer<DeviceConnectionMessage>> map = this.consumers;
        synchronized (map) {
            this.consumers.values().forEach(c -> c.accept(deviceMsg));
        }
    }

    private Device buildDevice(NSDictionary dico) {
        Device deviceAttachMessage = new Device();
        NSDictionary properties = (NSDictionary)dico.get((Object)"Properties");
        if (properties != null) {
            deviceAttachMessage.serialNumber = properties.get((Object)"SerialNumber").toString();
            deviceAttachMessage.connectionType = properties.get((Object)"ConnectionType").toString();
            deviceAttachMessage.deviceId = Integer.valueOf(properties.get((Object)"DeviceID").toString());
            deviceAttachMessage.locationId = properties.get((Object)"LocationID").toString();
            deviceAttachMessage.productId = properties.get((Object)"ProductID").toString();
            deviceAttachMessage.osType = "iOS";
        }
        return deviceAttachMessage;
    }

    public void stop() {
        if (this.running) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                this.inputStream = null;
            }
        }
        this.running = false;
    }
}

