/*
 * Decompiled with CFR 0.152.
 */
package com.luaj.vm2.script;

import com.luaj.vm2.Globals;
import com.luaj.vm2.LuaClosure;
import com.luaj.vm2.LuaFunction;
import com.luaj.vm2.LuaTable;
import com.luaj.vm2.LuaValue;
import com.luaj.vm2.Varargs;
import com.luaj.vm2.lib.ThreeArgFunction;
import com.luaj.vm2.lib.TwoArgFunction;
import com.luaj.vm2.lib.jse.CoerceJavaToLua;
import com.luaj.vm2.script.LuaScriptEngineFactory;
import com.luaj.vm2.script.LuajContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class LuaScriptEngine
extends AbstractScriptEngine
implements ScriptEngine,
Compilable {
    private static final String __ENGINE_VERSION__ = "Luaj 0.0";
    private static final String __NAME__ = "Luaj";
    private static final String __SHORT_NAME__ = "Luaj";
    private static final String __LANGUAGE__ = "lua";
    private static final String __LANGUAGE_VERSION__ = "5.2";
    private static final String __ARGV__ = "arg";
    private static final String __FILENAME__ = "?";
    private static final ScriptEngineFactory myFactory = new LuaScriptEngineFactory();
    private LuajContext context = new LuajContext();

    public LuaScriptEngine() {
        this.context.setBindings(this.createBindings(), 100);
        this.setContext(this.context);
        this.put("javax.script.language_version", __LANGUAGE_VERSION__);
        this.put("javax.script.language", __LANGUAGE__);
        this.put("javax.script.engine", "Luaj");
        this.put("javax.script.engine_version", __ENGINE_VERSION__);
        this.put("javax.script.argv", __ARGV__);
        this.put("javax.script.filename", __FILENAME__);
        this.put("javax.script.name", "Luaj");
        this.put("THREADING", null);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try (Utf8Encoder is = new Utf8Encoder(script);){
            Globals g = this.context.globals;
            LuaFunction f = g.load(script, "script").checkfunction();
            LuajCompiledScript luajCompiledScript = new LuajCompiledScript(f, g);
            return luajCompiledScript;
        }
        catch (Exception e) {
            throw new ScriptException("eval threw " + e.toString());
        }
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return ((LuajCompiledScript)this.compile(reader)).eval(this.context.globals, bindings);
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        return this.eval((Reader)new StringReader(script), bindings);
    }

    @Override
    protected ScriptContext getScriptContext(Bindings nn) {
        throw new IllegalStateException("LuajScriptEngine should not be allocating contexts.");
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object eval(String script, ScriptContext context2) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context2);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context2) throws ScriptException {
        return this.compile(reader).eval(context2);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return myFactory;
    }

    private static LuaValue toLua(Object javaValue) {
        return javaValue == null ? LuaValue.NIL : (javaValue instanceof LuaValue ? (LuaValue)javaValue : CoerceJavaToLua.coerce(javaValue));
    }

    private static Object toJava(LuaValue luajValue) {
        switch (luajValue.type()) {
            case 0: {
                return null;
            }
            case 4: {
                return luajValue.tojstring();
            }
            case 7: {
                return luajValue.checkuserdata(Object.class);
            }
            case 3: {
                return luajValue.isinttype() ? (Number)new Integer(luajValue.toint()) : (Number)new Double(luajValue.todouble());
            }
        }
        return luajValue;
    }

    private static Object toJava(Varargs v) {
        int n = v.narg();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return LuaScriptEngine.toJava(v.arg1());
            }
        }
        Object[] o = new Object[n];
        for (int i = 0; i < n; ++i) {
            o[i] = LuaScriptEngine.toJava(v.arg(i + 1));
        }
        return o;
    }

    static class BindingsMetatable
    extends LuaTable {
        BindingsMetatable(final Bindings bindings) {
            this.rawset(LuaValue.INDEX, (LuaValue)new TwoArgFunction(){

                @Override
                public LuaValue call(LuaValue table, LuaValue key) {
                    if (key.isstring()) {
                        return LuaScriptEngine.toLua(bindings.get(key.tojstring()));
                    }
                    return this.rawget(key);
                }
            });
            this.rawset(LuaValue.NEWINDEX, (LuaValue)new ThreeArgFunction(){

                @Override
                public LuaValue call(LuaValue table, LuaValue key, LuaValue value) {
                    if (key.isstring()) {
                        String k = key.tojstring();
                        Object v = LuaScriptEngine.toJava(value);
                        if (v == null) {
                            bindings.remove(k);
                        } else {
                            bindings.put(k, v);
                        }
                    } else {
                        this.rawset(key, value);
                    }
                    return LuaValue.NONE;
                }
            });
        }
    }

    private final class Utf8Encoder
    extends InputStream {
        private final Reader r;
        private final int[] buf = new int[2];
        private int n;

        private Utf8Encoder(Reader r) {
            this.r = r;
        }

        @Override
        public int read() throws IOException {
            if (this.n > 0) {
                return this.buf[--this.n];
            }
            int c = this.r.read();
            if (c < 128) {
                return c;
            }
            this.n = 0;
            if (c < 2048) {
                this.buf[this.n++] = 0x80 | c & 0x3F;
                return 0xC0 | c >> 6 & 0x1F;
            }
            this.buf[this.n++] = 0x80 | c & 0x3F;
            this.buf[this.n++] = 0x80 | c >> 6 & 0x3F;
            return 0xE0 | c >> 12 & 0xF;
        }
    }

    class LuajCompiledScript
    extends CompiledScript {
        final LuaFunction function;
        final Globals compiling_globals;

        LuajCompiledScript(LuaFunction function, Globals compiling_globals) {
            this.function = function;
            this.compiling_globals = compiling_globals;
        }

        @Override
        public ScriptEngine getEngine() {
            return LuaScriptEngine.this;
        }

        @Override
        public Object eval() throws ScriptException {
            return this.eval(LuaScriptEngine.this.getContext());
        }

        @Override
        public Object eval(Bindings bindings) throws ScriptException {
            return this.eval(((LuajContext)LuaScriptEngine.this.getContext()).globals, bindings);
        }

        @Override
        public Object eval(ScriptContext context2) throws ScriptException {
            return this.eval(((LuajContext)context2).globals, context2.getBindings(100));
        }

        Object eval(Globals g, Bindings b) throws ScriptException {
            g.setmetatable(new BindingsMetatable(b));
            LuaFunction f = this.function;
            if (f.isclosure()) {
                f = new LuaClosure(f.checkclosure().p, g);
            } else {
                try {
                    f = (LuaFunction)f.getClass().newInstance();
                }
                catch (Exception e) {
                    throw new ScriptException(e);
                }
                f.initupvalue1(g);
            }
            return LuaScriptEngine.toJava(f.invoke(LuaValue.NONE));
        }
    }
}

