/*
 * Decompiled with CFR 0.152.
 */
package com.luaj.vm2.lib.jse;

import com.luaj.vm2.LuaError;
import com.luaj.vm2.LuaUserdata;
import com.luaj.vm2.LuaValue;
import com.luaj.vm2.lib.jse.CoerceJavaToLua;
import com.luaj.vm2.lib.jse.CoerceLuaToJava;
import com.luaj.vm2.lib.jse.JavaClass;
import java.lang.reflect.Field;

class JavaInstance
extends LuaUserdata {
    JavaClass jclass;

    JavaInstance(Object instance) {
        super(instance);
    }

    @Override
    public LuaValue get(LuaValue key) {
        Field f;
        if (this.jclass == null) {
            this.jclass = JavaClass.forClass(this.m_instance.getClass());
        }
        if ((f = this.jclass.getField(key)) != null) {
            try {
                return CoerceJavaToLua.coerce(f.get(this.m_instance));
            }
            catch (Exception e) {
                throw new LuaError(e);
            }
        }
        LuaValue m = this.jclass.getMethod(key);
        if (m != null) {
            return m;
        }
        Class c = this.jclass.getInnerClass(key);
        if (c != null) {
            return JavaClass.forClass(c);
        }
        return super.get(key);
    }

    @Override
    public void set(LuaValue key, LuaValue value) {
        Field f;
        if (this.jclass == null) {
            this.jclass = JavaClass.forClass(this.m_instance.getClass());
        }
        if ((f = this.jclass.getField(key)) != null) {
            try {
                f.set(this.m_instance, CoerceLuaToJava.coerce(value, f.getType()));
                return;
            }
            catch (Exception e) {
                throw new LuaError(e);
            }
        }
        super.set(key, value);
    }
}

