/*
 * Decompiled with CFR 0.152.
 */
package com.luaj.vm2.lib.jse;

import com.luaj.vm2.LuaTable;
import com.luaj.vm2.LuaUserdata;
import com.luaj.vm2.LuaValue;
import com.luaj.vm2.lib.OneArgFunction;
import com.luaj.vm2.lib.jse.CoerceJavaToLua;
import com.luaj.vm2.lib.jse.CoerceLuaToJava;
import java.lang.reflect.Array;

class JavaArray
extends LuaUserdata {
    static final LuaValue LENGTH = JavaArray.valueOf("length");
    static final LuaTable array_metatable = new LuaTable();

    JavaArray(Object instance) {
        super(instance);
        this.setmetatable(array_metatable);
    }

    @Override
    public LuaValue get(LuaValue key) {
        if (key.equals(LENGTH)) {
            return JavaArray.valueOf(Array.getLength(this.m_instance));
        }
        if (key.isint()) {
            int i = key.toint() - 1;
            return i >= 0 && i < Array.getLength(this.m_instance) ? CoerceJavaToLua.coerce(Array.get(this.m_instance, key.toint() - 1)) : NIL;
        }
        return super.get(key);
    }

    @Override
    public void set(LuaValue key, LuaValue value) {
        if (key.isint()) {
            int i = key.toint() - 1;
            if (i >= 0 && i < Array.getLength(this.m_instance)) {
                Array.set(this.m_instance, i, CoerceLuaToJava.coerce(value, this.m_instance.getClass().getComponentType()));
            } else if (this.m_metatable == null || !JavaArray.settable(this, key, value)) {
                JavaArray.error("array index out of bounds");
            }
        } else {
            super.set(key, value);
        }
    }

    static {
        array_metatable.rawset(LuaValue.LEN, (LuaValue)new LenFunction());
    }

    private static final class LenFunction
    extends OneArgFunction {
        private LenFunction() {
        }

        @Override
        public LuaValue call(LuaValue u) {
            return LuaValue.valueOf(Array.getLength(((LuaUserdata)u).m_instance));
        }
    }
}

