/*
 * Decompiled with CFR 0.152.
 */
package com.luaj.vm2.lib;

import com.luaj.vm2.Globals;
import com.luaj.vm2.LuaString;
import com.luaj.vm2.LuaTable;
import com.luaj.vm2.LuaValue;
import com.luaj.vm2.Varargs;
import com.luaj.vm2.lib.TwoArgFunction;
import com.luaj.vm2.lib.VarArgFunction;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;

public abstract class IoLib
extends TwoArgFunction {
    protected static final int FTYPE_STDIN = 0;
    protected static final int FTYPE_STDOUT = 1;
    protected static final int FTYPE_STDERR = 2;
    protected static final int FTYPE_NAMED = 3;
    private File infile = null;
    private File outfile = null;
    private File errfile = null;
    private static final LuaValue STDIN = IoLib.valueOf("stdin");
    private static final LuaValue STDOUT = IoLib.valueOf("stdout");
    private static final LuaValue STDERR = IoLib.valueOf("stderr");
    private static final LuaValue FILE = IoLib.valueOf("file");
    private static final LuaValue CLOSED_FILE = IoLib.valueOf("closed file");
    private static final int IO_CLOSE = 0;
    private static final int IO_FLUSH = 1;
    private static final int IO_INPUT = 2;
    private static final int IO_LINES = 3;
    private static final int IO_OPEN = 4;
    private static final int IO_OUTPUT = 5;
    private static final int IO_POPEN = 6;
    private static final int IO_READ = 7;
    private static final int IO_TMPFILE = 8;
    private static final int IO_TYPE = 9;
    private static final int IO_WRITE = 10;
    private static final int FILE_CLOSE = 11;
    private static final int FILE_FLUSH = 12;
    private static final int FILE_LINES = 13;
    private static final int FILE_READ = 14;
    private static final int FILE_SEEK = 15;
    private static final int FILE_SETVBUF = 16;
    private static final int FILE_WRITE = 17;
    private static final int IO_INDEX = 18;
    private static final int LINES_ITER = 19;
    public static final String[] IO_NAMES = new String[]{"close", "flush", "input", "lines", "open", "output", "popen", "read", "tmpfile", "type", "write"};
    public static final String[] FILE_NAMES = new String[]{"close", "flush", "lines", "read", "seek", "setvbuf", "write"};
    LuaTable filemethods;
    protected Globals globals;

    protected abstract File wrapStdin() throws IOException;

    protected abstract File wrapStdout() throws IOException;

    protected abstract File wrapStderr() throws IOException;

    protected abstract File openFile(String var1, boolean var2, boolean var3, boolean var4, boolean var5) throws IOException;

    protected abstract File tmpFile() throws IOException;

    protected abstract File openProgram(String var1, String var2) throws IOException;

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        this.globals = env.checkglobals();
        LuaTable t = new LuaTable();
        this.bind(t, IoLibV.class, IO_NAMES);
        this.filemethods = new LuaTable();
        this.bind(this.filemethods, IoLibV.class, FILE_NAMES, 11);
        LuaTable mt = new LuaTable();
        this.bind(mt, IoLibV.class, new String[]{"__index"}, 18);
        t.setmetatable(mt);
        this.setLibInstance(t);
        this.setLibInstance(this.filemethods);
        this.setLibInstance(mt);
        env.set("io", (LuaValue)t);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set("io", (LuaValue)t);
        }
        return t;
    }

    private void setLibInstance(LuaTable t) {
        LuaValue[] k = t.keys();
        int n = k.length;
        for (int i = 0; i < n; ++i) {
            ((IoLibV)t.get((LuaValue)k[i])).iolib = this;
        }
    }

    private File input() {
        return this.infile != null ? this.infile : (this.infile = this.ioopenfile(0, "-", "r"));
    }

    public Varargs _io_flush() throws IOException {
        IoLib.checkopen(this.output());
        this.outfile.flush();
        return LuaValue.TRUE;
    }

    public Varargs _io_tmpfile() throws IOException {
        return this.tmpFile();
    }

    public Varargs _io_close(LuaValue file) throws IOException {
        File f = file.isnil() ? this.output() : IoLib.checkfile(file);
        IoLib.checkopen(f);
        return IoLib.ioclose(f);
    }

    public Varargs _io_input(LuaValue file) {
        this.infile = file.isnil() ? this.input() : (file.isstring() ? this.ioopenfile(3, file.checkjstring(), "r") : IoLib.checkfile(file));
        return this.infile;
    }

    public Varargs _io_output(LuaValue filename) {
        this.outfile = filename.isnil() ? this.output() : (filename.isstring() ? this.ioopenfile(3, filename.checkjstring(), "w") : IoLib.checkfile(filename));
        return this.outfile;
    }

    public Varargs _io_type(LuaValue obj) {
        File f = IoLib.optfile(obj);
        return f != null ? (f.isclosed() ? CLOSED_FILE : FILE) : NIL;
    }

    public Varargs _io_popen(String prog, String mode) throws IOException {
        if (!"r".equals(mode) && !"w".equals(mode)) {
            IoLib.argerror(2, "invalid value: '" + mode + "'; must be one of 'r' or 'w'");
        }
        return this.openProgram(prog, mode);
    }

    public Varargs _io_open(String filename, String mode) throws IOException {
        return this.rawopenfile(3, filename, mode);
    }

    public Varargs _io_lines(Varargs args) {
        String filename = args.optjstring(1, null);
        File infile = filename == null ? this.input() : this.ioopenfile(3, filename, "r");
        IoLib.checkopen(infile);
        return this.lines(infile, filename != null, args.subargs(2));
    }

    public Varargs _io_read(Varargs args) throws IOException {
        IoLib.checkopen(this.input());
        return this.ioread(this.infile, args);
    }

    public Varargs _io_write(Varargs args) throws IOException {
        IoLib.checkopen(this.output());
        return IoLib.iowrite(this.outfile, args);
    }

    public Varargs _file_close(LuaValue file) throws IOException {
        return IoLib.ioclose(IoLib.checkfile(file));
    }

    public Varargs _file_flush(LuaValue file) throws IOException {
        IoLib.checkfile(file).flush();
        return LuaValue.TRUE;
    }

    public Varargs _file_setvbuf(LuaValue file, String mode, int size) {
        if (!("no".equals(mode) || "full".equals(mode) || "line".equals(mode))) {
            IoLib.argerror(1, "invalid value: '" + mode + "'; must be one of 'no', 'full' or 'line'");
        }
        IoLib.checkfile(file).setvbuf(mode, size);
        return LuaValue.TRUE;
    }

    public Varargs _file_lines(Varargs args) {
        return this.lines(IoLib.checkfile(args.arg1()), false, args.subargs(2));
    }

    public Varargs _file_read(LuaValue file, Varargs subargs) throws IOException {
        return this.ioread(IoLib.checkfile(file), subargs);
    }

    public Varargs _file_seek(LuaValue file, String whence, int offset) throws IOException {
        if (!("set".equals(whence) || "end".equals(whence) || "cur".equals(whence))) {
            IoLib.argerror(1, "invalid value: '" + whence + "'; must be one of 'set', 'cur' or 'end'");
        }
        return IoLib.valueOf(IoLib.checkfile(file).seek(whence, offset));
    }

    public Varargs _file_write(LuaValue file, Varargs subargs) throws IOException {
        return IoLib.iowrite(IoLib.checkfile(file), subargs);
    }

    public Varargs _io_index(LuaValue v) {
        return v.equals(STDOUT) ? this.output() : (v.equals(STDIN) ? this.input() : (v.equals(STDERR) ? this.errput() : NIL));
    }

    public Varargs _lines_iter(LuaValue file, boolean toclose, Varargs args) throws IOException {
        File f = IoLib.optfile(file);
        if (f == null) {
            IoLib.argerror(1, "not a file: " + file);
        }
        if (f.isclosed()) {
            IoLib.error("file is already closed");
        }
        Varargs ret2 = this.ioread(f, args);
        if (toclose && ret2.isnil(1) && f.eof()) {
            f.close();
        }
        return ret2;
    }

    private File output() {
        return this.outfile != null ? this.outfile : (this.outfile = this.ioopenfile(1, "-", "w"));
    }

    private File errput() {
        return this.errfile != null ? this.errfile : (this.errfile = this.ioopenfile(2, "-", "w"));
    }

    private File ioopenfile(int filetype, String filename, String mode) {
        try {
            return this.rawopenfile(filetype, filename, mode);
        }
        catch (Exception e) {
            IoLib.error("io error: " + e.getMessage());
            return null;
        }
    }

    private static Varargs ioclose(File f) throws IOException {
        if (f.isstdfile()) {
            return IoLib.errorresult("cannot close standard file");
        }
        f.close();
        return IoLib.successresult();
    }

    private static Varargs successresult() {
        return LuaValue.TRUE;
    }

    static Varargs errorresult(Exception ioe) {
        String s = ioe.getMessage();
        return IoLib.errorresult("io error: " + (s != null ? s : ioe.toString()));
    }

    private static Varargs errorresult(String errortext) {
        return IoLib.varargsOf(NIL, (Varargs)IoLib.valueOf(errortext));
    }

    private Varargs lines(File f, boolean toclose, Varargs args) {
        try {
            return new IoLibV(f, "lnext", 19, this, toclose, args);
        }
        catch (Exception e) {
            return IoLib.error("lines: " + e);
        }
    }

    private static Varargs iowrite(File f, Varargs args) throws IOException {
        int n = args.narg();
        for (int i = 1; i <= n; ++i) {
            f.write(args.checkstring(i));
        }
        return f;
    }

    private Varargs ioread(File f, Varargs args) throws IOException {
        int n = args.narg();
        if (n == 0) {
            return IoLib.freadline(f, false);
        }
        LuaValue[] v = new LuaValue[n];
        int i = 0;
        while (i < n) {
            LuaValue vi;
            LuaValue ai = args.arg(i + 1);
            block0 : switch (ai.type()) {
                case 3: {
                    vi = IoLib.freadbytes(f, ai.toint());
                    break;
                }
                case 4: {
                    LuaString fmt = ai.checkstring();
                    if (fmt.m_length >= 2 && fmt.m_bytes[fmt.m_offset] == 42) {
                        switch (fmt.m_bytes[fmt.m_offset + 1]) {
                            case 110: {
                                vi = IoLib.freadnumber(f);
                                break block0;
                            }
                            case 108: {
                                vi = IoLib.freadline(f, false);
                                break block0;
                            }
                            case 76: {
                                vi = IoLib.freadline(f, true);
                                break block0;
                            }
                            case 97: {
                                vi = IoLib.freadall(f);
                                break block0;
                            }
                        }
                    }
                }
                default: {
                    return IoLib.argerror(i + 1, "(invalid format)");
                }
            }
            if (!(v[i++] = vi).isnil()) continue;
        }
        return i == 0 ? NIL : IoLib.varargsOf(v, 0, i);
    }

    private static File checkfile(LuaValue val) {
        File f = IoLib.optfile(val);
        if (f == null) {
            IoLib.argerror(1, "file");
        }
        IoLib.checkopen(f);
        return f;
    }

    private static File optfile(LuaValue val) {
        return val instanceof File ? (File)val : null;
    }

    private static File checkopen(File file) {
        if (file.isclosed()) {
            IoLib.error("attempt to use a closed file");
        }
        return file;
    }

    private File rawopenfile(int filetype, String filename, String mode) throws IOException {
        int len2 = mode.length();
        for (int i = 0; i < len2; ++i) {
            char ch = mode.charAt(i);
            if (i == 0 && "rwa".indexOf(ch) >= 0 || i == 1 && ch == '+' || i >= 1 && ch == 'b') continue;
            len2 = -1;
            break;
        }
        if (len2 <= 0) {
            IoLib.argerror(2, "invalid mode: '" + mode + "'");
        }
        switch (filetype) {
            case 0: {
                return this.wrapStdin();
            }
            case 1: {
                return this.wrapStdout();
            }
            case 2: {
                return this.wrapStderr();
            }
        }
        boolean isreadmode = mode.startsWith("r");
        boolean isappend = mode.startsWith("a");
        boolean isupdate = mode.indexOf(43) > 0;
        boolean isbinary = mode.endsWith("b");
        return this.openFile(filename, isreadmode, isappend, isupdate, isbinary);
    }

    public static LuaValue freadbytes(File f, int count) throws IOException {
        if (count == 0) {
            return f.eof() ? NIL : EMPTYSTRING;
        }
        byte[] b = new byte[count];
        int r = f.read(b, 0, b.length);
        if (r < 0) {
            return NIL;
        }
        return LuaString.valueUsing(b, 0, r);
    }

    public static LuaValue freaduntil(File f, boolean lineonly, boolean withend) throws IOException {
        int c;
        ByteArrayOutputStream baos;
        block10: {
            baos = new ByteArrayOutputStream();
            try {
                if (lineonly) {
                    block6: while ((c = f.read()) >= 0) {
                        switch (c) {
                            case 13: {
                                if (!withend) continue block6;
                                baos.write(c);
                                break;
                            }
                            case 10: {
                                if (withend) {
                                    baos.write(c);
                                }
                                break block10;
                            }
                            default: {
                                baos.write(c);
                                break;
                            }
                        }
                    }
                    break block10;
                }
                while ((c = f.read()) >= 0) {
                    baos.write(c);
                }
            }
            catch (EOFException e) {
                c = -1;
            }
        }
        return c < 0 && baos.size() == 0 ? NIL : LuaString.valueUsing(baos.toByteArray());
    }

    public static LuaValue freadline(File f, boolean withend) throws IOException {
        return IoLib.freaduntil(f, true, withend);
    }

    public static LuaValue freadall(File f) throws IOException {
        int n = f.remaining();
        if (n >= 0) {
            return n == 0 ? EMPTYSTRING : IoLib.freadbytes(f, n);
        }
        return IoLib.freaduntil(f, false, false);
    }

    public static LuaValue freadnumber(File f) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoLib.freadchars(f, " \t\r\n", null);
        IoLib.freadchars(f, "-+", baos);
        IoLib.freadchars(f, "0123456789", baos);
        IoLib.freadchars(f, ".", baos);
        IoLib.freadchars(f, "0123456789", baos);
        String s = baos.toString();
        return s.length() > 0 ? IoLib.valueOf(Double.parseDouble(s)) : NIL;
    }

    private static void freadchars(File f, String chars, ByteArrayOutputStream baos) throws IOException {
        int c;
        while (chars.indexOf(c = f.peek()) >= 0) {
            f.read();
            if (baos == null) continue;
            baos.write(c);
        }
        return;
    }

    static final class IoLibV
    extends VarArgFunction {
        private File f;
        public IoLib iolib;
        private boolean toclose;
        private Varargs args;

        public IoLibV() {
        }

        public IoLibV(File f, String name, int opcode, IoLib iolib, boolean toclose, Varargs args) {
            this(f, name, opcode, iolib);
            this.toclose = toclose;
            this.args = args.dealias();
        }

        public IoLibV(File f, String name, int opcode, IoLib iolib) {
            this.f = f;
            this.name = name;
            this.opcode = opcode;
            this.iolib = iolib;
        }

        @Override
        public Varargs invoke(Varargs args) {
            try {
                switch (this.opcode) {
                    case 1: {
                        return this.iolib._io_flush();
                    }
                    case 8: {
                        return this.iolib._io_tmpfile();
                    }
                    case 0: {
                        return this.iolib._io_close(args.arg1());
                    }
                    case 2: {
                        return this.iolib._io_input(args.arg1());
                    }
                    case 5: {
                        return this.iolib._io_output(args.arg1());
                    }
                    case 9: {
                        return this.iolib._io_type(args.arg1());
                    }
                    case 6: {
                        return this.iolib._io_popen(args.checkjstring(1), args.optjstring(2, "r"));
                    }
                    case 4: {
                        return this.iolib._io_open(args.checkjstring(1), args.optjstring(2, "r"));
                    }
                    case 3: {
                        return this.iolib._io_lines(args);
                    }
                    case 7: {
                        return this.iolib._io_read(args);
                    }
                    case 10: {
                        return this.iolib._io_write(args);
                    }
                    case 11: {
                        return this.iolib._file_close(args.arg1());
                    }
                    case 12: {
                        return this.iolib._file_flush(args.arg1());
                    }
                    case 16: {
                        return this.iolib._file_setvbuf(args.arg1(), args.checkjstring(2), args.optint(3, 8192));
                    }
                    case 13: {
                        return this.iolib._file_lines(args);
                    }
                    case 14: {
                        return this.iolib._file_read(args.arg1(), args.subargs(2));
                    }
                    case 15: {
                        return this.iolib._file_seek(args.arg1(), args.optjstring(2, "cur"), args.optint(3, 0));
                    }
                    case 17: {
                        return this.iolib._file_write(args.arg1(), args.subargs(2));
                    }
                    case 18: {
                        return this.iolib._io_index(args.arg(2));
                    }
                    case 19: {
                        return this.iolib._lines_iter(this.f, this.toclose, this.args);
                    }
                }
            }
            catch (IOException ioe) {
                if (this.opcode == 19) {
                    String s = ioe.getMessage();
                    IoLibV.error(s != null ? s : ioe.toString());
                }
                return IoLib.errorresult(ioe);
            }
            return NONE;
        }
    }

    protected abstract class File
    extends LuaValue {
        protected File() {
        }

        public abstract void write(LuaString var1) throws IOException;

        public abstract void flush() throws IOException;

        public abstract boolean isstdfile();

        public abstract void close() throws IOException;

        public abstract boolean isclosed();

        public abstract int seek(String var1, int var2) throws IOException;

        public abstract void setvbuf(String var1, int var2);

        public abstract int remaining() throws IOException;

        public abstract int peek() throws IOException, EOFException;

        public abstract int read() throws IOException, EOFException;

        public abstract int read(byte[] var1, int var2, int var3) throws IOException;

        public boolean eof() throws IOException {
            try {
                return this.peek() < 0;
            }
            catch (EOFException e) {
                return true;
            }
        }

        @Override
        public LuaValue get(LuaValue key) {
            return IoLib.this.filemethods.get(key);
        }

        @Override
        public int type() {
            return 7;
        }

        @Override
        public String typename() {
            return "userdata";
        }

        @Override
        public String tojstring() {
            return "file: " + Integer.toHexString(this.hashCode());
        }

        public void finalize() {
            if (!this.isclosed()) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

