/*
 * Decompiled with CFR 0.152.
 */
package com.luaj.vm2.lib;

import com.luaj.vm2.LuaTable;
import com.luaj.vm2.LuaValue;
import com.luaj.vm2.Varargs;
import com.luaj.vm2.lib.TwoArgFunction;
import com.luaj.vm2.lib.VarArgFunction;

public class Bit32Lib
extends TwoArgFunction {
    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable t = new LuaTable();
        this.bind(t, Bit32LibV.class, new String[]{"band", "bnot", "bor", "btest", "bxor", "extract", "replace"});
        this.bind(t, Bit32Lib2.class, new String[]{"arshift", "lrotate", "lshift", "rrotate", "rshift"});
        env.set("bit32", (LuaValue)t);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set("bit32", (LuaValue)t);
        }
        return t;
    }

    static LuaValue arshift(int x, int disp) {
        if (disp >= 0) {
            return Bit32Lib.bitsToValue(x >> disp);
        }
        return Bit32Lib.bitsToValue(x << -disp);
    }

    static LuaValue rshift(int x, int disp) {
        if (disp >= 32 || disp <= -32) {
            return ZERO;
        }
        if (disp >= 0) {
            return Bit32Lib.bitsToValue(x >>> disp);
        }
        return Bit32Lib.bitsToValue(x << -disp);
    }

    static LuaValue lshift(int x, int disp) {
        if (disp >= 32 || disp <= -32) {
            return ZERO;
        }
        if (disp >= 0) {
            return Bit32Lib.bitsToValue(x << disp);
        }
        return Bit32Lib.bitsToValue(x >>> -disp);
    }

    static Varargs band(Varargs args) {
        int result = -1;
        for (int i = 1; i <= args.narg(); ++i) {
            result &= args.checkint(i);
        }
        return Bit32Lib.bitsToValue(result);
    }

    static Varargs bnot(Varargs args) {
        return Bit32Lib.bitsToValue(~args.checkint(1));
    }

    static Varargs bor(Varargs args) {
        int result = 0;
        for (int i = 1; i <= args.narg(); ++i) {
            result |= args.checkint(i);
        }
        return Bit32Lib.bitsToValue(result);
    }

    static Varargs btest(Varargs args) {
        int bits = -1;
        for (int i = 1; i <= args.narg(); ++i) {
            bits &= args.checkint(i);
        }
        return Bit32Lib.valueOf(bits != 0);
    }

    static Varargs bxor(Varargs args) {
        int result = 0;
        for (int i = 1; i <= args.narg(); ++i) {
            result ^= args.checkint(i);
        }
        return Bit32Lib.bitsToValue(result);
    }

    static LuaValue lrotate(int x, int disp) {
        if (disp < 0) {
            return Bit32Lib.rrotate(x, -disp);
        }
        return Bit32Lib.bitsToValue(x << (disp &= 0x1F) | x >>> 32 - disp);
    }

    static LuaValue rrotate(int x, int disp) {
        if (disp < 0) {
            return Bit32Lib.lrotate(x, -disp);
        }
        return Bit32Lib.bitsToValue(x >>> (disp &= 0x1F) | x << 32 - disp);
    }

    static LuaValue extract(int n, int field, int width) {
        if (field < 0) {
            Bit32Lib.argerror(2, "field cannot be negative");
        }
        if (width < 0) {
            Bit32Lib.argerror(3, "width must be postive");
        }
        if (field + width > 32) {
            Bit32Lib.error("trying to access non-existent bits");
        }
        return Bit32Lib.bitsToValue(n >>> field & -1 >>> 32 - width);
    }

    static LuaValue replace(int n, int v, int field, int width) {
        if (field < 0) {
            Bit32Lib.argerror(3, "field cannot be negative");
        }
        if (width < 0) {
            Bit32Lib.argerror(4, "width must be postive");
        }
        if (field + width > 32) {
            Bit32Lib.error("trying to access non-existent bits");
        }
        int mask = -1 >>> 32 - width << field;
        n = n & ~mask | v << field & mask;
        return Bit32Lib.bitsToValue(n);
    }

    private static LuaValue bitsToValue(int x) {
        return x < 0 ? Bit32Lib.valueOf((long)x & 0xFFFFFFFFL) : Bit32Lib.valueOf(x);
    }

    static final class Bit32Lib2
    extends TwoArgFunction {
        Bit32Lib2() {
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            switch (this.opcode) {
                case 0: {
                    return Bit32Lib.arshift(arg1.checkint(), arg2.checkint());
                }
                case 1: {
                    return Bit32Lib.lrotate(arg1.checkint(), arg2.checkint());
                }
                case 2: {
                    return Bit32Lib.lshift(arg1.checkint(), arg2.checkint());
                }
                case 3: {
                    return Bit32Lib.rrotate(arg1.checkint(), arg2.checkint());
                }
                case 4: {
                    return Bit32Lib.rshift(arg1.checkint(), arg2.checkint());
                }
            }
            return NIL;
        }
    }

    static final class Bit32LibV
    extends VarArgFunction {
        Bit32LibV() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            switch (this.opcode) {
                case 0: {
                    return Bit32Lib.band(args);
                }
                case 1: {
                    return Bit32Lib.bnot(args);
                }
                case 2: {
                    return Bit32Lib.bor(args);
                }
                case 3: {
                    return Bit32Lib.btest(args);
                }
                case 4: {
                    return Bit32Lib.bxor(args);
                }
                case 5: {
                    return Bit32Lib.extract(args.checkint(1), args.checkint(2), args.optint(3, 1));
                }
                case 6: {
                    return Bit32Lib.replace(args.checkint(1), args.checkint(2), args.checkint(3), args.optint(4, 1));
                }
            }
            return NIL;
        }
    }
}

