/*
 * Decompiled with CFR 0.152.
 */
package com.luaj.vm2.compiler;

import com.luaj.vm2.Globals;
import com.luaj.vm2.LuaClosure;
import com.luaj.vm2.LuaFunction;
import com.luaj.vm2.LuaString;
import com.luaj.vm2.LuaValue;
import com.luaj.vm2.Prototype;
import com.luaj.vm2.compiler.Constants;
import com.luaj.vm2.compiler.FuncState;
import com.luaj.vm2.compiler.LexState;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class LuaC
extends Constants
implements Globals.Compiler,
Globals.Loader {
    public static final LuaC instance = new LuaC();

    public static void install(Globals globals) {
        globals.compiler = instance;
        globals.loader = instance;
    }

    protected LuaC() {
    }

    @Override
    public Prototype compile(InputStream stream, String chunkname) throws IOException {
        return new CompileState().luaY_parser(stream, chunkname);
    }

    @Override
    public LuaFunction load(Prototype prototype, String chunkname, LuaValue env) throws IOException {
        return new LuaClosure(prototype, env);
    }

    public LuaValue load(InputStream stream, String chunkname, Globals globals) throws IOException {
        return new LuaClosure(this.compile(stream, chunkname), globals);
    }

    static class CompileState {
        int nCcalls = 0;
        private Hashtable strings = new Hashtable();

        protected CompileState() {
        }

        Prototype luaY_parser(InputStream z, String name) throws IOException {
            FuncState funcstate;
            LexState lexstate = new LexState(this, z);
            lexstate.fs = funcstate = new FuncState();
            lexstate.setinput(this, z.read(), z, LuaValue.valueOf(name));
            funcstate.f = new Prototype();
            funcstate.f.source = LuaValue.valueOf(name);
            lexstate.mainfunc(funcstate);
            LuaC._assert(funcstate.prev == null);
            LuaC._assert(lexstate.dyd == null || lexstate.dyd.n_actvar == 0 && lexstate.dyd.n_gt == 0 && lexstate.dyd.n_label == 0);
            return funcstate.f;
        }

        public LuaString newTString(String s) {
            return this.cachedLuaString(LuaString.valueOf(s));
        }

        public LuaString newTString(LuaString s) {
            return this.cachedLuaString(s);
        }

        public LuaString cachedLuaString(LuaString s) {
            LuaString c = (LuaString)this.strings.get(s);
            if (c != null) {
                return c;
            }
            this.strings.put(s, s);
            return s;
        }

        public String pushfstring(String string) {
            return string;
        }
    }
}

