/*
 * Decompiled with CFR 0.152.
 */
package com.luaj.vm2.ast;

import com.luaj.vm2.ast.Block;
import com.luaj.vm2.ast.Exp;
import com.luaj.vm2.ast.FuncBody;
import com.luaj.vm2.ast.FuncName;
import com.luaj.vm2.ast.Name;
import com.luaj.vm2.ast.NameScope;
import com.luaj.vm2.ast.SyntaxElement;
import com.luaj.vm2.ast.Visitor;
import java.util.List;

public abstract class Stat
extends SyntaxElement {
    public abstract void accept(Visitor var1);

    public static Stat block(Block block) {
        return block;
    }

    public static Stat whiledo(Exp exp2, Block block) {
        return new WhileDo(exp2, block);
    }

    public static Stat repeatuntil(Block block, Exp exp2) {
        return new RepeatUntil(block, exp2);
    }

    public static Stat breakstat() {
        return new Break();
    }

    public static Stat returnstat(List<Exp> exps) {
        return new Return(exps);
    }

    public static Stat assignment(List<Exp.VarExp> vars, List<Exp> exps) {
        return new Assign(vars, exps);
    }

    public static Stat functioncall(Exp.FuncCall funccall) {
        return new FuncCallStat(funccall);
    }

    public static Stat localfunctiondef(String name, FuncBody funcbody) {
        return new LocalFuncDef(name, funcbody);
    }

    public static Stat fornumeric(String name, Exp initial, Exp limit, Exp step, Block block) {
        return new NumericFor(name, initial, limit, step, block);
    }

    public static Stat functiondef(FuncName funcname, FuncBody funcbody) {
        return new FuncDef(funcname, funcbody);
    }

    public static Stat forgeneric(List<Name> names, List<Exp> exps, Block block) {
        return new GenericFor(names, exps, block);
    }

    public static Stat localassignment(List<Name> names, List<Exp> values) {
        return new LocalAssign(names, values);
    }

    public static Stat ifthenelse(Exp ifexp, Block ifblock, List<Exp> elseifexps, List<Block> elseifblocks, Block elseblock) {
        return new IfThenElse(ifexp, ifblock, elseifexps, elseifblocks, elseblock);
    }

    public static Stat gotostat(String name) {
        return new Goto(name);
    }

    public static Stat labelstat(String name) {
        return new Label(name);
    }

    public static class IfThenElse
    extends Stat {
        public final Exp ifexp;
        public final Block ifblock;
        public final List<Exp> elseifexps;
        public final List<Block> elseifblocks;
        public final Block elseblock;

        public IfThenElse(Exp ifexp, Block ifblock, List<Exp> elseifexps, List<Block> elseifblocks, Block elseblock) {
            this.ifexp = ifexp;
            this.ifblock = ifblock;
            this.elseifexps = elseifexps;
            this.elseifblocks = elseifblocks;
            this.elseblock = elseblock;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class LocalAssign
    extends Stat {
        public final List<Name> names;
        public final List<Exp> values;

        public LocalAssign(List<Name> names, List<Exp> values) {
            this.names = names;
            this.values = values;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class NumericFor
    extends Stat {
        public final Name name;
        public final Exp initial;
        public final Exp limit;
        public final Exp step;
        public final Block block;
        public NameScope scope;

        public NumericFor(String name, Exp initial, Exp limit, Exp step, Block block) {
            this.name = new Name(name);
            this.initial = initial;
            this.limit = limit;
            this.step = step;
            this.block = block;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class GenericFor
    extends Stat {
        public List<Name> names;
        public List<Exp> exps;
        public Block block;
        public NameScope scope;

        public GenericFor(List<Name> names, List<Exp> exps, Block block) {
            this.names = names;
            this.exps = exps;
            this.block = block;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class FuncDef
    extends Stat {
        public final FuncName name;
        public final FuncBody body;

        public FuncDef(FuncName name, FuncBody body) {
            this.name = name;
            this.body = body;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class LocalFuncDef
    extends Stat {
        public final Name name;
        public final FuncBody body;

        public LocalFuncDef(String name, FuncBody body) {
            this.name = new Name(name);
            this.body = body;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class FuncCallStat
    extends Stat {
        public final Exp.FuncCall funccall;

        public FuncCallStat(Exp.FuncCall funccall) {
            this.funccall = funccall;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class Return
    extends Stat {
        public final List<Exp> values;

        public Return(List<Exp> values) {
            this.values = values;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }

        public int nreturns() {
            int n;
            int n2 = n = this.values != null ? this.values.size() : 0;
            if (n > 0 && this.values.get(n - 1).isvarargexp()) {
                n = -1;
            }
            return n;
        }
    }

    public static class Break
    extends Stat {
        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class RepeatUntil
    extends Stat {
        public final Block block;
        public final Exp exp;

        public RepeatUntil(Block block, Exp exp2) {
            this.block = block;
            this.exp = exp2;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class WhileDo
    extends Stat {
        public final Exp exp;
        public final Block block;

        public WhileDo(Exp exp2, Block block) {
            this.exp = exp2;
            this.block = block;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class Assign
    extends Stat {
        public final List<Exp.VarExp> vars;
        public final List<Exp> exps;

        public Assign(List<Exp.VarExp> vars, List<Exp> exps) {
            this.vars = vars;
            this.exps = exps;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class Label
    extends Stat {
        public final String name;

        public Label(String name) {
            this.name = name;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }

    public static class Goto
    extends Stat {
        public final String name;

        public Goto(String name) {
            this.name = name;
        }

        @Override
        public void accept(Visitor visitor2) {
            visitor2.visit(this);
        }
    }
}

