/*
 * Decompiled with CFR 0.152.
 */
package com.luaj.vm2;

import com.luaj.vm2.Buffer;
import com.luaj.vm2.Globals;
import com.luaj.vm2.LuaBoolean;
import com.luaj.vm2.LuaClosure;
import com.luaj.vm2.LuaDouble;
import com.luaj.vm2.LuaError;
import com.luaj.vm2.LuaFunction;
import com.luaj.vm2.LuaInteger;
import com.luaj.vm2.LuaNil;
import com.luaj.vm2.LuaNumber;
import com.luaj.vm2.LuaString;
import com.luaj.vm2.LuaTable;
import com.luaj.vm2.LuaThread;
import com.luaj.vm2.LuaUserdata;
import com.luaj.vm2.Metatable;
import com.luaj.vm2.NonTableMetatable;
import com.luaj.vm2.TailcallVarargs;
import com.luaj.vm2.Varargs;
import com.luaj.vm2.WeakTable;

public abstract class LuaValue
extends Varargs {
    public static final int TINT = -2;
    public static final int TNONE = -1;
    public static final int TNIL = 0;
    public static final int TBOOLEAN = 1;
    public static final int TLIGHTUSERDATA = 2;
    public static final int TNUMBER = 3;
    public static final int TSTRING = 4;
    public static final int TTABLE = 5;
    public static final int TFUNCTION = 6;
    public static final int TUSERDATA = 7;
    public static final int TTHREAD = 8;
    public static final int TVALUE = 9;
    public static final String[] TYPE_NAMES = new String[]{"nil", "boolean", "lightuserdata", "number", "string", "table", "function", "userdata", "thread", "value"};
    public static final LuaValue NIL = LuaNil._NIL;
    public static final LuaBoolean TRUE = LuaBoolean._TRUE;
    public static final LuaBoolean FALSE = LuaBoolean._FALSE;
    public static final LuaValue NONE = None._NONE;
    public static final LuaNumber ZERO = LuaInteger.valueOf(0);
    public static final LuaNumber ONE = LuaInteger.valueOf(1);
    public static final LuaNumber MINUSONE = LuaInteger.valueOf(-1);
    public static final LuaValue[] NOVALS = new LuaValue[0];
    public static LuaString ENV = LuaValue.valueOf("_ENV");
    public static final LuaString INDEX = LuaValue.valueOf("__index");
    public static final LuaString NEWINDEX = LuaValue.valueOf("__newindex");
    public static final LuaString CALL = LuaValue.valueOf("__call");
    public static final LuaString MODE = LuaValue.valueOf("__mode");
    public static final LuaString METATABLE = LuaValue.valueOf("__metatable");
    public static final LuaString ADD = LuaValue.valueOf("__add");
    public static final LuaString SUB = LuaValue.valueOf("__sub");
    public static final LuaString DIV = LuaValue.valueOf("__div");
    public static final LuaString MUL = LuaValue.valueOf("__mul");
    public static final LuaString POW = LuaValue.valueOf("__pow");
    public static final LuaString MOD = LuaValue.valueOf("__mod");
    public static final LuaString UNM = LuaValue.valueOf("__unm");
    public static final LuaString LEN = LuaValue.valueOf("__len");
    public static final LuaString EQ = LuaValue.valueOf("__eq");
    public static final LuaString LT = LuaValue.valueOf("__lt");
    public static final LuaString LE = LuaValue.valueOf("__le");
    public static final LuaString TOSTRING = LuaValue.valueOf("__tostring");
    public static final LuaString CONCAT = LuaValue.valueOf("__concat");
    public static final LuaString EMPTYSTRING = LuaValue.valueOf("");
    private static int MAXSTACK = 250;
    public static final LuaValue[] NILS = new LuaValue[MAXSTACK];
    private static final int MAXTAGLOOP = 100;

    public abstract int type();

    public abstract String typename();

    public boolean isboolean() {
        return false;
    }

    public boolean isclosure() {
        return false;
    }

    public boolean isfunction() {
        return false;
    }

    public boolean isint() {
        return false;
    }

    public boolean isinttype() {
        return false;
    }

    public boolean islong() {
        return false;
    }

    public boolean isnil() {
        return false;
    }

    public boolean isnumber() {
        return false;
    }

    public boolean isstring() {
        return false;
    }

    public boolean isthread() {
        return false;
    }

    public boolean istable() {
        return false;
    }

    public boolean isuserdata() {
        return false;
    }

    public boolean isuserdata(Class c) {
        return false;
    }

    public boolean toboolean() {
        return true;
    }

    public byte tobyte() {
        return 0;
    }

    public char tochar() {
        return '\u0000';
    }

    public double todouble() {
        return 0.0;
    }

    public float tofloat() {
        return 0.0f;
    }

    public int toint() {
        return 0;
    }

    public long tolong() {
        return 0L;
    }

    public short toshort() {
        return 0;
    }

    @Override
    public String tojstring() {
        return this.typename() + ": " + Integer.toHexString(this.hashCode());
    }

    public Object touserdata() {
        return null;
    }

    public Object touserdata(Class c) {
        return null;
    }

    @Override
    public String toString() {
        return this.tojstring();
    }

    public LuaValue tonumber() {
        return NIL;
    }

    public LuaValue tostring() {
        return NIL;
    }

    public boolean optboolean(boolean defval) {
        this.argerror("boolean");
        return false;
    }

    public LuaClosure optclosure(LuaClosure defval) {
        this.argerror("closure");
        return null;
    }

    public double optdouble(double defval) {
        this.argerror("number");
        return 0.0;
    }

    public LuaFunction optfunction(LuaFunction defval) {
        this.argerror("function");
        return null;
    }

    public int optint(int defval) {
        this.argerror("int");
        return 0;
    }

    public LuaInteger optinteger(LuaInteger defval) {
        this.argerror("integer");
        return null;
    }

    public long optlong(long defval) {
        this.argerror("long");
        return 0L;
    }

    public LuaNumber optnumber(LuaNumber defval) {
        this.argerror("number");
        return null;
    }

    public String optjstring(String defval) {
        this.argerror("String");
        return null;
    }

    public LuaString optstring(LuaString defval) {
        this.argerror("string");
        return null;
    }

    public LuaTable opttable(LuaTable defval) {
        this.argerror("table");
        return null;
    }

    public LuaThread optthread(LuaThread defval) {
        this.argerror("thread");
        return null;
    }

    public Object optuserdata(Object defval) {
        this.argerror("object");
        return null;
    }

    public Object optuserdata(Class c, Object defval) {
        this.argerror(c.getName());
        return null;
    }

    public LuaValue optvalue(LuaValue defval) {
        return this;
    }

    public boolean checkboolean() {
        this.argerror("boolean");
        return false;
    }

    public LuaClosure checkclosure() {
        this.argerror("closure");
        return null;
    }

    public double checkdouble() {
        this.argerror("number");
        return 0.0;
    }

    public LuaFunction checkfunction() {
        this.argerror("function");
        return null;
    }

    public Globals checkglobals() {
        this.argerror("globals");
        return null;
    }

    public int checkint() {
        this.argerror("int");
        return 0;
    }

    public LuaInteger checkinteger() {
        this.argerror("integer");
        return null;
    }

    public long checklong() {
        this.argerror("long");
        return 0L;
    }

    public LuaNumber checknumber() {
        this.argerror("number");
        return null;
    }

    public LuaNumber checknumber(String msg) {
        throw new LuaError(msg);
    }

    public String checkjstring() {
        this.argerror("string");
        return null;
    }

    public LuaString checkstring() {
        this.argerror("string");
        return null;
    }

    public LuaTable checktable() {
        this.argerror("table");
        return null;
    }

    public LuaThread checkthread() {
        this.argerror("thread");
        return null;
    }

    public Object checkuserdata() {
        this.argerror("userdata");
        return null;
    }

    public Object checkuserdata(Class c) {
        this.argerror("userdata");
        return null;
    }

    public LuaValue checknotnil() {
        return this;
    }

    public boolean isvalidkey() {
        return true;
    }

    public static LuaValue error(String message2) {
        throw new LuaError(message2);
    }

    public static void assert_(boolean b, String msg) {
        if (!b) {
            throw new LuaError(msg);
        }
    }

    protected LuaValue argerror(String expected) {
        throw new LuaError("bad argument: " + expected + " expected, got " + this.typename());
    }

    public static LuaValue argerror(int iarg, String msg) {
        throw new LuaError("bad argument #" + iarg + ": " + msg);
    }

    protected LuaValue typerror(String expected) {
        throw new LuaError(expected + " expected, got " + this.typename());
    }

    protected LuaValue unimplemented(String fun) {
        throw new LuaError("'" + fun + "' not implemented for " + this.typename());
    }

    protected LuaValue illegal(String op, String typename) {
        throw new LuaError("illegal operation '" + op + "' for " + typename);
    }

    protected LuaValue lenerror() {
        throw new LuaError("attempt to get length of " + this.typename());
    }

    protected LuaValue aritherror() {
        throw new LuaError("attempt to perform arithmetic on " + this.typename());
    }

    protected LuaValue aritherror(String fun) {
        throw new LuaError("attempt to perform arithmetic '" + fun + "' on " + this.typename());
    }

    protected LuaValue compareerror(String rhs) {
        throw new LuaError("attempt to compare " + this.typename() + " with " + rhs);
    }

    protected LuaValue compareerror(LuaValue rhs) {
        throw new LuaError("attempt to compare " + this.typename() + " with " + rhs.typename());
    }

    public LuaValue get(LuaValue key) {
        return LuaValue.gettable(this, key);
    }

    public LuaValue get(int key) {
        return this.get(LuaInteger.valueOf(key));
    }

    public LuaValue get(String key) {
        return this.get(LuaValue.valueOf(key));
    }

    public void set(LuaValue key, LuaValue value) {
        LuaValue.settable(this, key, value);
    }

    public void set(int key, LuaValue value) {
        this.set(LuaInteger.valueOf(key), value);
    }

    public void set(int key, String value) {
        this.set(key, (LuaValue)LuaValue.valueOf(value));
    }

    public void set(String key, LuaValue value) {
        this.set(LuaValue.valueOf(key), value);
    }

    public void set(String key, double value) {
        this.set(LuaValue.valueOf(key), (LuaValue)LuaValue.valueOf(value));
    }

    public void set(String key, int value) {
        this.set(LuaValue.valueOf(key), (LuaValue)LuaValue.valueOf(value));
    }

    public void set(String key, String value) {
        this.set(LuaValue.valueOf(key), (LuaValue)LuaValue.valueOf(value));
    }

    public LuaValue rawget(LuaValue key) {
        return this.unimplemented("rawget");
    }

    public LuaValue rawget(int key) {
        return this.rawget(LuaValue.valueOf(key));
    }

    public LuaValue rawget(String key) {
        return this.rawget(LuaValue.valueOf(key));
    }

    public void rawset(LuaValue key, LuaValue value) {
        this.unimplemented("rawset");
    }

    public void rawset(int key, LuaValue value) {
        this.rawset(LuaValue.valueOf(key), value);
    }

    public void rawset(int key, String value) {
        this.rawset(key, (LuaValue)LuaValue.valueOf(value));
    }

    public void rawset(String key, LuaValue value) {
        this.rawset(LuaValue.valueOf(key), value);
    }

    public void rawset(String key, double value) {
        this.rawset(LuaValue.valueOf(key), (LuaValue)LuaValue.valueOf(value));
    }

    public void rawset(String key, int value) {
        this.rawset(LuaValue.valueOf(key), (LuaValue)LuaValue.valueOf(value));
    }

    public void rawset(String key, String value) {
        this.rawset(LuaValue.valueOf(key), (LuaValue)LuaValue.valueOf(value));
    }

    public void rawsetlist(int key0, Varargs values) {
        int n = values.narg();
        for (int i = 0; i < n; ++i) {
            this.rawset(key0 + i, values.arg(i + 1));
        }
    }

    public void presize(int i) {
        this.typerror("table");
    }

    public Varargs next(LuaValue index) {
        return this.typerror("table");
    }

    public Varargs inext(LuaValue index) {
        return this.typerror("table");
    }

    public LuaValue load(LuaValue library) {
        return library.call(EMPTYSTRING, this);
    }

    @Override
    public LuaValue arg(int index) {
        return index == 1 ? this : NIL;
    }

    @Override
    public int narg() {
        return 1;
    }

    @Override
    public LuaValue arg1() {
        return this;
    }

    public LuaValue getmetatable() {
        return null;
    }

    public LuaValue setmetatable(LuaValue metatable) {
        return this.argerror("table");
    }

    public LuaValue call() {
        return this.callmt().call(this);
    }

    public LuaValue call(LuaValue arg) {
        return this.callmt().call(this, arg);
    }

    public LuaValue call(String arg) {
        return this.call(LuaValue.valueOf(arg));
    }

    public LuaValue call(LuaValue arg1, LuaValue arg2) {
        return this.callmt().call(this, arg1, arg2);
    }

    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
        return this.callmt().invoke(new LuaValue[]{this, arg1, arg2, arg3}).arg1();
    }

    public LuaValue method(String name) {
        return this.get(name).call(this);
    }

    public LuaValue method(LuaValue name) {
        return this.get(name).call(this);
    }

    public LuaValue method(String name, LuaValue arg) {
        return this.get(name).call(this, arg);
    }

    public LuaValue method(LuaValue name, LuaValue arg) {
        return this.get(name).call(this, arg);
    }

    public LuaValue method(String name, LuaValue arg1, LuaValue arg2) {
        return this.get(name).call(this, arg1, arg2);
    }

    public LuaValue method(LuaValue name, LuaValue arg1, LuaValue arg2) {
        return this.get(name).call(this, arg1, arg2);
    }

    public Varargs invoke() {
        return this.invoke(NONE);
    }

    public Varargs invoke(Varargs args) {
        return this.callmt().invoke(this, args);
    }

    public Varargs invoke(LuaValue arg, Varargs varargs) {
        return this.invoke(LuaValue.varargsOf(arg, varargs));
    }

    public Varargs invoke(LuaValue arg1, LuaValue arg2, Varargs varargs) {
        return this.invoke(LuaValue.varargsOf(arg1, arg2, varargs));
    }

    public Varargs invoke(LuaValue[] args) {
        return this.invoke(LuaValue.varargsOf(args));
    }

    public Varargs invoke(LuaValue[] args, Varargs varargs) {
        return this.invoke(LuaValue.varargsOf(args, varargs));
    }

    public Varargs invokemethod(String name) {
        return this.get(name).invoke(this);
    }

    public Varargs invokemethod(LuaValue name) {
        return this.get(name).invoke(this);
    }

    public Varargs invokemethod(String name, Varargs args) {
        return this.get(name).invoke(LuaValue.varargsOf(this, args));
    }

    public Varargs invokemethod(LuaValue name, Varargs args) {
        return this.get(name).invoke(LuaValue.varargsOf(this, args));
    }

    public Varargs invokemethod(String name, LuaValue[] args) {
        return this.get(name).invoke(LuaValue.varargsOf(this, LuaValue.varargsOf(args)));
    }

    public Varargs invokemethod(LuaValue name, LuaValue[] args) {
        return this.get(name).invoke(LuaValue.varargsOf(this, LuaValue.varargsOf(args)));
    }

    protected LuaValue callmt() {
        return this.checkmetatag(CALL, "attempt to call ");
    }

    public LuaValue not() {
        return FALSE;
    }

    public LuaValue neg() {
        return this.checkmetatag(UNM, "attempt to perform arithmetic on ").call(this);
    }

    public LuaValue len() {
        return this.checkmetatag(LEN, "attempt to get length of ").call(this);
    }

    public int length() {
        return this.len().toint();
    }

    public int rawlen() {
        this.typerror("table or string");
        return 0;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public LuaValue eq(LuaValue val) {
        return this.eq_b(val) ? TRUE : FALSE;
    }

    public boolean eq_b(LuaValue val) {
        return this == val;
    }

    public LuaValue neq(LuaValue val) {
        return this.eq_b(val) ? FALSE : TRUE;
    }

    public boolean neq_b(LuaValue val) {
        return !this.eq_b(val);
    }

    public boolean raweq(LuaValue val) {
        return this == val;
    }

    public boolean raweq(LuaUserdata val) {
        return false;
    }

    public boolean raweq(LuaString val) {
        return false;
    }

    public boolean raweq(double val) {
        return false;
    }

    public boolean raweq(int val) {
        return false;
    }

    public static final boolean eqmtcall(LuaValue lhs, LuaValue lhsmt, LuaValue rhs, LuaValue rhsmt) {
        LuaValue h = lhsmt.rawget(EQ);
        return h.isnil() || h != rhsmt.rawget(EQ) ? false : h.call(lhs, rhs).toboolean();
    }

    public LuaValue add(LuaValue rhs) {
        return this.arithmt(ADD, rhs);
    }

    public LuaValue add(double rhs) {
        return this.arithmtwith(ADD, rhs);
    }

    public LuaValue add(int rhs) {
        return this.add((double)rhs);
    }

    public LuaValue sub(LuaValue rhs) {
        return this.arithmt(SUB, rhs);
    }

    public LuaValue sub(double rhs) {
        return this.aritherror("sub");
    }

    public LuaValue sub(int rhs) {
        return this.aritherror("sub");
    }

    public LuaValue subFrom(double lhs) {
        return this.arithmtwith(SUB, lhs);
    }

    public LuaValue subFrom(int lhs) {
        return this.subFrom((double)lhs);
    }

    public LuaValue mul(LuaValue rhs) {
        return this.arithmt(MUL, rhs);
    }

    public LuaValue mul(double rhs) {
        return this.arithmtwith(MUL, rhs);
    }

    public LuaValue mul(int rhs) {
        return this.mul((double)rhs);
    }

    public LuaValue pow(LuaValue rhs) {
        return this.arithmt(POW, rhs);
    }

    public LuaValue pow(double rhs) {
        return this.aritherror("pow");
    }

    public LuaValue pow(int rhs) {
        return this.aritherror("pow");
    }

    public LuaValue powWith(double lhs) {
        return this.arithmtwith(POW, lhs);
    }

    public LuaValue powWith(int lhs) {
        return this.powWith((double)lhs);
    }

    public LuaValue div(LuaValue rhs) {
        return this.arithmt(DIV, rhs);
    }

    public LuaValue div(double rhs) {
        return this.aritherror("div");
    }

    public LuaValue div(int rhs) {
        return this.aritherror("div");
    }

    public LuaValue divInto(double lhs) {
        return this.arithmtwith(DIV, lhs);
    }

    public LuaValue mod(LuaValue rhs) {
        return this.arithmt(MOD, rhs);
    }

    public LuaValue mod(double rhs) {
        return this.aritherror("mod");
    }

    public LuaValue mod(int rhs) {
        return this.aritherror("mod");
    }

    public LuaValue modFrom(double lhs) {
        return this.arithmtwith(MOD, lhs);
    }

    protected LuaValue arithmt(LuaValue tag, LuaValue op2) {
        LuaValue h = this.metatag(tag);
        if (h.isnil() && (h = op2.metatag(tag)).isnil()) {
            LuaValue.error("attempt to perform arithmetic " + tag + " on " + this.typename() + " and " + op2.typename());
        }
        return h.call(this, op2);
    }

    protected LuaValue arithmtwith(LuaValue tag, double op1) {
        LuaValue h = this.metatag(tag);
        if (h.isnil()) {
            LuaValue.error("attempt to perform arithmetic " + tag + " on number and " + this.typename());
        }
        return h.call(LuaValue.valueOf(op1), this);
    }

    public LuaValue lt(LuaValue rhs) {
        return this.comparemt(LT, rhs);
    }

    public LuaValue lt(double rhs) {
        return this.compareerror("number");
    }

    public LuaValue lt(int rhs) {
        return this.compareerror("number");
    }

    public boolean lt_b(LuaValue rhs) {
        return this.comparemt(LT, rhs).toboolean();
    }

    public boolean lt_b(int rhs) {
        this.compareerror("number");
        return false;
    }

    public boolean lt_b(double rhs) {
        this.compareerror("number");
        return false;
    }

    public LuaValue lteq(LuaValue rhs) {
        return this.comparemt(LE, rhs);
    }

    public LuaValue lteq(double rhs) {
        return this.compareerror("number");
    }

    public LuaValue lteq(int rhs) {
        return this.compareerror("number");
    }

    public boolean lteq_b(LuaValue rhs) {
        return this.comparemt(LE, rhs).toboolean();
    }

    public boolean lteq_b(int rhs) {
        this.compareerror("number");
        return false;
    }

    public boolean lteq_b(double rhs) {
        this.compareerror("number");
        return false;
    }

    public LuaValue gt(LuaValue rhs) {
        return rhs.comparemt(LE, this);
    }

    public LuaValue gt(double rhs) {
        return this.compareerror("number");
    }

    public LuaValue gt(int rhs) {
        return this.compareerror("number");
    }

    public boolean gt_b(LuaValue rhs) {
        return rhs.comparemt(LE, this).toboolean();
    }

    public boolean gt_b(int rhs) {
        this.compareerror("number");
        return false;
    }

    public boolean gt_b(double rhs) {
        this.compareerror("number");
        return false;
    }

    public LuaValue gteq(LuaValue rhs) {
        return rhs.comparemt(LT, this);
    }

    public LuaValue gteq(double rhs) {
        return this.compareerror("number");
    }

    public LuaValue gteq(int rhs) {
        return LuaValue.valueOf(this.todouble() >= (double)rhs);
    }

    public boolean gteq_b(LuaValue rhs) {
        return rhs.comparemt(LT, this).toboolean();
    }

    public boolean gteq_b(int rhs) {
        this.compareerror("number");
        return false;
    }

    public boolean gteq_b(double rhs) {
        this.compareerror("number");
        return false;
    }

    public LuaValue comparemt(LuaValue tag, LuaValue op1) {
        LuaValue h = this.metatag(tag);
        if (!h.isnil() || !(h = op1.metatag(tag)).isnil()) {
            return h.call(this, op1);
        }
        if (!(!LE.raweq(tag) || (h = this.metatag(LT)).isnil() && (h = op1.metatag(LT)).isnil())) {
            return h.call(op1, this).not();
        }
        return LuaValue.error("attempt to compare " + tag + " on " + this.typename() + " and " + op1.typename());
    }

    public int strcmp(LuaValue rhs) {
        LuaValue.error("attempt to compare " + this.typename());
        return 0;
    }

    public int strcmp(LuaString rhs) {
        LuaValue.error("attempt to compare " + this.typename());
        return 0;
    }

    public LuaValue concat(LuaValue rhs) {
        return this.concatmt(rhs);
    }

    public LuaValue concatTo(LuaValue lhs) {
        return lhs.concatmt(this);
    }

    public LuaValue concatTo(LuaNumber lhs) {
        return lhs.concatmt(this);
    }

    public LuaValue concatTo(LuaString lhs) {
        return lhs.concatmt(this);
    }

    public Buffer buffer() {
        return new Buffer(this);
    }

    public Buffer concat(Buffer rhs) {
        return rhs.concatTo(this);
    }

    public LuaValue concatmt(LuaValue rhs) {
        LuaValue h = this.metatag(CONCAT);
        if (h.isnil() && (h = rhs.metatag(CONCAT)).isnil()) {
            LuaValue.error("attempt to concatenate " + this.typename() + " and " + rhs.typename());
        }
        return h.call(this, rhs);
    }

    public LuaValue and(LuaValue rhs) {
        return this.toboolean() ? rhs : this;
    }

    public LuaValue or(LuaValue rhs) {
        return this.toboolean() ? this : rhs;
    }

    public boolean testfor_b(LuaValue limit, LuaValue step) {
        return step.gt_b(0) ? this.lteq_b(limit) : this.gteq_b(limit);
    }

    public LuaString strvalue() {
        this.typerror("string or number");
        return null;
    }

    public LuaValue strongvalue() {
        return this;
    }

    public static LuaBoolean valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static LuaInteger valueOf(int i) {
        return LuaInteger.valueOf(i);
    }

    public static LuaNumber valueOf(double d) {
        return LuaDouble.valueOf(d);
    }

    public static LuaString valueOf(String s) {
        return LuaString.valueOf(s);
    }

    public static LuaString valueOf(byte[] bytes) {
        return LuaString.valueOf(bytes);
    }

    public static LuaString valueOf(byte[] bytes, int off, int len2) {
        return LuaString.valueOf(bytes, off, len2);
    }

    public static LuaTable tableOf() {
        return new LuaTable();
    }

    public static LuaTable tableOf(Varargs varargs, int firstarg) {
        return new LuaTable(varargs, firstarg);
    }

    public static LuaTable tableOf(int narray, int nhash) {
        return new LuaTable(narray, nhash);
    }

    public static LuaTable listOf(LuaValue[] unnamedValues) {
        return new LuaTable(null, unnamedValues, null);
    }

    public static LuaTable listOf(LuaValue[] unnamedValues, Varargs lastarg) {
        return new LuaTable(null, unnamedValues, lastarg);
    }

    public static LuaTable tableOf(LuaValue[] namedValues) {
        return new LuaTable(namedValues, null, null);
    }

    public static LuaTable tableOf(LuaValue[] namedValues, LuaValue[] unnamedValues) {
        return new LuaTable(namedValues, unnamedValues, null);
    }

    public static LuaTable tableOf(LuaValue[] namedValues, LuaValue[] unnamedValues, Varargs lastarg) {
        return new LuaTable(namedValues, unnamedValues, lastarg);
    }

    public static LuaUserdata userdataOf(Object o) {
        return new LuaUserdata(o);
    }

    public static LuaUserdata userdataOf(Object o, LuaValue metatable) {
        return new LuaUserdata(o, metatable);
    }

    protected static LuaValue gettable(LuaValue t, LuaValue key) {
        int loop = 0;
        do {
            LuaValue tm;
            if (t.istable()) {
                LuaValue res = t.rawget(key);
                if (!res.isnil() || (tm = t.metatag(INDEX)).isnil()) {
                    return res;
                }
            } else {
                tm = t.metatag(INDEX);
                if (tm.isnil()) {
                    t.indexerror(key.tojstring());
                }
            }
            if (tm.isfunction()) {
                return tm.call(t, key);
            }
            t = tm;
        } while (++loop < 100);
        LuaValue.error("loop in gettable");
        return NIL;
    }

    protected static boolean settable(LuaValue t, LuaValue key, LuaValue value) {
        int loop = 0;
        do {
            LuaValue tm;
            if (t.istable()) {
                if (!t.rawget(key).isnil() || (tm = t.metatag(NEWINDEX)).isnil()) {
                    t.rawset(key, value);
                    return true;
                }
            } else {
                tm = t.metatag(NEWINDEX);
                if (tm.isnil()) {
                    throw new LuaError("table expected for set index ('" + key + "') value, got " + t.typename());
                }
            }
            if (tm.isfunction()) {
                tm.call(t, key, value);
                return true;
            }
            t = tm;
        } while (++loop < 100);
        LuaValue.error("loop in settable");
        return false;
    }

    public LuaValue metatag(LuaValue tag) {
        LuaValue mt = this.getmetatable();
        if (mt == null) {
            return NIL;
        }
        return mt.rawget(tag);
    }

    protected LuaValue checkmetatag(LuaValue tag, String reason) {
        LuaValue h = this.metatag(tag);
        if (h.isnil()) {
            throw new LuaError(reason + "a " + this.typename() + " value");
        }
        return h;
    }

    protected static Metatable metatableOf(LuaValue mt) {
        if (mt != null && mt.istable()) {
            LuaValue mode = mt.rawget(MODE);
            if (mode.isstring()) {
                boolean weakvalues;
                String m = mode.tojstring();
                boolean weakkeys = m.indexOf(107) >= 0;
                boolean bl = weakvalues = m.indexOf(118) >= 0;
                if (weakkeys || weakvalues) {
                    return new WeakTable(weakkeys, weakvalues, mt);
                }
            }
            return (LuaTable)mt;
        }
        if (mt != null) {
            return new NonTableMetatable(mt);
        }
        return null;
    }

    private void indexerror(String key) {
        LuaValue.error("attempt to index ? (a " + this.typename() + " value) with key '" + key + "'");
    }

    public static Varargs varargsOf(LuaValue[] v) {
        switch (v.length) {
            case 0: {
                return NONE;
            }
            case 1: {
                return v[0];
            }
            case 2: {
                return new Varargs.PairVarargs(v[0], v[1]);
            }
        }
        return new Varargs.ArrayVarargs(v, NONE);
    }

    public static Varargs varargsOf(LuaValue[] v, Varargs r) {
        switch (v.length) {
            case 0: {
                return r;
            }
            case 1: {
                return r.narg() > 0 ? new Varargs.PairVarargs(v[0], r) : v[0];
            }
            case 2: {
                return r.narg() > 0 ? new Varargs.ArrayVarargs(v, r) : new Varargs.PairVarargs(v[0], v[1]);
            }
        }
        return new Varargs.ArrayVarargs(v, r);
    }

    public static Varargs varargsOf(LuaValue[] v, int offset, int length) {
        switch (length) {
            case 0: {
                return NONE;
            }
            case 1: {
                return v[offset];
            }
            case 2: {
                return new Varargs.PairVarargs(v[offset + 0], v[offset + 1]);
            }
        }
        return new Varargs.ArrayPartVarargs(v, offset, length, NONE);
    }

    public static Varargs varargsOf(LuaValue[] v, int offset, int length, Varargs more) {
        switch (length) {
            case 0: {
                return more;
            }
            case 1: {
                return more.narg() > 0 ? new Varargs.PairVarargs(v[offset], more) : v[offset];
            }
            case 2: {
                return more.narg() > 0 ? new Varargs.ArrayPartVarargs(v, offset, length, more) : new Varargs.PairVarargs(v[offset], v[offset + 1]);
            }
        }
        return new Varargs.ArrayPartVarargs(v, offset, length, more);
    }

    public static Varargs varargsOf(LuaValue v, Varargs r) {
        switch (r.narg()) {
            case 0: {
                return v;
            }
        }
        return new Varargs.PairVarargs(v, r);
    }

    public static Varargs varargsOf(LuaValue v1, LuaValue v2, Varargs v3) {
        switch (v3.narg()) {
            case 0: {
                return new Varargs.PairVarargs(v1, v2);
            }
        }
        return new Varargs.ArrayPartVarargs(new LuaValue[]{v1, v2}, 0, 2, v3);
    }

    public static Varargs tailcallOf(LuaValue func, Varargs args) {
        return new TailcallVarargs(func, args);
    }

    public Varargs onInvoke(Varargs args) {
        return this.invoke(args);
    }

    public void initupvalue1(LuaValue env) {
    }

    @Override
    public Varargs subargs(int start) {
        if (start == 1) {
            return this;
        }
        if (start > 1) {
            return NONE;
        }
        return LuaValue.argerror(1, "start must be > 0");
    }

    static {
        for (int i = 0; i < MAXSTACK; ++i) {
            LuaValue.NILS[i] = NIL;
        }
    }

    private static final class None
    extends LuaNil {
        static None _NONE = new None();

        private None() {
        }

        @Override
        public LuaValue arg(int i) {
            return NIL;
        }

        @Override
        public int narg() {
            return 0;
        }

        @Override
        public LuaValue arg1() {
            return NIL;
        }

        @Override
        public String tojstring() {
            return "none";
        }

        @Override
        public Varargs subargs(int start) {
            return start > 0 ? this : None.argerror(1, "start must be > 0");
        }

        @Override
        void copyto(LuaValue[] dest, int offset, int length) {
            while (length > 0) {
                dest[offset++] = NIL;
                --length;
            }
        }
    }
}

