/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.ui.values;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.luaj.vm2.utils.PathResourceFinder;

public class LuaContentsResourceFinder
extends PathResourceFinder {
    private Project project = null;
    private String basePath = null;

    public LuaContentsResourceFinder(String basePath) {
        super(basePath);
        this.basePath = basePath;
        for (Project value : ProjectManager.getInstance().getOpenProjects()) {
            if (!(value.getBasePath() + "/src").equals(basePath)) continue;
            this.project = value;
            break;
        }
    }

    @Override
    public String findPath(String name) {
        if (this.project != null) {
            return null;
        }
        return super.findPath(name);
    }

    @Override
    public byte[] getContent(String name) {
        if (this.project == null) {
            return null;
        }
        try {
            String filePath = this.basePath + "/" + name;
            VirtualFile virtualFile = this.project.getWorkspaceFile().getFileSystem().findFileByPath(filePath);
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                return document.getText().getBytes();
            }
            return VfsUtilCore.loadBytes((VirtualFile)virtualFile);
        }
        catch (Exception exception) {
            return super.getContent(name);
        }
    }
}

