/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.ui.values;

import com.immomo.core.parser.config.Constants;
import com.immomo.emmylua.lua.lang.LuaFileType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;

public class LLuaVirtualFileUtil {
    public static String LAYOUTNAME = "layout_";

    public static VirtualFile getVirtualFileWithUrl(String basePath, String fileName) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!(project.getBasePath() + "/src").equals(basePath)) continue;
            return project.getWorkspaceFile().getFileSystem().findFileByPath(basePath + "/" + fileName);
        }
        return null;
    }

    public static String getFileDocumentText(String basePath, String fileName) {
        VirtualFile virtualFile = LLuaVirtualFileUtil.getVirtualFileWithUrl(basePath, fileName);
        if (virtualFile != null) {
            Document desDocument = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (desDocument != null) {
                return desDocument.getText();
            }
            try {
                return VfsUtilCore.loadText((VirtualFile)virtualFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static VirtualFile getLLuaUIFilePath(String lluafilePath) {
        Project project = null;
        VirtualFile virtualFile = null;
        for (Project value : ProjectManager.getInstance().getOpenProjects()) {
            virtualFile = value.getWorkspaceFile().getFileSystem().findFileByPath(lluafilePath);
            if (virtualFile == null) continue;
            project = value;
            break;
        }
        if (project == null) {
            return null;
        }
        String desPath = LLuaVirtualFileUtil.getLuaLayoutPath(virtualFile.getParent().getPath(), virtualFile.getNameWithoutExtension());
        VirtualFile desVirtualFile = virtualFile.getFileSystem().findFileByPath(desPath);
        if (desVirtualFile == null) {
            return null;
        }
        String previewPath = LLuaVirtualFileUtil.getLuaPreviewPath(project, virtualFile.getParent().getPath(), virtualFile.getNameWithoutExtension());
        VirtualFile previewFile = virtualFile.getFileSystem().findFileByPath(previewPath);
        if (previewFile != null) {
            return previewFile;
        }
        return virtualFile.getFileSystem().findFileByPath(desPath);
    }

    public static VirtualFile getLuaPreviewFilePath(String luaFilePath) {
        Project project = null;
        VirtualFile virtualFile = null;
        for (Project value : ProjectManager.getInstance().getOpenProjects()) {
            virtualFile = value.getWorkspaceFile().getFileSystem().findFileByPath(luaFilePath);
            if (virtualFile == null) continue;
            project = value;
            break;
        }
        if (project == null) {
            return null;
        }
        String previewPath = LLuaVirtualFileUtil.getLuaPreviewPath(project, virtualFile.getParent().getPath(), virtualFile.getNameWithoutExtension());
        VirtualFile desVirtualFile = virtualFile.getFileSystem().findFileByPath(previewPath);
        if (desVirtualFile != null) {
            return desVirtualFile;
        }
        return null;
    }

    public static void deleteFile(Project project, String filePath) {
        final VirtualFile virtualFile = project.getWorkspaceFile().getFileSystem().findFileByPath(filePath);
        if (virtualFile == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    virtualFile.delete(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static String getLuaFilePathFromLLua(VirtualFile virtualFile, boolean isUI) {
        return virtualFile.getParent().getPath() + "/" + LLuaVirtualFileUtil.getLuaNameFromLLua(virtualFile, isUI) + ".lua";
    }

    public static String getLuaNameFromLLua(VirtualFile virtualFile, boolean isUI) {
        return (isUI ? LAYOUTNAME : "") + virtualFile.getNameWithoutExtension();
    }

    public static void writeTextToFile(Project project, VirtualFile file, final String text) {
        final Document desDocument = FileDocumentManager.getInstance().getDocument(file);
        if (desDocument != null) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (desDocument.isWritable()) {
                        desDocument.setText((CharSequence)text);
                    }
                }
            });
        } else {
            try {
                VfsUtil.saveText((VirtualFile)file, (String)text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getLuaPreviewPath(Project project, String lluaParentPath, String fileName) {
        if (fileName.startsWith(LAYOUTNAME)) {
            return project.getBasePath() + "/src/" + Constants.DOTPREVIEW + "/" + Constants.PREVIEW + "_" + fileName + ".lua";
        }
        return project.getBasePath() + "/src/" + Constants.DOTPREVIEW + "/" + Constants.PREVIEW + "_" + LAYOUTNAME + fileName + ".lua";
    }

    public static String getLuaLayoutPath(String lluaParentPath, String fileName) {
        return lluaParentPath + "/" + LAYOUTNAME + fileName + ".lua";
    }

    public static String getLuaNormalPath(String lluaParentPath, String fileName) {
        return lluaParentPath + "/" + fileName + ".lua";
    }

    public static boolean canShowPreviewEditor(VirtualFile lluafile) {
        try {
            boolean ret2 = false;
            if (lluafile.getExtension().equals(LuaFileType.INSTANCE.getName())) {
                VirtualFile file = LLuaVirtualFileUtil.getLLuaUIFilePath(lluafile.getPath());
                if (file != null) {
                    ret2 = true;
                }
            } else if (lluafile.getNameWithoutExtension().startsWith(Constants.PREVIEW)) {
                ret2 = true;
            }
            return ret2;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

