/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.ui.values;

import com.immomo.ui.values.LLuaElementTypeUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;

public class LLuaPSIUtil {
    public static int isLuaTableKey(PsiElement psiElement) {
        if (psiElement.getNode().getElementType().toString().equals(LLuaElementTypeUtil.ID) && psiElement.getParent() != null) {
            PsiElement parent = psiElement.getParent();
            if (!parent.getNode().getElementType().toString().equals(LLuaElementTypeUtil.TABLE_FIELD)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                if (parent.getFirstChild() == psiElement || parent.getFirstChild() == psiElement.getParent()) {
                    String type2;
                    PsiElement prev = parent.getPrevSibling();
                    if (prev instanceof PsiWhiteSpace) {
                        prev = parent.getPrevSibling().getPrevSibling();
                    }
                    if (prev != null && ((type2 = prev.getNode().getElementType().toString()).equals(LLuaElementTypeUtil.LCURLY) || type2.equals(LLuaElementTypeUtil.TABLE_FIELD_SEP))) {
                        return 1;
                    }
                } else {
                    return 2;
                }
            }
        }
        return 0;
    }

    public static boolean isLuaBindKeyword(PsiElement psiElement, AnnotationHolder annotationHolder) {
        if (psiElement.getNode().getElementType().toString().equals(LLuaElementTypeUtil.ID) && psiElement.getText().equals(LLuaElementTypeUtil.BIND)) {
            PsiElement parentPsi = psiElement.getParent();
            if (parentPsi != null) {
                parentPsi = parentPsi.getParent();
            }
            if (parentPsi != null) {
                PsiElement pp = parentPsi.getPrevSibling();
                if (parentPsi.getPrevSibling() instanceof PsiWhiteSpace) {
                    pp = parentPsi.getPrevSibling().getPrevSibling();
                }
                if (pp == null || !pp.getNode().getElementType().toString().equals(LLuaElementTypeUtil.ASSIGN)) {
                    return false;
                }
            } else {
                return false;
            }
            if (parentPsi != null) {
                parentPsi = parentPsi.getLastChild();
            }
            if (parentPsi != null) {
                if (parentPsi.getFirstChild() != null && parentPsi.getFirstChild().getNode().getElementType().toString().equals(LLuaElementTypeUtil.LPAREN)) {
                    LLuaPSIUtil.addLuaToBindKeyword(parentPsi.getFirstChild(), annotationHolder);
                }
                if (parentPsi.getLastChild() != null && parentPsi.getLastChild().getNode().getElementType().toString().equals(LLuaElementTypeUtil.RPAREN)) {
                    LLuaPSIUtil.addLuaToBindKeyword(parentPsi.getLastChild(), annotationHolder);
                }
            }
            LLuaPSIUtil.addLuaToBindKeyword(psiElement, annotationHolder);
            return true;
        }
        return false;
    }

    public static void addLuaToBindKeyword(PsiElement psiElement, AnnotationHolder annotationHolder) {
        Annotation annotation = annotationHolder.createInfoAnnotation(psiElement, "bind\u6570\u636e\u7ed1\u5b9a");
        annotation.setTextAttributes(DefaultLanguageHighlighterColors.KEYWORD);
    }
}

