/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.ui.project.manager;

import com.immomo.core.parser.LLuaParser;
import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.config.Constants;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.ui.values.LLuaStorageValues;
import com.immomo.ui.values.LLuaUtil;
import com.immomo.ui.values.LLuaVirtualFileUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;

public class LLuaProjectFileEditorListener
implements FileEditorManagerListener,
FileEditorManagerListener.Before {
    private int changedIndex = 0;
    private long lastTimeStamp = 0L;
    private Project project;
    private DocumentListener documentListener = new DocumentListener(){

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            if (LLuaStorageValues.LLuaAutoConvertState) {
                LLuaProjectFileEditorListener.this.initTimer();
                LLuaProjectFileEditorListener.this.lastTimeStamp = System.currentTimeMillis();
                LLuaProjectFileEditorListener.this.changedIndex++;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/immomo/ui/project/manager/LLuaProjectFileEditorListener$1", "documentChanged"));
        }
    };
    private Timer timer = null;
    private Document lastAddLister = null;

    private void parser() {
        if (this.changedIndex == 0) {
            return;
        }
        if (System.currentTimeMillis() - this.lastTimeStamp < 1000L) {
            return;
        }
        this.changedIndex = 0;
        LLuaProjectFileEditorListener.excShellCMDToParseLuaFile(this.project, this.lastAddLister);
    }

    private void initTimer() {
        if (this.timer != null) {
            return;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (LLuaProjectFileEditorListener.this.changedIndex > 0 && LLuaProjectFileEditorListener.this.lastAddLister != null) {
                    LLuaProjectFileEditorListener.this.parser();
                }
            }
        };
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(timerTask, 900L, 700L);
    }

    private void cancelTimer() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    public LLuaProjectFileEditorListener(Project project) {
        this.project = project;
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)this);
    }

    public void fileOpenedSync(@NotNull FileEditorManager source, @NotNull VirtualFile file, @NotNull Pair<FileEditor[], FileEditorProvider[]> editors) {
        if (source == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(0);
        }
        if (file == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(1);
        }
        if (editors == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(2);
        }
    }

    public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(3);
        }
        if (file == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(4);
        }
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(5);
        }
        if (file == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(6);
        }
        if (LLuaUtil.isLLuaFile(file) && source.getSelectedTextEditor() != null && this.documentListener != null) {
            if (this.lastAddLister == source.getSelectedTextEditor().getDocument()) {
                return;
            }
            try {
                if (this.lastAddLister != null) {
                    this.lastAddLister.removeDocumentListener(this.documentListener);
                }
                this.lastAddLister = source.getSelectedTextEditor().getDocument();
                this.lastAddLister.addDocumentListener(this.documentListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(7);
        }
        if (file == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(8);
        }
        if (LLuaUtil.isLLuaFile(file) && source.getSelectedTextEditor() != null && this.documentListener != null) {
            try {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null && this.lastAddLister != null && document == this.lastAddLister) {
                    document.removeDocumentListener(this.documentListener);
                    this.lastAddLister = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(9);
        }
        if (file == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(10);
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            LLuaProjectFileEditorListener.$$$reportNull$$$0(11);
        }
        if (event.getOldFile() != null && LLuaUtil.isLLuaFile(event.getOldFile())) {
            Document document = FileDocumentManager.getInstance().getDocument(event.getOldFile());
            try {
                if (document != null && this.lastAddLister != null) {
                    document.removeDocumentListener(this.documentListener);
                }
                if (this.lastAddLister == document) {
                    this.lastAddLister = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (event.getNewFile() != null && LLuaUtil.isLLuaFile(event.getNewFile()) && event.getManager().getSelectedTextEditor() != null) {
            if (this.lastAddLister == event.getManager().getSelectedTextEditor().getDocument()) {
                return;
            }
            try {
                if (this.lastAddLister != null) {
                    this.lastAddLister.removeDocumentListener(this.documentListener);
                }
                this.lastAddLister = event.getManager().getSelectedTextEditor().getDocument();
                this.lastAddLister.addDocumentListener(this.documentListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void excShellCMDToParseLuaFile(final Project project, final Document lluaDocument) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final LLuaParser parser = new LLuaParser();
                LLuaParser.setRequireBasePath(project.getBasePath() + "/src");
                try {
                    if (parser.parseSrc(lluaDocument.getText())) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    LLuaProjectFileEditorListener.writeMainLuaFile(project, parser, FileDocumentManager.getInstance().getFile(lluaDocument));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    LLuaParserStack.clear();
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LLuaParserStack.clear();
                }
            }
        }).start();
    }

    public static void excShellCMDToParseLuaFile(final Project project, final VirtualFile lluaFile) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final LLuaParser parser = new LLuaParser();
                LLuaParser.setRequireBasePath(project.getBasePath() + "/src");
                try {
                    if (parser.parseFileName(lluaFile.getPath())) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    LLuaProjectFileEditorListener.writeMainLuaFile(project, parser, lluaFile);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    LLuaParserStack.clear();
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LLuaParserStack.clear();
                }
            }
        }).start();
    }

    private static VirtualFile getFilePathFromDocument(VirtualFile lluaFile, Project project, boolean isUI, boolean isEmpty) {
        if (lluaFile == null) {
            return null;
        }
        String desFilePath = LLuaVirtualFileUtil.getLuaFilePathFromLLua(lluaFile, isUI);
        String delFilePath = LLuaVirtualFileUtil.getLuaFilePathFromLLua(lluaFile, !isUI);
        if (isEmpty) {
            VirtualFile desVirtualFile = lluaFile.getFileSystem().findFileByPath(desFilePath);
            if (desVirtualFile == null) {
                desVirtualFile = lluaFile.getFileSystem().findFileByPath(delFilePath);
            }
            return desVirtualFile;
        }
        LLuaVirtualFileUtil.deleteFile(project, delFilePath);
        VirtualFile desVirtualFile = lluaFile.getFileSystem().findFileByPath(desFilePath);
        if (desVirtualFile == null) {
            desVirtualFile = lluaFile.getFileSystem().refreshAndFindFileByPath(desFilePath);
        }
        if (desVirtualFile == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(lluaFile);
            if (psiFile != null) {
                FileTemplate actionTemplate = FileTemplateManager.getInstance((Project)project).getInternalTemplate("NewLLuaA.lua");
                try {
                    PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)actionTemplate, (String)LLuaVirtualFileUtil.getLuaNameFromLLua(lluaFile, isUI), null, (PsiDirectory)psiFile.getParent());
                    desVirtualFile = psiElement.getContainingFile().getVirtualFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                File file = new File(desFilePath);
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                desVirtualFile = lluaFile.getFileSystem().refreshAndFindFileByPath(desFilePath);
            }
            LLuaProjectFileEditorListener.updateUIPreviewFileChanged(lluaFile);
        }
        return desVirtualFile;
    }

    private static VirtualFile getVirtualFile(Project project, String path, String ext) {
        String desPath = path + "." + ext;
        VirtualFile desVirtualFile = project.getWorkspaceFile().getFileSystem().findFileByPath(desPath);
        if (desVirtualFile == null) {
            desVirtualFile = project.getWorkspaceFile().getFileSystem().refreshAndFindFileByPath(desPath);
        }
        if (desVirtualFile == null) {
            VirtualFile virtualFile = project.getWorkspaceFile().getFileSystem().findFileByPath(path + ".llua");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile != null) {
                FileTemplate actionTemplate = FileTemplateManager.getInstance((Project)project).getInternalTemplate("NewLLuaA.lua");
                try {
                    PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)actionTemplate, (String)virtualFile.getNameWithoutExtension(), null, (PsiDirectory)psiFile.getParent());
                    desVirtualFile = psiElement.getContainingFile().getVirtualFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                File file = new File(desPath);
                try {
                    file.createNewFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                desVirtualFile = project.getWorkspaceFile().getFileSystem().refreshAndFindFileByPath(desPath);
            }
        }
        return desVirtualFile;
    }

    private static void writeMainLuaFile(Project project, LLuaParser parser, VirtualFile lluaFile) {
        VirtualFile luaFile = LLuaProjectFileEditorListener.getFilePathFromDocument(lluaFile, project, parser.isUI(), !parser.hasSource());
        if (luaFile == null) {
            System.out.println("file not exist....");
            return;
        }
        LLuaVirtualFileUtil.writeTextToFile(project, luaFile, parser.parsedSource());
        LLuaProjectFileEditorListener.writeRequireFile(project);
        LLuaProjectFileEditorListener.writePreViewFile(project, parser, luaFile, lluaFile);
        BroadCastManager.getManager().send(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHOTO_PANEL_REFRESH"));
    }

    private static void writeRequireFile(Project project) {
        String basePath = project.getBasePath() + "/src/";
        for (LLuaParser parser : LLuaParserStack.getParsers()) {
            if (parser.getRequireName() == null || !parser.hasSource()) continue;
            VirtualFile file = LLuaProjectFileEditorListener.getVirtualFile(project, basePath + parser.getRequireName(), "lua");
            LLuaVirtualFileUtil.writeTextToFile(project, file, parser.parsedSource());
        }
    }

    private static void writePreViewFile(Project project, LLuaParser parser, VirtualFile luaFile, VirtualFile lluaFile) {
        StringBuilder preview = parser.getPreviewSource();
        try {
            VirtualFile preFile = project.getWorkspaceFile().getFileSystem().findFileByPath(project.getBasePath() + "/src/" + Constants.DOTPREVIEW);
            PsiDirectory preDirectory = null;
            if (preFile != null) {
                preDirectory = PsiManager.getInstance((Project)project).findDirectory(preFile);
            } else {
                preFile = project.getWorkspaceFile().getFileSystem().findFileByPath(project.getBasePath() + "/src");
                PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(preFile);
                preDirectory = directory.createSubdirectory(Constants.DOTPREVIEW);
            }
            String preName = Constants.PREVIEW + "_" + luaFile.getNameWithoutExtension();
            PsiFile prePsiFile = preDirectory.findFile(preName + "." + luaFile.getExtension());
            if (preview == null || !luaFile.getName().startsWith(LLuaVirtualFileUtil.LAYOUTNAME)) {
                if (prePsiFile != null) {
                    final PsiFile finalPrePsiFile = prePsiFile;
                    WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                finalPrePsiFile.getVirtualFile().delete(null);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    LLuaProjectFileEditorListener.updateUIPreviewFileChanged(lluaFile);
                }
                return;
            }
            if (prePsiFile == null) {
                FileTemplate actionTemplate = FileTemplateManager.getInstance((Project)project).getInternalTemplate("NewLLuaA.lua");
                PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)actionTemplate, (String)preName, null, (PsiDirectory)preDirectory);
                prePsiFile = psiElement.getContainingFile();
                LLuaProjectFileEditorListener.updateUIPreviewFileChanged(lluaFile);
            }
            String requireName = luaFile.getPath().substring(project.getBasePath().length() + 5);
            requireName = requireName.substring(0, requireName.length() - 4);
            preview.append('\n').append(Constants.REQUIRE).append("(\"").append(requireName).append("\")\n");
            LLuaVirtualFileUtil.writeTextToFile(project, prePsiFile.getVirtualFile(), preview.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void updateUIPreviewFileChanged(VirtualFile lluaFile) {
        BroadCastMessage message2 = BroadCastMessage.obtain("BC_PREVIEW_UPDATE");
        message2.msg = lluaFile;
        BroadCastManager.getManager().send(Application.getApplicationContext(), message2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/immomo/ui/project/manager/LLuaProjectFileEditorListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpenedSync";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileOpened";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileClosed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

