/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.ui.project.manager;

import com.immomo.core.parser.config.Constants;
import com.immomo.ui.project.manager.LLuaProjectFileEditorListener;
import com.immomo.ui.values.LLuaUtil;
import com.immomo.ui.values.LLuaVirtualFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LLuaFileManager
implements BulkFileListener {
    Project project;

    public LLuaFileManager(Project project) {
        this.project = project;
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            LLuaFileManager.$$$reportNull$$$0(0);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            LLuaFileManager.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            if (!LLuaUtil.isLLuaFile(vFileEvent.getFile())) continue;
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.fileContentChangeEvent((VFileContentChangeEvent)vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                this.fileCopyEvent((VFileCopyEvent)vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                this.fileCreateEvent((VFileCreateEvent)vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.fileDeleteEvent((VFileDeleteEvent)vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                this.fileMoveEvent((VFileMoveEvent)vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            this.filePropertyChangeEvent((VFilePropertyChangeEvent)vFileEvent);
        }
    }

    private void fileContentChangeEvent(VFileContentChangeEvent event) {
    }

    private void fileCopyEvent(VFileCopyEvent event) {
        String copyFilePath = event.getNewParent().getPath() + "/" + event.getNewChildName();
        VirtualFile copyFile = event.getFileSystem().findFileByPath(copyFilePath);
        LLuaProjectFileEditorListener.excShellCMDToParseLuaFile(this.project, copyFile);
    }

    private void fileCreateEvent(VFileCreateEvent event) {
        LLuaProjectFileEditorListener.excShellCMDToParseLuaFile(this.project, event.getFile());
    }

    private void fileDeleteEvent(VFileDeleteEvent event) {
        String previewPath = LLuaVirtualFileUtil.getLuaPreviewPath(this.project, event.getFile().getParent().getPath(), event.getFile().getNameWithoutExtension());
        String layoutPath = LLuaVirtualFileUtil.getLuaLayoutPath(event.getFile().getParent().getPath(), event.getFile().getNameWithoutExtension());
        String normalPath = LLuaVirtualFileUtil.getLuaNormalPath(event.getFile().getParent().getPath(), event.getFile().getNameWithoutExtension());
        final VirtualFile previewFile = event.getFileSystem().findFileByPath(previewPath);
        final VirtualFile layoutFile = event.getFileSystem().findFileByPath(layoutPath);
        final VirtualFile normalFile = event.getFileSystem().findFileByPath(normalPath);
        DumbService.getInstance((Project)this.project).smartInvokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (previewFile != null) {
                                previewFile.delete(null);
                            }
                            if (layoutFile != null) {
                                layoutFile.delete(null);
                            }
                            if (normalFile != null) {
                                normalFile.delete(null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    private void fileMoveEvent(VFileMoveEvent event) {
        String layoutPath = LLuaVirtualFileUtil.getLuaLayoutPath(event.getOldParent().getPath(), event.getFile().getNameWithoutExtension());
        String normalPath = LLuaVirtualFileUtil.getLuaNormalPath(event.getOldParent().getPath(), event.getFile().getNameWithoutExtension());
        VirtualFile layoutFile = event.getFile().getFileSystem().findFileByPath(layoutPath);
        VirtualFile normalFile = event.getFile().getFileSystem().findFileByPath(normalPath);
        try {
            if (layoutFile != null) {
                layoutFile.move(null, event.getNewParent());
            }
            if (normalFile != null) {
                normalFile.move(null, event.getNewParent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void filePropertyChangeEvent(VFilePropertyChangeEvent event) {
        if (!event.isRename()) {
            return;
        }
        String oldName = (String)event.getOldValue();
        if (oldName.endsWith("llua")) {
            oldName = oldName.substring(0, oldName.length() - 5);
        }
        String previewPath = LLuaVirtualFileUtil.getLuaPreviewPath(this.project, event.getFile().getParent().getPath(), oldName);
        String layoutPath = LLuaVirtualFileUtil.getLuaLayoutPath(event.getFile().getParent().getPath(), oldName);
        String normalPath = LLuaVirtualFileUtil.getLuaNormalPath(event.getFile().getParent().getPath(), oldName);
        VirtualFile previewFile = event.getFile().getFileSystem().findFileByPath(previewPath);
        VirtualFile layoutFile = event.getFile().getFileSystem().findFileByPath(layoutPath);
        VirtualFile normalFile = event.getFile().getFileSystem().findFileByPath(normalPath);
        try {
            if (previewFile != null) {
                previewFile.rename(null, Constants.PREVIEW + "_" + LLuaVirtualFileUtil.LAYOUTNAME + event.getFile().getNameWithoutExtension() + ".lua");
            }
            if (layoutFile != null) {
                layoutFile.rename(null, LLuaVirtualFileUtil.LAYOUTNAME + event.getFile().getNameWithoutExtension() + ".lua");
            }
            if (normalFile != null) {
                normalFile.rename(null, event.getFile().getNameWithoutExtension() + ".lua");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "events";
        objectArray2[1] = "com/immomo/ui/project/manager/LLuaFileManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

