/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.ui.language;

import com.immomo.ui.values.LLuaElementTypeUtil;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public class LLuaHighlightErrorFilter
extends HighlightErrorFilter {
    private static Object luaFiter = null;
    private static Method luaFiterMethod = null;

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement psiErrorElement) {
        PsiElement next2;
        if (psiErrorElement == null) {
            LLuaHighlightErrorFilter.$$$reportNull$$$0(0);
        }
        if (!psiErrorElement.getContainingFile().getVirtualFile().getName().toLowerCase().endsWith("llua")) {
            return this.shouldErr(psiErrorElement);
        }
        if (psiErrorElement.getText().equals(LLuaElementTypeUtil.ERROR_AT)) {
            PsiElement pre = psiErrorElement.getPrevSibling();
            if (pre instanceof PsiWhiteSpace) {
                pre = pre.getPrevSibling();
            }
            if (pre != null) {
                while (pre.getLastChild() != null) {
                    pre = pre.getLastChild();
                }
            }
            if (pre instanceof PsiErrorElement && pre.getPrevSibling().getNode().getElementType().toString().equals(LLuaElementTypeUtil.ASSIGN)) {
                return false;
            }
        }
        if ((next2 = psiErrorElement.getParent()) != null) {
            while (next2.getNextSibling() == null) {
                next2 = next2.getParent();
            }
        }
        if (next2 != null) {
            next2 = next2.getNextSibling();
        }
        if (next2 instanceof PsiWhiteSpace) {
            next2 = next2.getNextSibling();
        }
        if (next2 instanceof PsiErrorElement && next2.getText().equals(LLuaElementTypeUtil.ERROR_AT)) {
            return false;
        }
        return this.shouldErr(psiErrorElement);
    }

    private boolean shouldErr(PsiErrorElement psiErrorElement) {
        if (luaFiter == null) {
            try {
                Class<?> filter = Class.forName("com.tang.intellij.lua.highlighting.LuaHighlightErrorFilter");
                luaFiter = filter.newInstance();
                luaFiterMethod = filter.getDeclaredMethod("shouldHighlightErrorElement", PsiErrorElement.class);
            }
            catch (Exception e) {
                System.out.println(e);
                luaFiter = null;
                luaFiterMethod = null;
            }
        }
        boolean ret2 = true;
        if (luaFiterMethod != null) {
            try {
                ret2 = (Boolean)luaFiterMethod.invoke(luaFiter, psiErrorElement);
            }
            catch (Exception e) {
                System.out.println("===============");
                System.out.println(e);
            }
        }
        return ret2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiErrorElement", "com/immomo/ui/language/LLuaHighlightErrorFilter", "shouldHighlightErrorElement"));
    }
}

