/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.utils;

import com.immomo.mmpaas.utils.Log;
import com.immomo.mmpaas.utils.MMThreadPoolExecutor;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class ThreadUtils {
    private static MMThreadPoolExecutor threadPoolExecutor;
    private static final Lock lock;
    private static List<Runnable> shutdownTasks;

    private static void createThreadPool() {
        lock.lock();
        threadPoolExecutor = new MMThreadPoolExecutor(2, 5, 10, 5000L, "MMT-");
        threadPoolExecutor.setOnTaskRejectedListener((task, times) -> {
            Log.l("on task(%s) reject %d times", task, times);
            if (times == 1) {
                return MMThreadPoolExecutor.ProcessType.queue;
            }
            return MMThreadPoolExecutor.ProcessType.dead;
        });
        threadPoolExecutor.setOnAllThreadBlockListener(time -> {
            if (time > 10000L) {
                Log.l(ThreadUtils.dumpAllThread(null), new Object[0]);
                ThreadUtils.shutdownThreadPool();
                ThreadUtils.createThreadPool();
            }
        });
        if (shutdownTasks != null) {
            Log.l("create thread pool and task is not null, size is: %d", shutdownTasks.size());
            for (Runnable r : shutdownTasks) {
                threadPoolExecutor.execute(r);
            }
            shutdownTasks = null;
        }
        lock.unlock();
    }

    private static void shutdownThreadPool() {
        lock.lock();
        if (threadPoolExecutor != null && !threadPoolExecutor.isShutdown()) {
            shutdownTasks = threadPoolExecutor.shutdownNow();
        }
        lock.unlock();
    }

    public static void execute(Runnable task) {
        ThreadUtils.execute(null, task, null);
    }

    public static void execute(String taskName, Runnable task) {
        ThreadUtils.execute(taskName, task, null);
    }

    public static void execute(String taskName, Runnable task, MMThreadPoolExecutor.OnTaskRejectedListener l) {
        lock.lock();
        if (threadPoolExecutor == null || threadPoolExecutor.isShutdown()) {
            ThreadUtils.createThreadPool();
        }
        lock.unlock();
        threadPoolExecutor.execute(taskName, task, l);
    }

    public static String dumpAllThread(String threadNamePattern) {
        ThreadGroup parent;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while ((parent = threadGroup.getParent()) != null) {
            threadGroup = parent;
        }
        int activeThread = threadGroup.activeCount();
        Thread[] allThread = new Thread[activeThread];
        int len2 = threadGroup.enumerate(allThread);
        Thread current = Thread.currentThread();
        StringBuilder sb = new StringBuilder("Dump thread stack in ").append(current).append('\n');
        Pattern pattern = threadNamePattern != null ? Pattern.compile(threadNamePattern) : null;
        for (int i = 0; i < len2; ++i) {
            Thread t = allThread[i];
            if (t == current || pattern != null && !pattern.matcher(t.getName()).find()) continue;
            sb.append(t).append('-').append((Object)t.getState()).append(" : ");
            ThreadUtils.dumpThread(t, sb);
            sb.append('\n');
        }
        return sb.toString();
    }

    private static void dumpThread(Thread t, StringBuilder sb) {
        for (StackTraceElement e : t.getStackTrace()) {
            sb.append("\n\tat ").append(e);
        }
    }

    static {
        lock = new ReentrantLock();
        ThreadUtils.createThreadPool();
    }
}

