/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MMThreadPoolExecutor
extends ThreadPoolExecutor
implements RejectedExecutionHandler {
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final LinkedList<Task> rejectedTasks;
    private final LinkedList<Task> maxPriorityTask;
    private final ExecuteQueueTask executeQueueTask;
    private final String threadNamePrefix;
    private OnTaskRejectedListener onTaskRejectedListener;
    private OnAllThreadBlockListener onAllThreadBlockListener;
    private int maxRejectCount;
    private int queueLength;
    private volatile long lastTaskCompleteTime;

    public MMThreadPoolExecutor(int corePoolSize, int maximumPoolSize) {
        this(corePoolSize, maximumPoolSize, maximumPoolSize);
    }

    public MMThreadPoolExecutor(int corePoolSize, int maximumPoolSize, int queueLength) {
        this(corePoolSize, maximumPoolSize, queueLength, 10000L);
    }

    public MMThreadPoolExecutor(int corePoolSize, int maximumPoolSize, int queueLength, long autoCheckTime) {
        this(corePoolSize, maximumPoolSize, queueLength, autoCheckTime, "MThread-");
    }

    public MMThreadPoolExecutor(int corePoolSize, int maximumPoolSize, int queueLength, long autoCheckTime, String threadNamePrefix) {
        super(corePoolSize, maximumPoolSize, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(queueLength));
        this.queueLength = queueLength;
        this.threadNamePrefix = threadNamePrefix;
        this.setThreadFactory(r -> new Thread(r, threadNamePrefix + this.threadCount.getAndIncrement()));
        this.setRejectedExecutionHandler(this);
        this.rejectedTasks = new LinkedList();
        this.maxPriorityTask = new LinkedList();
        this.maxRejectCount = 2;
        this.executeQueueTask = new ExecuteQueueTask(this, autoCheckTime);
        this.executeQueueTask.start();
    }

    public void setOnAllThreadBlockListener(OnAllThreadBlockListener onAllThreadBlockListener) {
        this.onAllThreadBlockListener = onAllThreadBlockListener;
    }

    public void setMaxRejectCount(int maxRejectCount) {
        this.maxRejectCount = maxRejectCount;
    }

    public void setOnTaskRejectedListener(OnTaskRejectedListener onTaskRejectedListener) {
        this.onTaskRejectedListener = onTaskRejectedListener;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        ProcessType type2;
        Task rr = (Task)r;
        rr.rejectCount++;
        if (rr.onTaskRejectedListener != null) {
            type2 = rr.onTaskRejectedListener.onTaskReject(rr.innerTask, rr.rejectCount);
        } else if (this.onTaskRejectedListener != null) {
            type2 = this.onTaskRejectedListener.onTaskReject(rr.innerTask, rr.rejectCount);
        } else {
            ProcessType processType = type2 = rr.rejectCount < this.maxRejectCount ? ProcessType.queue : ProcessType.dead;
        }
        if (type2 == ProcessType.dead) {
            return;
        }
        this.addToRejectedQueue(rr, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> tasks;
        LinkedList<Task> linkedList = this.maxPriorityTask;
        synchronized (linkedList) {
            tasks = new ArrayList<Runnable>(this.maxPriorityTask);
        }
        tasks.addAll(super.shutdownNow());
        linkedList = this.rejectedTasks;
        synchronized (linkedList) {
            tasks.addAll(this.rejectedTasks);
        }
        return tasks;
    }

    @Override
    public void execute(Runnable r) {
        if (!(r instanceof Task)) {
            r = new Task(r);
        }
        this.lastTaskCompleteTime = MMThreadPoolExecutor.now();
        super.execute(r);
    }

    public void execute(String taskName, Runnable r, OnTaskRejectedListener l) {
        Task task;
        if (r instanceof Task) {
            task = (Task)r;
            task.onTaskRejectedListener = l;
        } else {
            task = new Task(taskName, r, l);
        }
        this.lastTaskCompleteTime = MMThreadPoolExecutor.now();
        super.execute(task);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.lastTaskCompleteTime = MMThreadPoolExecutor.now();
        this.executeQueueTask.check();
        if (t != null) {
            return;
        }
        Task task = this.popMaxPriority();
        while (task != null) {
            task.run();
            task = this.popMaxPriority();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRejectedQueue(Task rr, ProcessType type2) {
        if (type2 == ProcessType.queue) {
            LinkedList<Task> linkedList = this.rejectedTasks;
            synchronized (linkedList) {
                this.rejectedTasks.addLast(rr);
            }
        }
        LinkedList<Task> linkedList = this.maxPriorityTask;
        synchronized (linkedList) {
            this.maxPriorityTask.addLast(rr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task popMaxPriority() {
        LinkedList<Task> linkedList = this.maxPriorityTask;
        synchronized (linkedList) {
            if (!this.maxPriorityTask.isEmpty()) {
                return this.maxPriorityTask.removeFirst();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task pop() {
        LinkedList<Task> linkedList = this.rejectedTasks;
        synchronized (linkedList) {
            if (!this.rejectedTasks.isEmpty()) {
                return this.rejectedTasks.removeFirst();
            }
            return null;
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static final class ExecuteQueueTask
    extends Thread {
        private final MMThreadPoolExecutor executor;
        private final long autoCheckTime;
        private long lastCompleteCount;

        private ExecuteQueueTask(MMThreadPoolExecutor executor, long autoCheckTime) {
            super("ExecuteQueueTaskThread");
            this.executor = executor;
            this.autoCheckTime = autoCheckTime;
            this.lastCompleteCount = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.executor.isShutdown()) {
                    Task task;
                    ExecuteQueueTask executeQueueTask = this;
                    synchronized (executeQueueTask) {
                        if (this.autoCheckTime > 0L) {
                            this.wait(this.autoCheckTime);
                        } else {
                            this.wait();
                        }
                    }
                    if (this.checkIfBlockAllThread() || (task = this.executor.pop()) == null || this.executor.isShutdown()) continue;
                    this.executor.execute(task);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private boolean checkIfBlockAllThread() {
            long nowCompleteCount = this.executor.getCompletedTaskCount();
            if (this.lastCompleteCount == -1L || this.lastCompleteCount != nowCompleteCount) {
                this.lastCompleteCount = nowCompleteCount;
                return false;
            }
            if (this.executor.isShutdown()) {
                return false;
            }
            if (this.executor.getActiveCount() < this.executor.getMaximumPoolSize()) {
                return false;
            }
            if (this.executor.getQueue().size() < this.executor.queueLength) {
                return false;
            }
            if (this.executor.onAllThreadBlockListener != null) {
                this.executor.onAllThreadBlockListener.onThreadBlock(MMThreadPoolExecutor.now() - this.executor.lastTaskCompleteTime);
            }
            return true;
        }

        private synchronized void check() {
            this.notifyAll();
        }
    }

    public static interface OnAllThreadBlockListener {
        public void onThreadBlock(long var1);
    }

    public static interface OnTaskRejectedListener {
        public ProcessType onTaskReject(Runnable var1, int var2);
    }

    public static enum ProcessType {
        maxPriority,
        queue,
        dead;

    }

    public static final class Task
    implements Runnable {
        private final Runnable innerTask;
        private final String name;
        private int rejectCount;
        private OnTaskRejectedListener onTaskRejectedListener;

        private Task(Runnable innerTask) {
            this(null, innerTask, null);
        }

        public Task(String name, Runnable inner, OnTaskRejectedListener l) {
            this.name = name;
            this.innerTask = inner;
            this.rejectCount = 0;
            this.onTaskRejectedListener = l;
        }

        @Override
        public void run() {
            this.innerTask.run();
        }

        public String toString() {
            return String.format("%s - %s", this.name, String.valueOf(this.innerTask));
        }
    }
}

