/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.utils;

import com.immomo.mmpaas.utils.CurrentPathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JarCopyUtils {
    private static final int BUFFER_SIZE = 8192;
    public static final String NATIVE_FOLDER_PATH_PREFIX = "mpaas_temp";
    private static File temporaryDir;

    public static synchronized File copyToTempFromJar(String path) throws IOException {
        return JarCopyUtils.copyToTempFromJar(path, null);
    }

    public static synchronized File copyToTempFromJar(String path, Class<?> loadClass) throws IOException {
        if (null == path || path.charAt(0) != File.separatorChar) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        if (temporaryDir == null) {
            temporaryDir = JarCopyUtils.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
        }
        File temp = new File(temporaryDir, path);
        Class clazz = loadClass == null ? JarCopyUtils.class : loadClass;
        try (InputStream is = clazz.getResourceAsStream(path);){
            if (temp.exists()) {
                temp.deleteOnExit();
            }
            JarCopyUtils.copy(is, temp);
            File file = temp;
            return file;
        }
    }

    private static File createTempDirectory(String temp) {
        return new File(CurrentPathUtils.getJarRoot() + File.separator + temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream in, File target) throws IOException {
        target.delete();
        File parent = target.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(target);){
            long l = JarCopyUtils.copy(in, out);
            return l;
        }
    }

    private static long copy(InputStream source, OutputStream dest) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            dest.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }
}

