/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.utils;

import com.immomo.mmpaas.utils.CurrentPathUtils;
import com.immomo.mmpaas.utils.ThreadUtils;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;

public class ImageLoader {
    private static volatile ImageLoader instance;

    private ImageLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance() {
        if (instance != null) return instance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (instance != null) return instance;
            instance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Image loadProjectImage(String name) {
        URL url = null;
        if (name != null && !name.equals("")) {
            url = CurrentPathUtils.getSourceFileURL(name);
        }
        if (url != null) {
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, null);
            return image;
        }
        return null;
    }

    public Image loadProjectImage(String name, int width, int height) {
        URL url = CurrentPathUtils.getSourceFileURL(name);
        if (url != null) {
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            Toolkit.getDefaultToolkit().prepareImage(image, width, height, null);
            return image;
        }
        return null;
    }

    public ImageIcon loadProjectImageIcon(String name) {
        URL url = CurrentPathUtils.getSourceFileURL(name);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public void loadOnlineImage(String url, OnImageLoadListener l) {
        if (l == null) {
            return;
        }
        ThreadUtils.execute(() -> {
            try {
                URL u = new URL(url);
                Image image = Toolkit.getDefaultToolkit().getImage(u);
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, null);
                l.onLoad(url, image);
            }
            catch (Throwable t) {
                l.onLoad(url, null);
            }
        });
    }

    public static interface OnImageLoadListener {
        public void onLoad(String var1, Image var2);
    }
}

