/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class IOUtil {
    public static final int BUFFER_SIZE = 8192;

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(InputStream input) {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int bytesRead;
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtil.closeQuietly(output);
        }
    }

    public static byte[] toBytes(InputStream input, String inputEncoding) {
        byte[] result = IOUtil.toBytes(input);
        if (result != null && inputEncoding != null && !"utf-8".equalsIgnoreCase(inputEncoding)) {
            try {
                return new String(result, inputEncoding).getBytes("utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static byte[] toBytes(InputStream input, int length) {
        if (length > 0) {
            int pos;
            byte[] bytes = new byte[length];
            try {
                int count;
                for (pos = 0; pos < length && (count = input.read(bytes, pos, length - pos)) != -1; pos += count) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (pos != length) {
                return null;
            }
            return bytes;
        }
        return IOUtil.toBytes(input);
    }
}

