/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.utils;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.utils.IOUtil;
import com.immomo.mmpaas.utils.Log;
import com.sun.istack.internal.NotNull;
import java.awt.Desktop;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class FileUtil {
    private static final int BUFFER = 8192;
    private static boolean useMemoryMap = true;
    public static boolean DEBUG = false;

    public static void writeFile(@NotNull File file, InputStream is) throws Exception {
        byte[] data = new byte[8192];
        BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(file), 8192);
        int count = 0;
        while ((count = is.read(data, 0, 8192)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
    }

    public boolean isFolder(String filePath) {
        if (!FileUtil.isEmpty(filePath)) {
            File file = new File(filePath);
            return file.exists() && file.isDirectory();
        }
        return false;
    }

    public boolean isFile(String filePath) {
        if (!FileUtil.isEmpty(filePath)) {
            File file = new File(filePath);
            return file.exists() && file.isFile();
        }
        return false;
    }

    public static File createFile(String fullpath) {
        File file = new File(fullpath);
        if (file.exists()) {
            return file;
        }
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String fileName = file.getName();
        return new File(parent, fileName);
    }

    public static boolean deleteFile(String path) {
        File file = new File(path);
        if (file != null) {
            return file.delete();
        }
        return false;
    }

    public static File createFile(String path, String fileName) {
        File directory = new File(path);
        directory.mkdirs();
        return new File(directory, fileName);
    }

    public static boolean clearFile(File f) {
        if (f.exists() && !f.delete()) {
            return false;
        }
        try {
            return f.createNewFile();
        }
        catch (IOException e) {
            FileUtil.logError(e);
            return false;
        }
    }

    public static byte[] readBytes(File f) {
        if (f != null && f.exists() && f.isFile()) {
            byte[] byArray;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(f);
                byArray = IOUtil.toBytes(inputStream);
            }
            catch (FileNotFoundException e) {
                try {
                    FileUtil.logError(e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtil.closeQuietly(inputStream);
            }
            IOUtil.closeQuietly(inputStream);
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fastReadBytes(File f) {
        if (!useMemoryMap) {
            return FileUtil.readBytes(f);
        }
        if (f != null && f.exists() && f.isFile()) {
            byte[] byArray;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(f);
                MappedByteBuffer buffer = inputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, f.length());
                byte[] result = new byte[(int)f.length()];
                buffer.get(result);
                byArray = result;
            }
            catch (Exception e) {
                try {
                    FileUtil.logError(e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtil.closeQuietly(inputStream);
            }
            IOUtil.closeQuietly(inputStream);
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fastSave(File file, byte[] data) {
        if (!useMemoryMap) {
            return FileUtil.save(file, data);
        }
        if (data != null && data.length > 0) {
            boolean bl;
            FileChannel out = null;
            try {
                out = new RandomAccessFile(file, "rw").getChannel();
                MappedByteBuffer map = out.map(FileChannel.MapMode.READ_WRITE, 0L, data.length);
                map.put(data);
                map.force();
                bl = true;
            }
            catch (IOException e) {
                boolean bl2;
                try {
                    FileUtil.logError(e);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(out);
                    throw throwable;
                }
                IOUtil.closeQuietly(out);
                return bl2;
            }
            IOUtil.closeQuietly(out);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fastCopy(File from, File to) {
        FileInputStream inputStream = null;
        FileChannel inChannel = null;
        FileOutputStream outputStream = null;
        FileChannel outChannel = null;
        try {
            inputStream = new FileInputStream(from);
            inChannel = inputStream.getChannel();
            outputStream = new FileOutputStream(to);
            outChannel = outputStream.getChannel();
            outChannel.transferFrom(inChannel, 0L, from.length());
        }
        catch (IOException e) {
            boolean bl;
            try {
                FileUtil.logError(e);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(inputStream);
                IOUtil.closeQuietly(inChannel);
                IOUtil.closeQuietly(outputStream);
                IOUtil.closeQuietly(outChannel);
                throw throwable;
            }
            IOUtil.closeQuietly(inputStream);
            IOUtil.closeQuietly(inChannel);
            IOUtil.closeQuietly(outputStream);
            IOUtil.closeQuietly(outChannel);
            return bl;
        }
        IOUtil.closeQuietly(inputStream);
        IOUtil.closeQuietly(inChannel);
        IOUtil.closeQuietly(outputStream);
        IOUtil.closeQuietly(outChannel);
        return true;
    }

    public static boolean fastSave(String path, byte[] data) {
        if (!useMemoryMap) {
            return FileUtil.save(path, data);
        }
        if (!FileUtil.isEmpty(path)) {
            File destFile = FileUtil.createFile(path);
            return FileUtil.fastSave(destFile, data);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(File file, byte[] data) {
        if (data != null && data.length > 0) {
            boolean bl;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                out.write(data);
                out.flush();
                bl = true;
            }
            catch (IOException e) {
                boolean bl2;
                try {
                    FileUtil.logError(e);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(out);
                    throw throwable;
                }
                IOUtil.closeQuietly(out);
                return bl2;
            }
            IOUtil.closeQuietly(out);
            return bl;
        }
        return false;
    }

    public static boolean save(String path, byte[] data) {
        if (!FileUtil.isEmpty(path)) {
            File destFile = FileUtil.createFile(path);
            return FileUtil.save(destFile, data);
        }
        return false;
    }

    private static void logError(Throwable e) {
    }

    public static boolean isEmpty(String text) {
        return text == null || text.equals("");
    }

    public static void openLocalFile(String path) {
        block2: {
            try {
                Desktop.getDesktop().open(new File(path));
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!Application.DEBUG) break block2;
                Log.e("openLocalFile", path + "--->" + e.getMessage());
            }
        }
    }
}

