/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.utils;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.GlobalConfigManager;
import com.immomo.mmpaas.utils.JarCopyUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class CurrentPathUtils {
    private static final String soPath = String.format("%cimmomo%clib%c", Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar));
    private static final String formatSoPath = soPath + "lib%s.so";
    private static String Path;

    private CurrentPathUtils() {
    }

    public static String getPath() {
        if (Path == null) {
            URL url = Application.class.getClassLoader().getResource("");
            if (url != null) {
                Path = new File(url.getFile()).getParent();
            }
            return Path;
        }
        return Path;
    }

    public static String getCopySourceFile(String file) {
        String path = null;
        if (Application.DEBUG) {
            URL url = CurrentPathUtils.class.getResource(File.separator + file);
            if (url != null) {
                path = url.getPath();
            }
        } else {
            path = CurrentPathUtils.getJarRoot() + File.separator + "mpaas_temp" + File.separator + file;
        }
        return path == null ? "" : path;
    }

    public static URL getSourceFileURL(String file) {
        return CurrentPathUtils.class.getResource(File.separator + file);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getJarRoot() {
        URL url;
        if (!CurrentPathUtils.isPlugin()) {
            url = CurrentPathUtils.class.getProtectionDomain().getCodeSource().getLocation();
            return new File(url.getPath()).getParent();
        }
        if (Application.DEBUG) {
            url = CurrentPathUtils.class.getResource("/");
            return new File(url.getPath()).getParent();
        }
        URL url2 = CurrentPathUtils.class.getResource("/immomo");
        String path = url2.getPath();
        int lastindex = path.lastIndexOf("!/immomo");
        return new File(path.substring(0, lastindex)).getParent();
    }

    public static void load(String lib2) {
        if (Application.DEBUG) {
            URL url = CurrentPathUtils.class.getResource(String.format(formatSoPath, lib2));
            System.load(url.getPath());
        } else {
            try {
                File file = JarCopyUtils.copyToTempFromJar(String.format(formatSoPath, lib2));
                System.load(file.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isPlugin() {
        return GlobalConfigManager.getInstance().isIsPlugin();
    }
}

