/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.table;

import java.util.Objects;

public abstract class LuaValue<T> {
    public static final int LUA_TNIL = 0;
    public static final int LUA_TBOOLEAN = 1;
    public static final int LUA_TNUMBER = 3;
    public static final int LUA_TSTRING = 4;
    public static final int LUA_TTABLE = 5;
    public static final int LUA_REAL = 256;
    public static final String S_NIL = "nil";
    private static LuaNil nil;
    private static LuaBoolean True;
    private static LuaBoolean False;
    protected T value;

    public static LuaValue parse(Object s) {
        if (s == null) {
            return nil;
        }
        if (s == Boolean.TRUE) {
            return True;
        }
        if (s == Boolean.FALSE) {
            return False;
        }
        if (s instanceof Number) {
            return new LuaNumber((Number)s);
        }
        if (s instanceof String) {
            String str = s.toString();
            if (str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
                return new LuaRealString(str);
            }
            return new LuaString(str);
        }
        return null;
    }

    public abstract int type();

    public abstract String toJString();

    public abstract String toTableString();

    public T getValue() {
        return this.value;
    }

    public boolean isNil() {
        return this.checkType(0);
    }

    public boolean isBoolean() {
        return this.checkType(1);
    }

    public boolean isNumber() {
        return this.checkType(3);
    }

    public boolean isString() {
        return this.checkType(4);
    }

    public boolean isRealString() {
        return this.isString() && this.checkType(256);
    }

    public boolean isTable() {
        return this.checkType(5);
    }

    private boolean checkType(int mask) {
        return (this.type() & mask) == mask;
    }

    public String toString() {
        return this.value + "-type(" + this.type() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LuaValue)) {
            return false;
        }
        LuaValue luaValue = (LuaValue)o;
        return Objects.equals(this.value, luaValue.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static {
        True = new LuaBoolean(true);
        False = new LuaBoolean(false);
    }

    private static final class LuaNumber
    extends LuaValue<Number> {
        private LuaNumber(Number value) {
            this.value = value;
        }

        @Override
        public int type() {
            return 3;
        }

        @Override
        public String toJString() {
            return String.valueOf(this.value);
        }

        @Override
        public String toTableString() {
            return String.valueOf(this.value);
        }
    }

    private static final class LuaRealString
    extends LuaString {
        private LuaRealString(String value) {
            super(value);
        }

        @Override
        public int type() {
            return super.type() & 0x100;
        }

        @Override
        public String toJString() {
            return ((String)this.value).substring(1, ((String)this.value).length() - 1);
        }
    }

    private static class LuaString
    extends LuaValue<String> {
        private LuaString(String value) {
            this.value = value;
        }

        @Override
        public int type() {
            return 4;
        }

        @Override
        public String toJString() {
            return (String)this.value;
        }

        @Override
        public String toTableString() {
            return (String)this.value;
        }
    }

    private static class LuaBoolean
    extends LuaValue<Boolean> {
        private LuaBoolean(Boolean b) {
            this.value = b;
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public String toJString() {
            return ((Boolean)this.value).toString();
        }

        @Override
        public String toTableString() {
            return ((Boolean)this.value).toString();
        }
    }

    private static class LuaNil
    extends LuaValue<Void> {
        private LuaNil() {
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public String toJString() {
            return null;
        }

        @Override
        public String toTableString() {
            return LuaValue.S_NIL;
        }

        static {
            nil = new LuaNil();
        }
    }
}

