/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.table;

import com.immomo.mmpaas.table.LuaValue;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LuaTable
extends LuaValue<LinkedHashMap<LuaValue, LuaValue>>
implements Map<LuaValue, LuaValue> {
    private static final String BLANK = " ";

    public LuaTable() {
        this.value = new LinkedHashMap();
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public String toJString() {
        return this.toTableString();
    }

    @Override
    public String toTableString() {
        StringBuilder sb = new StringBuilder();
        this.appendToTable(sb, 1, BLANK);
        return sb.toString();
    }

    public String toString(String black, int blankCount) {
        StringBuilder sb = new StringBuilder();
        this.appendToTable(sb, blankCount, black);
        return sb.toString();
    }

    private void appendToTable(StringBuilder sb, int bCount, String blank) {
        sb.append('{').append('\n');
        for (Map.Entry entry : ((LinkedHashMap)this.value).entrySet()) {
            LuaValue k = (LuaValue)entry.getKey();
            LuaValue v = (LuaValue)entry.getValue();
            LuaTable.appenBlank(sb, bCount, blank);
            if (!k.isNumber()) {
                sb.append(k.toTableString()).append(' ').append('=').append(' ');
            }
            if (v.isTable()) {
                LuaTable t = (LuaTable)v;
                t.appendToTable(sb, bCount + 1, blank);
            } else {
                sb.append(v.toTableString());
            }
            sb.append(',');
            sb.append('\n');
        }
        LuaTable.appenBlank(sb, bCount - 1, blank);
        sb.append('}');
    }

    private static void appenBlank(StringBuilder sb, int bCount, String blank) {
        while (bCount > 0) {
            sb.append(blank);
            --bCount;
        }
    }

    @Override
    public int size() {
        return ((LinkedHashMap)this.value).size();
    }

    @Override
    public boolean isEmpty() {
        return ((LinkedHashMap)this.value).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return ((LinkedHashMap)this.value).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return ((LinkedHashMap)this.value).containsValue(value);
    }

    @Override
    public LuaValue get(Object key) {
        return (LuaValue)((LinkedHashMap)this.value).get(key);
    }

    @Override
    public LuaValue put(LuaValue key, LuaValue value) {
        return ((LinkedHashMap)this.value).put(key, value);
    }

    @Override
    public LuaValue remove(Object key) {
        return (LuaValue)((LinkedHashMap)this.value).remove(key);
    }

    @Override
    public void putAll(Map<? extends LuaValue, ? extends LuaValue> m) {
        ((LinkedHashMap)this.value).putAll(m);
    }

    @Override
    public void clear() {
        ((LinkedHashMap)this.value).clear();
    }

    @Override
    public Set<LuaValue> keySet() {
        return ((LinkedHashMap)this.value).keySet();
    }

    @Override
    public Collection<LuaValue> values() {
        return ((LinkedHashMap)this.value).values();
    }

    @Override
    public Set<Map.Entry<LuaValue, LuaValue>> entrySet() {
        return ((LinkedHashMap)this.value).entrySet();
    }
}

