/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.table;

import com.immomo.mmpaas.table.LuaTable;
import com.immomo.mmpaas.table.LuaTableParseException;
import com.immomo.mmpaas.table.LuaValue;
import java.util.Arrays;

public class LuaParser {
    private static final char S = '{';
    private static final char E = '}';
    private static final char SE = ',';
    private static final char EQ = '=';
    private static final char L = '\n';
    private static final char C = '-';
    private static final char QM = '\"';
    private static final char SQM = '\'';
    private static final char B = '(';
    private static final char BE = ')';
    private static final char[] BLANK;

    public static LuaTable parse(char[] data) {
        int i;
        int len2 = data.length;
        for (i = 0; i < len2; ++i) {
            int ni = LuaParser.removeComment(data, i, len2);
            if (ni != i) {
                i = ni;
                continue;
            }
            if (data[i] == '{') break;
        }
        return LuaParser.parseTable(data, i, new int[1]);
    }

    private static int removeComment(char[] data, int start, int maxLen) {
        if (data[start] == '-' && start < maxLen - 1 && data[start + 1] == '-') {
            int j;
            for (j = start + 2; j < maxLen && data[j] != '\n'; ++j) {
            }
            start = j;
        }
        return start;
    }

    private static LuaTable parseTable(char[] data, int start, int[] out) {
        int len2 = data.length;
        String stringKey = null;
        int numberKey = 0;
        LuaTable ret2 = new LuaTable();
        int keyStart = start + 1;
        int valueStart = -1;
        boolean end = false;
        boolean inQM = false;
        boolean inSQM = false;
        int bracketCount = 0;
        for (int i = keyStart; i < len2; ++i) {
            char c = data[i];
            if (bracketCount == 0) {
                if (c == '\"') {
                    if (inSQM) continue;
                    if (inQM && i > 0 && data[i - 1] != '\\') {
                        inQM = false;
                        continue;
                    }
                    inQM = true;
                    continue;
                }
                if (c == '\'') {
                    if (inQM) continue;
                    if (inSQM && i > 0 && data[i - 1] != '\\') {
                        inSQM = false;
                        continue;
                    }
                    inSQM = true;
                    continue;
                }
            }
            if (!inQM && !inSQM) {
                if (c == '(') {
                    ++bracketCount;
                    continue;
                }
                if (c == ')') {
                    --bracketCount;
                    continue;
                }
            }
            if (inQM || inSQM || bracketCount > 0) continue;
            int ni = LuaParser.removeComment(data, i, len2);
            if (ni != i) {
                keyStart = ni;
                i = ni;
                continue;
            }
            if (c == '{') {
                keyStart = -1;
                valueStart = -1;
                if (stringKey == null) {
                    ret2.put(LuaValue.parse(++numberKey), LuaParser.parseTable(data, i, out));
                    i = out[0];
                    continue;
                }
                ret2.put(LuaValue.parse(stringKey), LuaParser.parseTable(data, i, out));
                stringKey = null;
                i = out[0];
                continue;
            }
            if (c == '}') {
                if (valueStart != -1 && LuaParser.addValue(data, valueStart, stringKey, numberKey, i - 1, ret2)) {
                    ++numberKey;
                }
                out[0] = i;
                end = true;
                break;
            }
            if (keyStart == -1) {
                keyStart = i;
            }
            if (c == '=') {
                String key = LuaParser.newString(data, keyStart, i - 1);
                if (key == null) {
                    throw LuaTableParseException.parse(data, i);
                }
                try {
                    numberKey = Integer.parseInt(key);
                }
                catch (Throwable ignore) {
                    stringKey = key;
                }
                valueStart = i + 1;
                continue;
            }
            if (c != ',') continue;
            if (valueStart != -1 && LuaParser.addValue(data, valueStart, stringKey, numberKey, i - 1, ret2)) {
                ++numberKey;
            }
            keyStart = i + 1;
            valueStart = -1;
            stringKey = null;
        }
        if (!end) {
            throw LuaTableParseException.parse(data, len2);
        }
        return ret2;
    }

    private static boolean addValue(char[] data, int vs, String sk, int nk, int i, LuaTable t) {
        String value = LuaParser.newString(data, vs, i);
        if (value == null) {
            throw LuaTableParseException.parse(data, i);
        }
        LuaValue v = LuaValue.parse(LuaParser.newValue(value));
        if (sk == null) {
            t.put(LuaValue.parse(++nk), v);
            return true;
        }
        t.put(LuaValue.parse(sk), v);
        return false;
    }

    private static String newString(char[] data, int start, int end) {
        if (start >= end) {
            return null;
        }
        while (start < end && Arrays.binarySearch(BLANK, data[start]) >= 0) {
            ++start;
        }
        while (start < end && Arrays.binarySearch(BLANK, data[end]) >= 0) {
            --end;
        }
        if (start > end) {
            return null;
        }
        return new String(data, start, end - start + 1);
    }

    private static Object newValue(String value) {
        if ("nil".equals(value)) {
            return null;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        char start = value.charAt(0);
        if (start >= '0' && start <= '9' || start == '-') {
            try {
                return Long.parseLong(value);
            }
            catch (Throwable throwable) {
                try {
                    return Double.parseDouble(value);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    static {
        char[] b = new char[]{' ', '\n', '\t'};
        Arrays.sort(b);
        BLANK = b;
    }
}

