/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.plugin.service;

import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.base.broadcast.BroadCastManager;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.plugin.FileTypeUtils;
import com.immomo.mmpaas.plugin.LuaPreviewEditor;
import com.immomo.mmpaas.plugin.preview.PreViewToolWindow;
import com.immomo.ui.values.LLuaVirtualFileUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;

public class FileEditorService
implements FileEditorManagerListener,
FileEditorManagerListener.Before {
    private Project project;
    private static final int REFRESH_TIME = 500;
    private Timer timer;
    private TimerTask timerTask;
    private DocumentListener documentListener = new DocumentListener(){

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            if (FileEditorService.this.timerTask != null) {
                FileEditorService.this.timerTask.cancel();
            }
            FileEditorService.this.timer.schedule(FileEditorService.this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    BroadCastManager.getManager().sendAsync(Application.getApplicationContext(), BroadCastMessage.obtain("BC_PHOTO_PANEL_REFRESH"));
                }
            }, 500L);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/immomo/mmpaas/plugin/service/FileEditorService$1", "documentChanged"));
        }
    };
    private PreViewToolWindow preViewToolWindow;
    private Document lastAddLister = null;

    public FileEditorService(Project project) {
        this.project = project;
        this.timer = new Timer();
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)this);
    }

    public void fileOpenedSync(@NotNull FileEditorManager source, @NotNull VirtualFile file, @NotNull Pair<FileEditor[], FileEditorProvider[]> editors) {
        if (source == null) {
            FileEditorService.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileEditorService.$$$reportNull$$$0(1);
        }
        if (editors == null) {
            FileEditorService.$$$reportNull$$$0(2);
        }
    }

    public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            FileEditorService.$$$reportNull$$$0(3);
        }
        if (file == null) {
            FileEditorService.$$$reportNull$$$0(4);
        }
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            FileEditorService.$$$reportNull$$$0(5);
        }
        if (file == null) {
            FileEditorService.$$$reportNull$$$0(6);
        }
        if (FileTypeUtils.isLayoutFile(file) && source.getSelectedTextEditor() != null && this.documentListener != null) {
            if (this.lastAddLister == source.getSelectedTextEditor().getDocument()) {
                return;
            }
            try {
                if (this.lastAddLister != null) {
                    this.lastAddLister.removeDocumentListener(this.documentListener);
                }
                this.lastAddLister = source.getSelectedTextEditor().getDocument();
                this.lastAddLister.addDocumentListener(this.documentListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            FileEditorService.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileEditorService.$$$reportNull$$$0(8);
        }
        if (FileTypeUtils.isLayoutFile(file) && source.getSelectedTextEditor() != null && this.documentListener != null) {
            try {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null && this.lastAddLister != null && document == this.lastAddLister) {
                    document.removeDocumentListener(this.documentListener);
                    this.lastAddLister = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            FileEditorService.$$$reportNull$$$0(9);
        }
        if (file == null) {
            FileEditorService.$$$reportNull$$$0(10);
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            FileEditorService.$$$reportNull$$$0(11);
        }
        this.updateEditor(event);
        if (event.getOldFile() != null && FileTypeUtils.isLayoutFile(event.getOldFile())) {
            Document document = FileDocumentManager.getInstance().getDocument(event.getOldFile());
            try {
                if (document != null && this.lastAddLister != null) {
                    document.removeDocumentListener(this.documentListener);
                }
                if (this.lastAddLister == document) {
                    this.lastAddLister = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (event.getNewFile() != null && FileTypeUtils.isLayoutFile(event.getNewFile()) && event.getManager().getSelectedTextEditor() != null) {
            if (this.lastAddLister == event.getManager().getSelectedTextEditor().getDocument()) {
                return;
            }
            try {
                if (this.lastAddLister != null) {
                    this.lastAddLister.removeDocumentListener(this.documentListener);
                }
                this.lastAddLister = event.getManager().getSelectedTextEditor().getDocument();
                this.lastAddLister.addDocumentListener(this.documentListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private LuaPreviewEditor getPreviewEditor(VirtualFile file) {
        FileEditor[] editors;
        for (FileEditor item : editors = FileEditorManager.getInstance((Project)this.project).getAllEditors(file)) {
            if (!(item instanceof LuaPreviewEditor)) continue;
            return (LuaPreviewEditor)item;
        }
        return null;
    }

    private void updateEditor(FileEditorManagerEvent event) {
        boolean toggleWindow = false;
        VirtualFile oldfile = event.getOldFile();
        VirtualFile newfile = event.getNewFile();
        if (oldfile != null && newfile != oldfile) {
            FileEditor[] oldEditors;
            for (FileEditor item : oldEditors = FileEditorManager.getInstance((Project)this.project).getAllEditors(oldfile)) {
                if (item instanceof LuaPreviewEditor) {
                    ((LuaPreviewEditor)item).pause();
                }
                if (item != FileEditorManager.getInstance((Project)this.project).getSelectedEditor()) continue;
                toggleWindow = item.getFile() != null && FileTypeUtils.isLayoutFile(item.getFile()) && !(item instanceof LuaPreviewEditor);
            }
        }
        if (newfile != null) {
            FileEditor[] newEditors;
            for (FileEditor item : newEditors = FileEditorManager.getInstance((Project)this.project).getAllEditors(newfile)) {
                if (item instanceof LuaPreviewEditor) {
                    ((LuaPreviewEditor)item).resume();
                }
                if (item == FileEditorManager.getInstance((Project)this.project).getSelectedEditor()) {
                    boolean bl = toggleWindow = item.getFile() != null && FileTypeUtils.isLayoutFile(item.getFile()) && !(item instanceof LuaPreviewEditor);
                }
                if (toggleWindow) continue;
                toggleWindow = LLuaVirtualFileUtil.canShowPreviewEditor(item.getFile());
                toggleWindow = toggleWindow && !(item instanceof LuaPreviewEditor);
            }
        }
        this.dynamicToggleWindow(this.project, toggleWindow);
    }

    public void dynamicToggleWindow(Project project, boolean on) {
        if (on) {
            if (this.preViewToolWindow == null) {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow("preview", true, ToolWindowAnchor.RIGHT, true);
                this.preViewToolWindow = new PreViewToolWindow();
                this.preViewToolWindow.createToolWindowContent(project, toolWindow);
            }
        } else if (this.preViewToolWindow != null) {
            this.preViewToolWindow.dispose();
            this.preViewToolWindow = null;
            ToolWindowManager.getInstance((Project)project).unregisterToolWindow("preview");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/immomo/mmpaas/plugin/service/FileEditorService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpenedSync";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileOpened";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileClosed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

