/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.plugin.preview;

import com.immomo.mmpaas.plugin.FileTypeUtils;
import com.immomo.mmpaas.plugin.LuaPreviewEditor;
import com.immomo.mmpaas.plugin.preview.PreViewPanel;
import com.immomo.mmpaas.utils.Log;
import com.immomo.ui.values.LLuaVirtualFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PreViewToolWindow
implements ToolWindowFactory,
FileEditorManagerListener {
    private BorderLayoutPanel windowPanel;
    private PreViewPanel preViewPanel;
    private Project project;
    private ToolWindow toolWindow;
    private ComponentAdapter componentAdapter = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (PreViewToolWindow.this.preViewPanel != null) {
                    PreViewToolWindow.this.preViewPanel.initPanelIfNeed();
                }
            });
        }
    };
    private MessageBusConnection messageConnect;

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            PreViewToolWindow.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            PreViewToolWindow.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.toolWindow = toolWindow;
        this.windowPanel = new BorderLayoutPanel();
        this.windowPanel.addComponentListener((ComponentListener)this.componentAdapter);
        this.messageConnect = project.getMessageBus().connect();
        this.messageConnect.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        this.init(toolWindow);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            PreViewToolWindow.$$$reportNull$$$0(2);
        }
        Log.l("fuck sele", new Object[0]);
        VirtualFile newfile = event.getNewFile();
        FileEditor newEditor = event.getNewEditor();
        this.reBuildWindow(newfile, newEditor);
    }

    private void reBuildWindow(VirtualFile newfile, FileEditor newEditor) {
        if (!(!(newEditor instanceof LuaPreviewEditor) && newfile != null && FileTypeUtils.isLayoutFile(newfile) || LLuaVirtualFileUtil.canShowPreviewEditor(newfile))) {
            this.toolWindow.hide(null);
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(newfile);
        if (document == null) {
            this.toolWindow.hide(null);
            return;
        }
        if (this.preViewPanel != null) {
            this.preViewPanel.dispose();
        }
        this.preViewPanel = new PreViewPanel(this.project, document, newfile, false);
        if (this.windowPanel.getComponentCount() > 0) {
            this.windowPanel.removeAll();
        }
        this.windowPanel.add((Component)this.preViewPanel.getContentPanel());
        if (!this.toolWindow.isVisible()) {
            this.toolWindow.show(null);
        }
    }

    public void init(ToolWindow window) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent((JComponent)this.windowPanel, "", false);
        content.setCloseable(false);
        window.getContentManager().addContent(content);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
        if (fileEditor != null) {
            this.reBuildWindow(fileEditor.getFile(), fileEditor);
        }
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        if (project == null) {
            PreViewToolWindow.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean isDoNotActivateOnStart() {
        return false;
    }

    public void dispose() {
        if (this.preViewPanel != null) {
            this.preViewPanel.dispose();
            this.preViewPanel = null;
        }
        if (this.messageConnect != null) {
            this.messageConnect.deliverImmediately();
            this.messageConnect.disconnect();
            this.messageConnect = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/immomo/mmpaas/plugin/preview/PreViewToolWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBeAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

