/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.plugin.preview;

import com.immomo.mmpaas.PluginMain;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.main.MainBasePanel;
import com.immomo.mmpaas.plugin.FileTypeUtils;
import com.immomo.mmpaas.utils.Log;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class PreViewPanel
implements VirtualFileListener {
    private static final boolean debug = true;
    private final Project project;
    private Context context;
    private final VirtualFile file;
    protected final Document document;
    protected MainBasePanel mainBasePanel;
    protected final JBPanel contentPanel;
    private JBLabel loadingPanel;
    private boolean isInited;
    private boolean canEdit;

    public PreViewPanel(@NotNull Project project, @NotNull Document document, VirtualFile file, boolean canEdit) {
        if (project == null) {
            PreViewPanel.$$$reportNull$$$0(0);
        }
        if (document == null) {
            PreViewPanel.$$$reportNull$$$0(1);
        }
        this.contentPanel = new JBPanel((LayoutManager)new BorderLayout());
        this.canEdit = true;
        this.project = project;
        this.file = file;
        this.document = document;
        this.canEdit = canEdit;
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this);
        this.contentPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (PreViewPanel.this.mainBasePanel != null) {
                    PreViewPanel.this.mainBasePanel.getComponent().setPreferredSize(e.getComponent().getSize());
                }
            }
        });
        this.showLoading();
        this.initBaseCodeIfNeed();
    }

    public void start() {
        this.log("main");
        this.context = PluginMain.CreateContext((JComponent)this.contentPanel);
        this.isInited = true;
        this.initPanelIfNeed();
    }

    public void showLoading() {
        if (this.loadingPanel == null) {
            this.loadingPanel = new JBLabel("Loading...");
            this.loadingPanel.setVerticalAlignment(0);
            this.loadingPanel.setHorizontalAlignment(0);
            this.loadingPanel.setFont(new Font(null, 0, 32));
        }
        this.contentPanel.add((Component)this.loadingPanel, (Object)"Center");
    }

    public void initPanelIfNeed() {
        this.log("width: " + this.contentPanel.getWidth());
        if (this.mainBasePanel == null && this.isInited) {
            this.log("initPanelIfNeed");
            this.mainBasePanel = new MainBasePanel(this.context, this.canEdit);
            this.mainBasePanel.getComponent().setPreferredSize(new Dimension(this.contentPanel.getWidth(), this.contentPanel.getHeight()));
            this.mainBasePanel.build();
            this.contentPanel.remove((Component)this.loadingPanel);
            this.contentPanel.add((Component)this.mainBasePanel.getComponent());
            this.mainBasePanel.setFilePath(this.file.getPath(), this.file);
        }
    }

    public void initBaseCodeIfNeed() {
        String str = this.document.getText();
        str = str.replace("\t", "").replace("\n", "");
        if (!FileTypeUtils.isLayoutFile(this.file) || !TextUtils.isEmpty((CharSequence)str)) {
            this.start();
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.document.setText((CharSequence)"return {\n\tview = View(),\n\twidth = MeasurementType.MATCH_PARENT,\n\theight = MeasurementType.MATCH_PARENT,\n}\n");
            if (!this.isInited) {
                this.start();
            }
        });
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PreViewPanel.$$$reportNull$$$0(2);
        }
        if (!event.getFile().equals(this.file)) {
            return;
        }
        if (!this.isInited) {
            this.start();
        }
    }

    public void resume() {
        if (this.mainBasePanel != null) {
            this.mainBasePanel.onResume();
        }
    }

    public void pause() {
        if (this.mainBasePanel != null) {
            this.mainBasePanel.onPause();
        }
    }

    public JBPanel getContentPanel() {
        return this.contentPanel;
    }

    public VirtualFile getFile() {
        return this.file;
    }

    public Context getContext() {
        return this.context;
    }

    public void dispose() {
        this.log("dispose");
        if (this.mainBasePanel != null) {
            this.mainBasePanel.destroy();
            this.mainBasePanel = null;
        }
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
    }

    private void log(String msg) {
        Log.l(msg, new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/immomo/mmpaas/plugin/preview/PreViewPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

