/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.plugin;

import com.immomo.mmpaas.GlobalConfigManager;
import com.immomo.mmpaas.PluginMain;
import com.immomo.mmpaas.plugin.service.FileEditorService;
import com.immomo.mmpaas.plugin.service.LayoutFileService;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class MMPassProject
implements ProjectComponent {
    private final Project project;
    private LayoutFileService layoutFileService;

    public MMPassProject(Project project) {
        this.project = project;
        GlobalConfigManager.getInstance().getPreViewConfigBean().setProjectPath(project.getBasePath());
        PluginMain.main();
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return "MMPass";
    }

    public void projectOpened() {
        if (this.layoutFileService == null) {
            this.layoutFileService = (LayoutFileService)ServiceManager.getService((Project)this.project, LayoutFileService.class);
        }
        this.layoutFileService.open();
        FileEditorService fileEditorService = new FileEditorService(this.project);
        this.project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorService);
    }

    public void projectClosed() {
        if (this.layoutFileService != null) {
            this.layoutFileService.close();
            this.layoutFileService = null;
        }
    }
}

