/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmpaas.panel.virtual.view;

import com.immomo.mlservics.utils.DimenUtil;
import com.immomo.mlservics.utils.RoomScalManager;
import com.immomo.mmpaas.Application;
import com.immomo.mmpaas.GlobalConfigManager;
import com.immomo.mmpaas.base.BasePanel;
import com.immomo.mmpaas.base.Context;
import com.immomo.mmpaas.base.broadcast.BroadCastMessage;
import com.immomo.mmpaas.panel.design.weight.WindowTreeScrollBarUI;
import com.immomo.mmpaas.panel.virtual.base.IVirtualPhone;
import com.immomo.mmpaas.panel.virtual.view.HierarchyView;
import com.immomo.mmpaas.panel.virtual.view.PhoneTouchView;
import com.immomo.mmpaas.panel.virtual.weight.VirtualStateBar;
import com.immomo.mmpaas.utils.ColorConstants;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class VirtualPhoneView
extends BasePanel
implements IVirtualPhone {
    private final Context context;
    private final JPanel phonePanel;
    private JComponent decorView;
    private JComponent luaContainer;
    private VirtualStateBar stateBar;
    private HierarchyView hierarchyView;
    private PhoneTouchView touchView;
    private int stateBarStyle = 2;
    private int stateHeight = 28;
    private RoomScalManager roomScalManager;
    private JPanel scrollContainer;
    private JBScrollPane scrollview;

    public VirtualPhoneView(Context context2, JPanel panel) {
        super(context2);
        this.context = context2;
        this.phonePanel = panel;
        this.roomScalManager = new RoomScalManager();
        this.initView();
    }

    private void initView() {
        this.processLuaContainerBounds();
        Rectangle bounds = this.roomScalManager.getRect();
        this.decorView = new JPanel();
        this.decorView.setLayout(null);
        this.decorView.setBackground(this.context.getTheme().panelBackground);
        this.decorView.setSize(bounds.getSize());
        this.scrollContainer = new JPanel(null);
        this.scrollContainer.setBackground(this.context.getTheme().panelBackground);
        this.scrollContainer.add(this.decorView);
        this.scrollview = new JBScrollPane();
        this.scrollview.setBorder(null);
        this.scrollview.getVerticalScrollBar().setUI(new WindowTreeScrollBarUI());
        this.scrollview.addMouseWheelListener((MouseWheelListener)this.roomScalManager.getMouseWheelListener());
        this.scrollview.setViewportView((Component)this.scrollContainer);
        this.scrollContainer.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VirtualPhoneView.this.context.sendBroadCastMessage(BroadCastMessage.obtain("BC_HIERARCHY_EXIT"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.stateBar = new VirtualStateBar(this.context);
        this.stateBar.reset(bounds.width, this.stateHeight);
        this.luaContainer = new JPanel();
        this.luaContainer.setLayout(null);
        this.touchView = new PhoneTouchView(this.context, this);
        this.hierarchyView = new HierarchyView(this.context, this.luaContainer);
        this.decorView.add(this.stateBar.getComponent());
        this.decorView.add(this.luaContainer);
        this.scrollContainer.add(this.hierarchyView.getComponent(), 0);
        this.scrollContainer.add(this.touchView.getComponent(), 0);
        this.phonePanel.add((Component)this.scrollview, "Center");
        this.registerChildLifeCycle(this.stateBar);
        this.registerChildLifeCycle(this.hierarchyView);
        this.registerChildLifeCycle(this.touchView);
        this.resetPhoneBounds();
    }

    public JComponent getLuaContainer() {
        return this.luaContainer;
    }

    public JComponent getDecorView() {
        return this.decorView;
    }

    public void processLuaContainerBounds() {
        Dimension dimension = new Dimension(this.phonePanel.getSize());
        dimension.height -= 30;
        this.roomScalManager.processLuaContainerBounds(dimension, this.luaContainer);
    }

    public void setSizeScale(float sizeScale) {
        this.roomScalManager.setSizeScale(sizeScale);
    }

    public float getSizeScale() {
        return this.roomScalManager.getSizeScale();
    }

    public void setMatchParent(boolean isMatchParent) {
        this.roomScalManager.setMatchParent(isMatchParent);
    }

    public boolean isMatchParent() {
        return this.roomScalManager.isMatchParent();
    }

    public void resetPhoneBounds() {
        this.stateBarStyle = GlobalConfigManager.getInstance().getPreViewConfigBean().getStateBarStyle();
        Rectangle bounds = this.roomScalManager.getRect();
        this.decorView.setLocation(bounds.getLocation().x, bounds.getLocation().y);
        int containerW = this.scrollview.getSize().width > bounds.width ? this.scrollview.getSize().width - 2 : bounds.width + Math.abs(bounds.getLocation().x) * 2;
        int containerH = this.scrollview.getSize().height > bounds.height ? this.scrollview.getSize().height - 2 : bounds.height + Math.abs(bounds.getLocation().y) * 2;
        this.scrollContainer.setPreferredSize(new Dimension(containerW, containerH));
        int marginTop = 0;
        int stateHeightReal = DimenUtil.dpiToPx(this.stateHeight);
        Color stateBG = Application.getApplicationContext().getTheme().phoneTheme;
        switch (this.stateBarStyle) {
            case 1: {
                stateHeightReal = 0;
                marginTop = 0;
                break;
            }
            case 2: {
                marginTop = stateHeightReal;
                break;
            }
            case 3: {
                marginTop = 0;
                stateBG = ColorConstants.TRANSPARENT;
            }
        }
        this.decorView.setSize(bounds.getSize().width, bounds.getSize().height + marginTop);
        this.stateBar.reset(bounds.width, stateHeightReal);
        this.stateBar.getComponent().setBackground(stateBG);
        this.luaContainer.setLocation(0, marginTop);
        this.luaContainer.setSize(bounds.getSize());
        this.hierarchyView.getComponent().setBounds(bounds.getLocation().x, bounds.getLocation().y + marginTop, bounds.width, bounds.height);
        this.touchView.getComponent().setBounds(bounds.getLocation().x, bounds.getLocation().y + marginTop, bounds.width, bounds.height);
    }

    @Override
    public void setStateBarStyle(int style) {
        this.stateBarStyle = style;
        this.resetPhoneBounds();
    }

    @Override
    public void destroy() {
        if (this.touchView != null) {
            this.touchView.destroy();
        }
        if (this.hierarchyView != null) {
            this.hierarchyView.destroy();
        }
    }

    @Override
    public JComponent getComponent() {
        return null;
    }
}

